% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function [P, BIC, L]=testmc(fl,maxorder, s, time, month, st)
%this is a function to test the order of a mc by BIC (Katz 1981). 
% fl indicator to estimate transitional probabilities,  maxorder max order to test against, time dates of
% the observations, s number of states, month is the calender month to
% select from the data, st mc realizations.
ns=size(st,2);
years=unique(time(:,1));
lmonth=length(time(time(time(:,1)==years(1),2)==month));
L=NaN(maxorder+1,ns); %matrix for max Likelihood 
BIC=NaN(maxorder,ns); %matrix for BIC
P=NaN(2,2,ns);% transitional probs
for j=1:ns; %loop over stations
    for i=1:maxorder
        tbl=zeros(s^i,s);
        for l=1:size(years,1)
            y0=[];
            for k=0:i-1
                ind=find(time(:,1)==years(l) & time(:,2)==month);
                y0=[y0 st((min(ind)-i+k):(max(ind)-i+k),j)];
            end;
            y1=st(ind,j);
            %w=s^i-size(crosstab(y0,y1),1);
            tbl=tbl+ctbl(y1,y0,i);
        end;
        tblsum=repmat(sum(tbl,2),1,size(tbl,2));
        phat=tbl./tblsum;
        if fl==1
        P(:,:,j)=phat;
        end
        L(i+1,j)=prod(prod(tbl.*phat));
    end;
        phat0=sum(tbl,1)./sum(sum(tbl,1));
        L(1,j)=prod([length(y1)-sum(y1) sum(y1)].*phat0);
    for h=1:maxorder
        BIC(h,j)=-2*log(L(h,j)./L(end,j))-(s^maxorder-s^h)*(s-1)*log(size(years,1)*lmonth);
    end
 end;