
% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------function [dx, Ix]=rsimtscorx(grid,N,T,rho, mu, mun, mum,sigma, sigman,sigmam,crit,P)

% function for simulating cumrainfall cumulative wetness dx, 
% income Ix , from starting grid (grid) with given
% past states of MC,  N number of simulations, 
% T number of days to simulate, rho correlations of w_t, %mu vector of means for incomes,
%sigma vector of variances for incomes

corrmat=[1 rho 0; rho 1 0; 0 0 1];
p11=[P(2,2,1) P(2,2,2)];
pp0=[P(1,2,1) P(1,2,2)];
dx=NaN(N,length(grid));

parfor k=1:N
x=zeros(T,2); 
pp=pp0;
dxb=NaN(1,length(grid));
for i=1:T
    w=mvnrnd(zeros(size(corrmat,1),1),corrmat);
    for j=1:length(grid)
        if w(j)<=norminv(pp(j),0,1)
            pp(j)=P(2,2,j);
            x(i,j)=1;
        else pp(j)=P(1,2,j);
        end
        
    end;
    
end;
for h=1:2
xb=x(:,h);
dxb(h)=size(xb(xb>0),1);
end;
dx(k,:)=dxb;
end

% wet days index income
Ix=NaN(size(dx,1),1);
dx=dx-crit; %only wet days over crit count: dx=max(0,sum(x_t)-crit)
dx(dx<0)=0;
wx=dx;
wx(wx>0)=1;
Ix(:,1) = (ones(N,1)*mum(1)+sqrt(sigmam(1))*randn(N,1)).*wx(:,1).*wx(:,2)+(ones(N,1)*mun(1)+sqrt(sigman(1))*randn(N,1)).*(ones(N,1)-wx(:,2)).*wx(:,1)+(ones(N,1)*mun(1)+sqrt(sigman(1))*randn(N,1)).*(ones(N,1)-wx(:,1)).*wx(:,2)+(ones(N,1)*mu(1)+sqrt(sigma(1))*randn(N,1)).*(ones(N,1)-wx(:,1)).*(ones(N,1)-wx(:,2));



