% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function [rx1, rx2,I, stss, rpath]=rsimtscor(grid,states,N,T,rho,rhor,corrmatre, corrmatI, mu,sigma,P,param)

% function for simulating cumrainfall rx1 and rx2
% income I , resulting states stss and rainfall path rpath from starting grid (grid) with given
% past states of MC,  N number of simulations, 
% T number of days to simulate, rho correlations of w_t,rhor correlations
% of v_t, corrmatre empirical correlation matrix of rainfall, corrmatI
% correlations of the Incomes with the cumulative rainfall of the three
% stations, %mu vector of means for incomes,
%sigma vector of variances for incomes, P
%is the matrix of transitional probabilities for mc of the first order, N number of simulations.
%param parameters ofthe mixture of exponentials.

corrmat=[1 rho 0; rho 1 0; 0 0 1];
corrmatr=[1 rhor 0; rhor 1 0; 0 0 1];
rx1=NaN(N,length(grid)); rx2=NaN(N,length(grid)); stss=zeros(N,length(grid));
b0=param(:,3); 
p11=[P(2,2,1) P(2,2,2) P(2,2,3)];
pp0=[P(1,2,1) P(1,2,2) P(1,2,3)];
pp0(states==1)=p11(states==1);
rhoI1=corrmatI(1,:); rhoI2=corrmatI(2,:);
rain=NaN(T,3,N);


parfor k=1:N
b=b0;
x=zeros(T,3); 
pp=pp0;
sts=zeros(1,3);
for i=1:T
    w=mvnrnd(zeros(size(corrmat,1),1),corrmat);
    z=mvnrnd(zeros(size(corrmatr,1),1),corrmatr);
    for j=1:length(grid)
        if w(j)<=norminv(pp(j),0,1)
            if normcdf(w(j),0,1)/pp(j)<=param(j,1);
                b(j)=param(j,2);   
            else b(j)=param(j,3);
            end;
            pp(j)=P(2,2,j);
            sts(j)=1; %end state of a mc
            x(i,j)=0.1-b(j)*log(normcdf(z(j),0,1));
        else pp(j)=P(1,2,j);
        end
        
    end;
    
end;
for h=1:3
xb=x(:,h);
end;
rx(k,:)=grid+sum(x);
stss(k,:)=sts;
rain(:,:,k)=cumsum(x,1);
end
rpath=rain(:,:,end);
I=NaN(size(rx,1),2);

invCDF1 = sort(rx(:,1)); n1 = length(rx(:,1));
invCDF2 = sort(rx(:,2)); n2 = length(rx(:,2));
invCDF3 = sort(rx(:,3)); n3 = length(rx(:,3));
M1 = mvnrnd([0 0 0 0],[1 rhoI1(1) rhoI1(2) rhoI1(3); rhoI1(1) 1 corrmatre(1,2) corrmatre(1,3); 
   rhoI1(2) corrmatre(2,1) 1 corrmatre(2,3); rhoI1(3) corrmatre(1,3) corrmatre(2,3) 1], N);
M2 = mvnrnd([0 0 0 0],[1 rhoI2(1) rhoI2(2) rhoI2(3); rhoI2(1) 1 corrmatre(1,2) corrmatre(1,3); 
   rhoI2(2) corrmatre(2,1) 1 corrmatre(2,3); rhoI2(3) corrmatre(1,3) corrmatre(2,3) 1], N);
U1 = normcdf(M1);
U2 = normcdf(M2);
I(:,1) = norminv(U1(:,1),mu(1),sigma(1));
I(:,2) = norminv(U2(:,1),mu(2),sigma(2));
rx1(:,1)=invCDF1(ceil(n1*U1(:,2)));
rx1(:,2)=invCDF2(ceil(n2*U1(:,3)));
rx1(:,3)=invCDF3(ceil(n3*U1(:,4)));

rx2(:,1)=invCDF1(ceil(n1*U2(:,2)));
rx2(:,2)=invCDF2(ceil(n2*U2(:,3)));
rx2(:,3)=invCDF3(ceil(n3*U2(:,4)));




