% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function cx=rsim(rho,rhor, P, N, param)

%function to simulate mc x. corrmat is the correlation matrix of w_t's, P
%is the matrix of transitional probabilities for mc of the first order, N number of simulations.

corrmat=[1 rho; rho 1];
corrmatr=[1 rhor; rhor 1];


b=param(:,3);
x=zeros(N,2);
pp=[P(1,2,1) P(1,2,2) P(1,2,3)];

for i=1:N
    w=mvnrnd(zeros(size(corrmat,1),1),corrmat);
    z=mvnrnd(zeros(size(corrmatr,1),1),corrmatr);
    for j=1:2
        if w(j)<=norminv(pp(j),0,1)
            if normcdf(w(j),0,1)/pp(j)<=param(j,1);
                b(j)=param(j,2);   
            else b(j)=param(j,3);
            end;
            pp(j)=P(2,2,j);
            x(i,j)=0.1-b(j)*log(normcdf(z(j),0,1));
        else  pp(j)=P(1,2,j);
        end
    end;
end;
c=corr(x);
cx=round(c(1,2)*100)/100;

  


