% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function [param cumaver]=mixe(ns, time, month,rainmm)
% this is a function to estimate parameters of the mixed exponential
% distribution via ML. ns number of stations, time is the dates of the
% observations, month target month, rainmm is the data.
years=unique(time(:,1));
pdf_expm = @(x,p,mu1,mu2) p*exppdf(x,mu1) + (1-p)*exppdf(x,mu2);
           pStart = .5;
           muStart = [10 0.5];
           start = [pStart muStart];
param=NaN(ns,3);
cumaver=NaN(ns,1);
options = statset('MaxIter',10000, 'MaxFunEvals',10000);
for j=1:ns; %loop over stations
    r=[];    
    for l=1:size(years,1)
           
        ind=find(time(:,1)==years(l) & time(:,2)==month);
        r=[r; rainmm((min(ind)):(max(ind)),j)];
   
           
    end;
    r=r(r>0);
    cumaver(j)=sum(r,1)./size(years,1);
    param(j,:)=mle(r, 'pdf',pdf_expm, 'start',start,...
                'options',options);
    
end;
