% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function [tbl,lab0,lab1]=ctbl(y1,y0,o);
%ctbl computes number of transitions from states in y0 to y1 in 0-1-state
%mc of order o.
y=[y0 y1];
allperms = cell2mat(arrayfun(@(b) {bitget((0:2^o-1).',b)},o:-1:1));
allperms1 = [allperms ones(size(allperms,1),1)];
allperms0 = [allperms zeros(size(allperms,1),1)];
lab0=num2str(allperms0);
lab1=num2str(allperms1);
tbl=NaN(size(allperms,1),2);
for i=1:size(allperms,1)
    tbl(i,1)=sum(all(y==repmat(allperms0(i,:),size(y,1),1),2));
    tbl(i,2)=sum(all(y==repmat(allperms1(i,:),size(y,1),1),2));
end;