% ---------------------------------------------------------------------

% Article:      Pricing Chinese rain: a multisite multi-period equilibrium pricing model for rainfall derivatives

% ---------------------------------------------------------------------

% Quantlet:     HaeOsiRain

% ---------------------------------------------------------------------

% Description:  Illustrates Pricing rainfall derivatives on the data of
%               China

% ---------------------------------------------------------------------

% Usage:        is called by HaeOsiRain.m

% ---------------------------------------------------------------------

% Inputs:       raindata.mat

% ---------------------------------------------------------------------

% Output:       Plot and tables in the paper             

% ---------------------------------------------------------------------

% Example:      -

% ---------------------------------------------------------------------

% Author:       Maria Osipenko

% ---------------------------------------------------------------------
function [corrmatmc, corrmatr, N]=corrmc(ns, time, month,rainmm,st)

years=unique(time(:,1));
R=NaN(100000,ns);
S=NaN(100000,ns);
for j=1:ns; %loop over stations
    r=[];  s=[];  
    for l=1:size(years,1)
           
        ind=find(time(:,1)==years(l) & time(:,2)==month);
        r=[r; rainmm((min(ind)):(max(ind)),j)];
        s=[s; st((min(ind)):(max(ind)),j)];   
    end;
    R(1:length(r),j)=r;
    S(1:length(s),j)=s;
end;
N=length(r);
R=R(1:N,:);S=S(1:N,:);
corrmatmc=corr(S);
corrmatr=corr(R);