% function nantozero.m replaces any NaN in "matrix_in" by zero
% copyright : Emanuel Mnch, Humboldt University Berlin, June 2003, 
% Email: moench@wiwi.hu-berlin.de  

function matrix_out = nantozero(matrix_in);

[rows,cols] = size(matrix_in);
matrix_out = zeros(rows,cols);
for i = 1 : rows;
    for j = 1:cols,
        if isnan(matrix_in(i,j)),
            matrix_out(i,j) = 0;
        else matrix_out(i,j) = matrix_in(i,j);
        end;
    end;
end;
