% function ipol_diag_bgw.m performs a diagnosis of the quality of the Kalman
% Filter interpolation using R2 measures of fit following 
% Bernanke, Gertler, and Watson (1997): "Systematic Monetary Policy and the Effects of Oil Price Shocks", 
% Brookings Papers on Economic Activity, 1997(1), 91-157.
% copyright : Emanuel Mnch, Humboldt University Berlin, June 2003, 
% Email: moench@wiwi.hu-berlin.de  

function [r_square_ipol, r_square_ipol_smoothed] = ipol_diag_bgw(y_ipol,y_ipol_smoothed,P_TT_out,P_smoothed);

trunc = 48;

var_y_ipol = std(y_ipol(trunc+1:length(y_ipol)))*std(y_ipol(trunc+1:length(y_ipol)));
var_u_ipol = sum(P_TT_out(1,1,trunc+1:length(P_TT_out)));
r_square_ipol = var_y_ipol/(var_y_ipol+var_u_ipol);

var_y_ipol_smoothed = std(y_ipol_smoothed(trunc+1:length(y_ipol_smoothed)))*std(y_ipol_smoothed(trunc+1:length(y_ipol_smoothed)));
var_u_ipol_smoothed = sum(P_smoothed(1,1,1:length(P_smoothed)-trunc-1));
r_square_ipol_smoothed = var_y_ipol_smoothed/(var_y_ipol_smoothed + var_u_ipol_smoothed);







