library("xplore")
library("plot")
library("distribs")

;*************************
proc(x)=enf(data)
x = maxrank(data)/(rows(data)+1)
endp
;***************************
proc (r) = maxrank (x)
  i  = 1:rows (x)
  o  = sort (x~i)[,2]
  r  = sort (o~i)[,2]
  i2 = sort (x~r, 1|-2)[,2]
  c=(i+i2)
  z=discrete(c)
  d=floor(z.xr/2+floor(z.yr/2))
  h=d~(diff(0|d))
  a=h[1,1]*matrix(h[1,2],1)
  iii=2
  while(iii<=rows(h))
    m=h[iii,1]*matrix(h[iii,2],1)
    a=a|m
    iii=iii+1
  endo
  r=a [r]

endp
;**********************************
proc(y) = gammaln(x)
  h = pdfcdfraninit()
  error(exist(x) != 1, "gammaln: a number or an array has to be supplied!")
  len = prod(dim(x))
  y = x
    err = dlcall(h, "pdfcdfran_gammaln_array", y, len)
endp

;***********************************
proc(c)=tcopula(u,v,r,s1,s2,n)
u=qft2(u,n)
v=qft2(v,n)
k1=(1-(r^2))^(-0.5)
lk1=log(k1)
lk2=gammaln((n+2)/2)+gammaln(n/2)-2*gammaln((n+1)/2)
i1=1/(n*k1).*((u/s1)^2-2*r.*(u).*(v)+(v/s2)^2)

i2=(u.^2)./n
i3=(v.^2)./n
lk3=log(1+i1)
lk4=log(1+i2)+log(1+i3)
lc=lk1+lk2-((n+2)/2).*lk3+((n+1)/2).*lk4
c=exp(lc)

endp

;***************************************
proc (t)=AMH(u,v,theta)
      t2 = theta.*v
      t3 = theta.*u
      t4 = t2.*u
      t5 = theta^2
      t6 = t5.*v
      t10 = -1.0+theta-t2-t3+t4
      t11 = t10^2
      t = -(1.0-2.0.*theta+t2+t3+t4+t5-t6-t5.*u+t6.*u)/t11/t10
endp
;****************************************
proc (t)=frank(u,v,theta); 
      t3 = exp(-theta.*(u+v+1.0))
      t6 = exp(-theta.*(u+v))
      t9 = exp(-theta)
      t11 = exp(-theta*u)
      t13 = exp(-theta*v)
      t15 = (t9+t6-t11-t13)^(2.0)
      t = -theta.*(t3-t6)/t15
endp
;*****************************************
proc (t)=gumbel(u,v,theta)


      t1 = log(u)
      t2 = (-t1)^(1.0.*theta)
      t3 = log(v)
      t4 = (-t3)^(1.0.*theta)
      t5 = t2+t4
      t6 = 1/theta
      t7 = t5^(1.0.*t6)
      t8 = exp(-t7)
      t9 = t2.*t4
      t16 = t5^(-2.0.*(-1.0+theta).*t6)
      t18 = 3.0.*theta
      t19 = (-t1)^(1.0.*t18)
      t21 = 2.0.*theta
      t22 = (-t1)^(1.0.*t21)
      t24 = (-t3)^(1.0.*t21)
      t28 = (-t3)^(1.0.*t18)
      t = t8.*(-t9.*t7+t9.*t7.*theta+t4.*t16.*t19+2.0.*t16.*t22.*t24+t2.*t16.*t28)/v/t3/u/t1/(t22+2.0.*t9+t24)
endp
;*************************************
proc(t)=nor(u,v,theta)

t1=u
t2=v
t3=(1-(theta^2))
t3=t3^(-1)
t=(t3^2).*exp(-0.5.*t3.*((t1^2)+(t2^2)-(2.*theta.*t1.*t2))).*exp(0.5.*(t1^2+t2^2))

endp
;*****************************************


proc()=contourdensity(gr,dens)
f=dens

; prepares for contour plot at values 0.5, 0.25, 0.1 and 1.3 times max density
z = sort(gr~f, #(1,2,3))
co1 = contour2(z, max(f)./2)
co2 = contour2(z, max(f)./4)
co3 = contour2(z, max(f)./8)
co4 = contour2(z, max(f).*0.75)
co5 = contour2(z, max(f)./16)
hh=(co1.retp~(max(f)./2).*matrix(rows(co1.retp)))|(co4.retp~(max(f).*0.75).*matrix(rows(co4.retp)))|(co5.retp~(max(f)./16).*matrix(rows(co5.retp)))
; prepares and plots graphics
co1=setmask(hh,"tiny","red")
co2=setmask(co2.retp~(max(f)./4).*matrix(rows(co2.retp)),"tiny","red")
co3=setmask(co3.retp~(max(f)./8).*matrix(rows(co3.retp)),"tiny","red")
;co4=setmask(co4.retp~(max(f).*0.75).*matrix(rows(co4.retp)),"tiny","red")
a=setmask(gr~f,"tiny","black")
plot3d(1,a,co1,co2,co3)

endp
;******************************************
proc()=contourdensitydense(gr,dens)
f=dens

; prepares for contour plot at values 0.5, 0.25, 0.1 and 1.3 times max density
z = sort(gr~f, #(1,2,3))
co1 = contour2(z, max(f)./2)
co2 = contour2(z, max(f)./4)
co3 = contour2(z, max(f)./8)
co4 = contour2(z, max(f).*0.75)
co5 = contour2(z, max(f)./16)
co6 = contour2(z, max(f)./32)
co7 = contour2(z, max(f)./64)
co8 = contour2(z, max(f)./128)
co9 = contour2(z, max(f)./256)
hh=(co1.retp~(max(f)./2).*matrix(rows(co1.retp)))|(co4.retp~(max(f).*0.75).*matrix(rows(co4.retp)))|(co5.retp~(max(f)./16).*matrix(rows(co5.retp)))|(co2.retp~(max(f)./4).*matrix(rows(co2.retp)))|(co3.retp~(max(f)./8).*matrix(rows(co3.retp))|(co6.retp~(max(f)./32).*matrix(rows(co6.retp)))|(co7.retp~(max(f)./64).*matrix(rows(co7.retp)))|(co8.retp~(max(f)./128).*matrix(rows(co8.retp)))|(co9.retp~(max(f)./256).*matrix(rows(co9.retp))))
; prepares and plots graphics
co1=setmask(hh,"tiny","red")

a=setmask(gr~f,"tiny","black")

plot3d(1,a,co1)

endp
;************************************************
proc(z,cz)=contourcolor(gr,dens,ngr,cdens)
f=dens
cf=cdens
; prepares for contour plot at values 0.5, 0.25, 0.1 and 1.3 times max density
z = sort(gr~f, #(3,1,2))
r=rows(z)/6
z1=z[1:r]
z2=z[r+1:2*r]
z3=z[2*r+1:3*r]
z4=z[3*r+1:4*r]
z5=z[4*r+1:5*r]
z6=z[5*r+1:6*r]

z=z1|z2|z3|z4|z5|z6
mycolor=1.*(matrix(rows(z1)))|3.*matrix(rows(z2))|2.*matrix(rows(z3))|6.*matrix(rows(z4))|5.*matrix(rows(z5))|4.*matrix(rows(z6))

cz = sort(ngr~cf, #(3,1,2))
cr=rows(cz)/6
cz1=cz[1:cr]
cz2=cz[cr+1:2*cr]
cz3=cz[2*cr+1:3*cr]
cz4=cz[3*cr+1:4*cr]
cz5=cz[4*cr+1:5*cr]
cz6=cz[5*cr+1:6*cr]

cz=cz1|cz2|cz3|cz4|cz5|cz6
cmycolor=1.*(matrix(rows(cz1)))|3.*matrix(rows(cz2))|2.*matrix(rows(cz3))|6.*matrix(rows(cz4))|5.*matrix(rows(cz5))|4.*matrix(rows(cz6))


z=setmask(z,"color",mycolor,"fillcircle","tiny")
cz=setmask(cz,"color",cmycolor,"fillcircle","tiny")


;disp=createdisplay(1,2)
;show(disp,1,1,cz)
;show(disp,1,2,z)
;plot3d(1,z)

endp

;************************************
; creates grids for unit square and pdfs
; creates marginal distributions normal or t 
; creates grid and columns in each dimension

; grid unit square
ngr=grid(#(0.01,0.01),#(0.01,0.01),#(100,100))
ngr1=ngr[,1]
ngr2=ngr[,2]

; grid
gr=grid(#(-4,-4),#(0.1,0.1),#(80,80))
gr1=gr[,1]
gr2=gr[,2]

; calculates pdfn for the margins
m1=pdfn2(gr1)
m2=pdfn2(gr2)

; transforms grid
F1=cdfn2(gr1)
F2=cdfn2(gr2)

; t margins
;m1=pdft2(gr1,3)F1=cdft2(gr1,3)
;m2=pdft2(gr2,3)F2=cdft2(gr2,3)

;******************************************************
; Examples

;; gaussian copula, biv normal
; c=nor(F1,F2,0.2)
; cc=nor(ngr1,ngr2,0.1)
; AMH copula
;c=AMH(F1,F2,0.9)
;cc=AMH(ngr1,ngr2,0.9)
; Frank copula
;c=frank(F1,F2,3)
;cc=frank(ngr1,ngr2,3)
; Gumbel copula
;c=gumbel(F1,F2,2)
;cc=gumbel(ngr1,ngr2,2)

; t margins
;m1=pdft2(gr1,3)F1=cdft2(gr1,3)
;m2=pdft2(gr2,3)F2=cdft2(gr2,3)
c=tcopula(F1,F2,0.2,1,1,3)

cc=tcopula(ngr1,ngr2,0.2,1,1,5)

cG=cc
G=c.*m1.*m2

;*********************************
; Color Examples

g=contourcolor(gr,G,ngr,cG)

;;;;;;pdf
;;;;;;plot3d(1,g.z)

;copula density
plot3d(1,g.cz)

;setgopt(plot3disp,1,1,"border",0)

;******************************************
; contourdensity(gr,G)
;******************************************
;contourdensitydense(gr,G)


