/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.network;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class SimpleObjectRegistry {
    static final int DEFAULT_LOW_PORT = 1099;
    static final int DEFAULT_HIGH_PORT = 1108;
    private Registry registry = null;
    private int port;

    public static Remote findObject(String name, String host, int lowPort, int highPort) throws NotBoundException {
        boolean aRegistryFound = false;
        for (int rport = lowPort; rport <= highPort; ++rport) {
            try {
                return LocateRegistry.getRegistry(host, rport).lookup(name);
            }
            catch (NotBoundException e) {
                aRegistryFound = true;
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (aRegistryFound) {
            throw new NotBoundException("name not bound in any registry on " + host + ": " + name);
        }
        throw new NotBoundException("no registries found on " + host + ", ports " + lowPort + ".." + highPort);
    }

    public static Remote findObject(String name, String host) throws NotBoundException {
        return SimpleObjectRegistry.findObject(name, host, 1099, 1108);
    }

    public static Remote findObject(String name, String[] hosts, int lowPort, int highPort) throws NotBoundException {
        boolean aRegistryFound = false;
        for (int i = 0; i < hosts.length; ++i) {
            try {
                return SimpleObjectRegistry.findObject(name, hosts[i], lowPort, highPort);
            }
            catch (NotBoundException e) {
                if (e.getMessage().startsWith("name not bound")) continue;
                aRegistryFound = true;
                continue;
            }
        }
        if (aRegistryFound) {
            throw new NotBoundException("name not bound on any host: " + name);
        }
        throw new NotBoundException("registry not found on any host");
    }

    public static Remote findObject(String name, String[] hosts) throws NotBoundException {
        return SimpleObjectRegistry.findObject(name, hosts, 1099, 1108);
    }

    public SimpleObjectRegistry(int lowPort, int highPort) throws RemoteException {
        this.port = lowPort;
        while (this.port <= highPort) {
            try {
                this.registry = LocateRegistry.createRegistry(this.port);
                return;
            }
            catch (RemoteException remoteException) {
                ++this.port;
            }
        }
        this.port = lowPort;
        while (this.port <= highPort) {
            try {
                this.registry = LocateRegistry.getRegistry(this.port);
                return;
            }
            catch (RemoteException remoteException) {
                ++this.port;
            }
        }
        throw new RemoteException("no port available");
    }

    public SimpleObjectRegistry(int port) throws RemoteException {
        this(port, port);
    }

    public SimpleObjectRegistry() throws RemoteException {
        this(1099, 1108);
    }

    public int port() {
        return this.port;
    }

    public synchronized void rebind(String name, Remote value) {
        if (this.registry == null) {
            throw new IllegalStateException("registry not active");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        try {
            this.registry.rebind(name, value);
        }
        catch (Exception e2) {
            RuntimeException e2;
            if (!(e2 instanceof RuntimeException)) {
                e2 = new RuntimeException("unexpected exception in SimpleObjectRegistry.rebind: " + e2);
            }
            throw (RuntimeException)e2;
        }
    }

    public synchronized void unbind(String name) {
        if (this.registry == null) {
            throw new IllegalStateException("registry not active");
        }
        try {
            this.registry.unbind(name);
        }
        catch (NotBoundException notBoundException) {
        }
        catch (Exception e2) {
            RuntimeException e2;
            if (!(e2 instanceof RuntimeException)) {
                e2 = new RuntimeException("unexpected exception in SimpleObjectRegistry.unbind: " + e2);
            }
            throw (RuntimeException)e2;
        }
    }

    public synchronized void close() {
        if (this.registry == null) {
            return;
        }
        try {
            String[] names = null;
            names = this.registry.list();
            for (int i = 0; i < names.length; ++i) {
                this.unbind(names[i]);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
        }
        finally {
            this.registry = null;
            this.port = -1;
        }
    }
}

