/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.network;

import edu.caltech.ssel.multistage.shared.network.Mailbox;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.List;

public class QueuedMailbox
extends UnicastRemoteObject
implements Mailbox {
    boolean retains;
    List forwardingBoxes = new LinkedList();
    int s;
    int e;
    int d;
    Object[] queue;
    int[] deliveriesRemaining;

    public QueuedMailbox(int capacity, boolean retain) throws RemoteException {
        if (capacity < 1) {
            throw new IllegalArgumentException("invalid capacity: " + capacity);
        }
        this.queue = new Object[capacity + 1];
        this.deliveriesRemaining = new int[capacity + 1];
        this.retains = retain;
        this.d = 0;
        this.s = 0;
        this.e = capacity;
    }

    public QueuedMailbox(int capacity) throws RemoteException {
        this(capacity, true);
    }

    public synchronized void deposit(Object msg) throws RemoteException, InterruptedException {
        if (msg == null) {
            throw new IllegalArgumentException("null message");
        }
        if (!this.retains && this.forwardingBoxes.isEmpty()) {
            return;
        }
        while (this.full()) {
            this.wait();
        }
        this.e = this.incr(this.e);
        this.queue[this.e] = msg;
        if (!this.retains) {
            this.d = this.incr(this.e);
        }
        this.forward(this.e);
        this.notifyAll();
    }

    public synchronized boolean depositIfPossible(Object msg) throws RemoteException, InterruptedException {
        if (this.full()) {
            return false;
        }
        this.deposit(msg);
        return true;
    }

    public synchronized Object receive() throws InterruptedException {
        if (!this.retains) {
            throw new IllegalStateException("cannot receive when ! retains ()");
        }
        while (this.allReceived()) {
            this.wait();
        }
        Object msg = this.queue[this.d];
        if (this.d == this.s && this.deliveriesRemaining[this.s] == 0) {
            this.queue[this.s] = null;
            this.d = this.s = this.incr(this.d);
        } else {
            this.d = this.incr(this.d);
        }
        this.notifyAll();
        return msg;
    }

    public synchronized Object receiveIfPossible() throws InterruptedException {
        if (this.allReceived()) {
            return null;
        }
        return this.receive();
    }

    public synchronized void forwardTo(Mailbox box) {
        if (!this.empty()) {
            throw new IllegalStateException("must be empty before adding forwarding address");
        }
        if (box == this) {
            throw new IllegalArgumentException("can't forward to yourself");
        }
        if (box == null) {
            throw new IllegalArgumentException("can't forward to null box");
        }
        if (!this.forwardingBoxes.contains(box)) {
            this.forwardingBoxes.add(box);
        }
    }

    public synchronized void stopForwardingTo(Mailbox box) {
        if (!this.empty()) {
            throw new IllegalStateException("must be empty before removing forwarding address");
        }
        this.forwardingBoxes.remove(box);
    }

    public synchronized void close() throws InterruptedException {
        this.d = this.incr(this.e);
        this.reclaim();
        while (!this.empty()) {
            this.wait();
        }
    }

    public boolean retains() {
        return this.retains;
    }

    public int capacity() {
        return this.queue.length - 1;
    }

    public int deliveryStrategy() {
        return 0;
    }

    final int incr(int x) {
        return (x + 1) % this.queue.length;
    }

    final boolean empty() {
        return this.incr(this.e) == this.s;
    }

    final boolean full() {
        return this.incr(this.e + 1) == this.s;
    }

    final boolean allReceived() {
        return this.incr(this.e) == this.d;
    }

    void forward(int i) throws RemoteException, InterruptedException {
        RemoteException problem = null;
        for (Mailbox box : this.forwardingBoxes) {
            try {
                box.deposit(this.queue[i]);
            }
            catch (RemoteException e) {
                problem = e;
            }
        }
        if (problem != null) {
            throw problem;
        }
    }

    void reclaim() {
        while (!this.empty() && this.deliveriesRemaining[this.s] == 0) {
            this.queue[this.s] = null;
            this.s = this.incr(this.s);
        }
        this.notifyAll();
    }
}

