/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.interfaces;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WaitingDialog
extends JDialog
implements ActionListener {
    private JPanel TitlePanel;
    private JPanel DataPanel;
    private JLabel NameLabel;
    private String name;
    private String upperMessage;
    private String lowerMessage;
    private boolean freezeMessage;
    private int secondsRemaining;
    private Timer countdownTimer;
    private javax.swing.Timer timer;
    private float topx1;
    private float topy1;
    private float topx2;
    private float topy2;
    private float bottomx1;
    private float bottomy1;
    private float bottomx2;
    private float bottomy2;
    private int vertx1;
    private int vertx2;
    private int vert2x1;
    private int vert2x2;
    private int panelHeight;
    private int panelLength;
    private Random rand;
    private boolean movingForward;
    private boolean movingForward2;
    private boolean drawVerticalLines;
    private boolean itest;

    public WaitingDialog(Frame parent, boolean modal, String name, boolean drawVerticalLines, boolean itest) {
        super(parent, modal);
        this.name = name;
        this.itest = itest;
        this.initComponents();
        this.NameLabel.setText(name);
        this.upperMessage = "Connecting";
        this.rand = new Random();
        this.drawVerticalLines = drawVerticalLines;
        this.initPainter();
        this.setResizable(false);
        this.freezeMessage = false;
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.NameLabel = new JLabel();
        this.DataPanel = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                WaitingDialog.this.closeDialog(evt);
            }
        });
        this.TitlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.NameLabel.setFont(new Font("Verdana", 1, 18));
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setText("Client");
        this.TitlePanel.add(this.NameLabel);
        this.getContentPane().add(this.TitlePanel);
        this.getContentPane().add(this.DataPanel);
    }

    private void closeDialog(WindowEvent evt) {
    }

    public static void main(String[] args) {
        final WaitingDialog diag = new WaitingDialog(new JFrame(), true, "Test Client", false, false);
        diag.setActive("Please Wait", "Connecting to Server", 2000L);
        Runnable run = new Runnable(){

            public void run() {
                diag.setActive("Please Wait", "Testing", 2000L);
                diag.setInactive();
            }
        };
        Thread test = new Thread(run);
        test.start();
        diag.setCountdown("Game will start in:", 10);
        diag.setInactive();
    }

    private void initPainter() {
        this.getContentPane().remove(this.DataPanel);
        this.topx1 = 0.0f;
        this.topx2 = 120.0f;
        this.bottomx1 = 150.0f;
        this.bottomx2 = 0.0f;
        this.timer = new javax.swing.Timer(10, this);
        this.timer.start();
        this.DataPanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2d = (Graphics2D)g;
                WaitingDialog.this.panelLength = this.getSize().width;
                WaitingDialog.this.panelHeight = this.getSize().height;
                g2d.setStroke(new BasicStroke(10.0f));
                GradientPaint topBarPaint = new GradientPaint(WaitingDialog.this.topx1, WaitingDialog.this.topy1, Color.black, WaitingDialog.this.topx2, WaitingDialog.this.topy2, Color.blue, true);
                g2d.setPaint(topBarPaint);
                g2d.drawLine(0, 0, WaitingDialog.this.panelLength, 0);
                GradientPaint bottomBarPaint = new GradientPaint(WaitingDialog.this.bottomx1, WaitingDialog.this.bottomy1, Color.black, WaitingDialog.this.bottomx2, WaitingDialog.this.bottomy2, Color.blue, true);
                g2d.setPaint(bottomBarPaint);
                g2d.drawLine(0, WaitingDialog.this.panelHeight, WaitingDialog.this.panelLength, WaitingDialog.this.panelHeight);
                if (WaitingDialog.this.drawVerticalLines) {
                    GradientPaint verticalBarPaint = new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, WaitingDialog.this.panelHeight, Color.lightGray, true);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.setPaint(verticalBarPaint);
                    g2d.drawLine(WaitingDialog.this.vertx1, 6, WaitingDialog.this.vertx2, WaitingDialog.this.panelHeight - 6);
                    g2d.drawLine(WaitingDialog.this.vert2x1, 6, WaitingDialog.this.vert2x2, WaitingDialog.this.panelHeight - 6);
                }
                g2d.setPaint(new GradientPaint(50.0f, 0.0f, Color.darkGray, 450.0f, 0.0f, Color.black));
                g2d.setFont(new Font("Verdana", 0, 18));
                double strWidth = g2d.getFontMetrics().getStringBounds(WaitingDialog.this.upperMessage, g2d).getWidth();
                g2d.drawString(WaitingDialog.this.upperMessage, (float)(WaitingDialog.this.panelLength / 2) - (float)(strWidth / 2.0), (float)WaitingDialog.this.panelHeight / 3.0f);
                strWidth = g2d.getFontMetrics().getStringBounds(WaitingDialog.this.lowerMessage, g2d).getWidth();
                g2d.drawString(WaitingDialog.this.lowerMessage, (float)(WaitingDialog.this.panelLength / 2) - (float)(strWidth / 2.0), (float)WaitingDialog.this.panelHeight / 1.5f);
            }
        };
        this.DataPanel.setMinimumSize(new Dimension(450, 100));
        this.DataPanel.setPreferredSize(new Dimension(450, 100));
        this.DataPanel.setMaximumSize(new Dimension(450, 100));
        this.getContentPane().add(this.DataPanel);
        this.pack();
        this.centerOnScreen();
    }

    public void setActive(String upperMessage, String lowerMessage) {
        this.thaw();
        this.upperMessage = upperMessage;
        this.lowerMessage = lowerMessage;
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (!WaitingDialog.this.itest) {
                    WaitingDialog.this.setVisible(true);
                    WaitingDialog.this.repaint();
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private synchronized void thaw() {
        try {
            while (this.freezeMessage) {
                this.wait(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setActive(String upperMessage, String lowerMessage, long time) {
        try {
            this.setActive(upperMessage, lowerMessage);
            this.freezeMessage = true;
            this.wait(time);
            this.freezeMessage = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setCountdown(String umessage, int seconds) {
        try {
            this.thaw();
            this.secondsRemaining = seconds;
            long time = seconds * 1000;
            final String message = umessage;
            this.freezeMessage = true;
            this.countdownTimer = new Timer();
            TimerTask task = new TimerTask(){

                public void run() {
                    if (WaitingDialog.this.secondsRemaining <= 0) {
                        WaitingDialog.this.freezeMessage = false;
                        WaitingDialog.this.countdownTimer.cancel();
                    }
                    WaitingDialog.this.upperMessage = message;
                    if (WaitingDialog.this.secondsRemaining != 1) {
                        WaitingDialog.this.lowerMessage = WaitingDialog.this.secondsRemaining + " seconds";
                    } else {
                        WaitingDialog.this.lowerMessage = WaitingDialog.this.secondsRemaining + " second";
                    }
                    Runnable doUpdate = new Runnable(){

                        public void run() {
                            if (!WaitingDialog.this.isVisible() && !WaitingDialog.this.itest) {
                                WaitingDialog.this.setVisible(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                    WaitingDialog.this.secondsRemaining--;
                }
            };
            this.countdownTimer.schedule(task, 0L, 1000L);
            while (this.freezeMessage) {
                this.wait(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInactive() {
        this.thaw();
        Runnable doUpdate = new Runnable(){

            public void run() {
                WaitingDialog.this.setVisible(false);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void kill() {
        this.thaw();
        Runnable doUpdate = new Runnable(){

            public void run() {
                WaitingDialog.this.setVisible(false);
                WaitingDialog.this.timer.stop();
                WaitingDialog.this.dispose();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.topx1 += 2.0f;
        this.topy1 = 0.0f;
        this.topx2 += 2.0f;
        this.topy2 = 0.0f;
        this.bottomx1 += 1.0f;
        this.bottomy1 = this.panelHeight;
        this.bottomx2 += 1.0f;
        this.bottomy2 = this.panelHeight;
        int moveAmount = 11;
        int moveAmount2 = 6;
        if (this.vertx1 > this.panelLength || this.vertx2 > this.panelLength) {
            this.movingForward = false;
            this.vertx1 -= moveAmount;
            this.vertx2 -= moveAmount;
        } else if (this.vertx1 < 0 || this.vertx2 < 0) {
            this.movingForward = true;
            this.vertx1 += moveAmount;
            this.vertx2 += moveAmount;
        } else if (this.movingForward) {
            this.vertx1 += moveAmount;
            this.vertx2 += moveAmount;
        } else {
            this.vertx1 -= moveAmount;
            this.vertx2 -= moveAmount;
        }
        if (this.vert2x1 > this.panelLength || this.vert2x2 > this.panelLength) {
            this.movingForward2 = false;
            this.vert2x1 -= moveAmount2;
            this.vert2x2 -= moveAmount2;
        } else if (this.vert2x1 < 0 || this.vert2x2 < 0) {
            this.movingForward2 = true;
            this.vert2x1 += moveAmount2;
            this.vert2x2 += moveAmount2;
        } else if (this.movingForward2) {
            this.vert2x1 += moveAmount2;
            this.vert2x2 += moveAmount2;
        } else {
            this.vert2x1 -= moveAmount2;
            this.vert2x2 -= moveAmount2;
        }
        this.repaint();
    }
}

