/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.interfaces;

import edu.caltech.ssel.multistage.shared.interfaces.ColumnChild;
import edu.caltech.ssel.multistage.shared.interfaces.ColumnParent;
import edu.caltech.ssel.multistage.shared.interfaces.ColumnSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class ComplexColumnPanel
extends JPanel {
    private JPanel LabelPanel;
    private JLabel TitleLabel;
    private JTabbedPane CardPanel;
    private JPanel FullPanel;
    private GridBagLayout gridbag;
    private Color darkColor;
    private Color lightColor;

    public ComplexColumnPanel(String title, ColumnSet set) {
        this.init(title);
        this.createColumnPanel(set);
    }

    private void init(String title) {
        this.TitleLabel = new JLabel();
        this.LabelPanel = new JPanel();
        this.lightColor = this.LabelPanel.getBackground();
        this.darkColor = new Color(220, 220, 200);
        this.setLayout(new BoxLayout(this, 1));
        this.TitleLabel.setText(title);
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setFont(new Font("Book Antiqua", 0, 15));
        this.LabelPanel.add(this.TitleLabel);
        this.add(this.LabelPanel);
        this.FullPanel = new JPanel();
        this.add(this.FullPanel);
    }

    public void createColumnPanel(ColumnSet set) {
        this.LabelPanel.setPreferredSize(new Dimension(450, 35));
        this.LabelPanel.setMaximumSize(new Dimension(20000, 35));
        this.FullPanel.setLayout(new BoxLayout(this.FullPanel, 1));
        JScrollPane scroller = new JScrollPane();
        scroller.setPreferredSize(new Dimension(300, 200));
        scroller.setMinimumSize(new Dimension(300, 200));
        Vector[] columnHeaders = null;
        JPanel headPanel = new JPanel();
        scroller.setColumnHeaderView(headPanel);
        this.initLayout(headPanel);
        columnHeaders = this.buildHeaders(headPanel, set, false, null);
        this.buildHistory(set, headPanel);
        JViewport headerView = scroller.getColumnHeader();
        headerView.setPreferredSize(new Dimension(300, this.getLargestHeight(set, columnHeaders)));
        JPanel infoPanel = new JPanel();
        scroller.setViewportView(infoPanel);
        this.initLayout(infoPanel);
        this.buildHeaders(infoPanel, set, true, columnHeaders);
        this.buildHistory(set, infoPanel);
        JPanel filler = new JPanel();
        this.gridbag.setConstraints(filler, this.getFillerConstraints());
        infoPanel.add(filler);
        scroller.getVerticalScrollBar().setMaximum(infoPanel.getPreferredSize().height);
        scroller.getVerticalScrollBar().setValue(infoPanel.getPreferredSize().height);
        this.FullPanel.add(scroller);
    }

    private int getLargestHeight(ColumnSet set, Vector[] columnLabels) {
        int largestHeight = 0;
        int index = 0;
        for (int i = 0; i < set.getNumParents(); ++i) {
            ColumnParent parent = set.getParent(i);
            int parentHeight = ((JLabel)columnLabels[0].get((int)i)).getPreferredSize().height;
            for (int j = 0; j < parent.getNumChildren(); ++j) {
                int childHeight = ((JLabel)columnLabels[1].get((int)index)).getPreferredSize().height;
                if (childHeight + parentHeight > largestHeight) {
                    largestHeight = childHeight + parentHeight;
                }
                ++index;
            }
        }
        return largestHeight;
    }

    private void initLayout(JPanel panel) {
        this.gridbag = new GridBagLayout();
        panel.setLayout(this.gridbag);
    }

    private GridBagConstraints getFillerConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weighty = 1.0;
        return constraints;
    }

    private GridBagConstraints getParentConstraints(int children, boolean endRow) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.ipadx = 10;
        constraints.gridwidth = endRow ? 0 : children;
        return constraints;
    }

    private GridBagConstraints getChildConstraints(boolean endRow) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.ipadx = 10;
        if (endRow) {
            constraints.gridwidth = 0;
        }
        return constraints;
    }

    private int getNumRows(ColumnSet set) {
        int numRows = 0;
        for (int i = 0; i < set.getNumParents(); ++i) {
            ColumnParent parent = set.getParent(i);
            for (int j = 0; j < parent.getNumChildren(); ++j) {
                ColumnChild data = parent.getChild(j);
                int rows = data.getNumData();
                if (rows <= numRows) continue;
                numRows = rows;
            }
        }
        return numRows;
    }

    private int getNumChildren(ColumnSet set) {
        int numChildren = 0;
        for (int i = 0; i < set.getNumParents(); ++i) {
            ColumnParent parent = set.getParent(i);
            numChildren += parent.getNumChildren();
        }
        return numChildren;
    }

    private Vector[] buildHeaders(JPanel panel, ColumnSet set, boolean blankOut, Vector[] refLabels) {
        int numColumns;
        int numParents = set.getNumParents();
        int numChildren = this.getNumChildren(set);
        Vector[] headers = new Vector[2];
        headers[0] = new Vector();
        for (int i = 0; i < set.getNumParents(); ++i) {
            ColumnParent parent = set.getParent(i);
            JLabel columnLabel = new JLabel();
            numColumns = parent.getNumChildren();
            String text = parent.getText();
            Color foreground = parent.getColor();
            if (blankOut) {
                foreground = columnLabel.getBackground();
                columnLabel.setMaximumSize(new Dimension(32000, 2));
                if (refLabels != null) {
                    JLabel refLabel = (JLabel)refLabels[0].get(i);
                    columnLabel.setPreferredSize(new Dimension(refLabel.getPreferredSize().width, 2));
                }
            }
            columnLabel.setText(text);
            columnLabel.setForeground(foreground);
            columnLabel.setHorizontalAlignment(0);
            GridBagConstraints constraints = this.getParentConstraints(numColumns, i == numParents - 1);
            this.gridbag.setConstraints(columnLabel, constraints);
            panel.add(columnLabel);
            headers[0].add(columnLabel);
        }
        int index = 0;
        headers[1] = new Vector();
        for (int i = 0; i < set.getNumParents(); ++i) {
            ColumnParent parent = set.getParent(i);
            numColumns = parent.getNumChildren();
            for (int j = 0; j < numColumns; ++j) {
                ColumnChild child = parent.getChild(j);
                JLabel columnLabel = new JLabel();
                String text = child.getText();
                Color foreground = child.getColor();
                if (blankOut) {
                    foreground = columnLabel.getBackground();
                    columnLabel.setMaximumSize(new Dimension(32000, 2));
                    if (refLabels != null) {
                        JLabel refLabel = (JLabel)refLabels[1].get(index);
                        columnLabel.setPreferredSize(new Dimension(refLabel.getPreferredSize().width, 2));
                    }
                }
                columnLabel.setText(text);
                columnLabel.setForeground(foreground);
                columnLabel.setHorizontalAlignment(0);
                GridBagConstraints constraints = this.getChildConstraints(index == numChildren - 1);
                this.gridbag.setConstraints(columnLabel, constraints);
                panel.add(columnLabel);
                headers[1].add(columnLabel);
                ++index;
            }
        }
        return headers;
    }

    private int buildHistory(ColumnSet set, JPanel panel) {
        DecimalFormat formatter = new DecimalFormat("##.##");
        int numRows = this.getNumRows(set);
        int numChildren = this.getNumChildren(set);
        for (int r = 0; r < numRows; ++r) {
            Color backColor = r % 2 == 0 ? this.darkColor : this.lightColor;
            int index = 0;
            for (int p = 0; p < set.getNumParents(); ++p) {
                ColumnParent parent = set.getParent(p);
                for (int c = 0; c < parent.getNumChildren(); ++c) {
                    JPanel columnPanel = new JPanel();
                    JLabel columnLabel = new JLabel();
                    ColumnChild child = parent.getChild(c);
                    String data = "";
                    data = r >= child.getNumData() || child.getData(r) == null ? "" : child.getData(r);
                    columnLabel.setText(data);
                    columnLabel.setForeground(Color.black);
                    columnLabel.setHorizontalAlignment(0);
                    columnPanel.add(columnLabel);
                    columnPanel.setBackground(backColor);
                    GridBagConstraints constraints = this.getChildConstraints(index == numChildren - 1);
                    this.gridbag.setConstraints(columnPanel, constraints);
                    panel.add(columnPanel);
                    ++index;
                }
            }
        }
        return numRows;
    }

    public static void main(String[] args) {
        ColumnChild data1 = new ColumnChild("Child One", Color.red);
        data1.addData("1-1");
        data1.addData("1-2");
        ColumnChild data2 = new ColumnChild("Child Two", Color.blue);
        data2.addData("2-1");
        ColumnChild data3 = new ColumnChild("Child Three", Color.cyan);
        data3.addData("3-1");
        ColumnChild data4 = new ColumnChild("Child Four", Color.black);
        data4.addData("4-1");
        data4.addData("4-2");
        data4.addData("4-3");
        data4.addData("4-2");
        data4.addData("4-3");
        data4.addData("4-2");
        data4.addData("4-3");
        data4.addData("4-2");
        data4.addData("4-3");
        ColumnParent parent1 = new ColumnParent("Parent One", Color.black, 2);
        parent1.setChild(0, data1);
        parent1.setChild(1, data2);
        ColumnParent parent2 = new ColumnParent("Parent Two", Color.blue, 2);
        parent2.setChild(0, data3);
        parent2.setChild(1, data4);
        ColumnSet set = new ColumnSet(2);
        set.setParent(0, parent1);
        set.setParent(1, parent2);
        ComplexColumnPanel panel = new ComplexColumnPanel("Test", set);
        panel.setPreferredSize(new Dimension(4000, 4000));
        JFrame holder = new JFrame();
        holder.getContentPane().add(panel);
        holder.pack();
        holder.setVisible(true);
    }
}

