/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.interfaces;

import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class ClientHistoryPanel
extends JPanel {
    private JPanel LabelPanel;
    private JLabel TitleLabel;
    private JTabbedPane CardPanel;
    private JPanel FullPanel;
    private boolean collapseMatches;
    private String matchStr;
    private String matchTotalStr;
    private String totalStr;
    private String practiceMatchStr;
    private String normalMatchStr;
    private int historyNumber;
    private boolean showTotalPayoff;
    private boolean viewSwitchable;
    private GridBagConstraints normalConstraints;
    private GridBagConstraints endRowConstraints;
    private GridBagConstraints fillerConstraints;
    private GridBagLayout gridbag;
    private String name;
    private ClientData cdata;
    private static Category log = Category.getInstance(ClientHistoryPanel.class);

    public ClientHistoryPanel(String name) {
        this.name = name;
        this.collapseMatches = false;
        this.init();
        this.setTitle(name);
        this.matchStr = "Match";
        this.totalStr = "Total Payoff";
        this.matchTotalStr = "Total Payoff this Match";
        this.normalMatchStr = "Normal Match";
        this.practiceMatchStr = "Practice Match";
    }

    public ClientHistoryPanel(ClientData cdata, String name) {
        this.setPreferredSize(new Dimension(330, 220));
        this.cdata = cdata;
        this.name = name;
        this.collapseMatches = false;
        this.historyNumber = -1;
        this.viewSwitchable = true;
        this.showTotalPayoff = true;
        this.init();
        this.setTitle(name);
        this.rebuild(cdata);
        this.matchStr = "Match";
        this.totalStr = "Total Payoff";
        this.matchTotalStr = "Total Payoff this Match";
        this.normalMatchStr = "Normal Match";
        this.practiceMatchStr = "Practice Match";
    }

    private void init() {
        this.TitleLabel = new JLabel();
        this.LabelPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.TitleLabel.setText("Client History");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setFont(new Font("Arial Black", 0, 15));
        this.LabelPanel.add(this.TitleLabel);
        this.add(this.LabelPanel);
        this.CardPanel = new JTabbedPane();
        this.add(this.CardPanel);
        this.FullPanel = new JPanel();
    }

    public void collapseMatches() {
        this.collapseMatches = true;
        this.rebuild(this.cdata);
    }

    public void expandMatches() {
        this.collapseMatches = false;
        this.rebuild(this.cdata);
    }

    public void setCollapseMatches(boolean collapseMatches) {
        this.collapseMatches = collapseMatches;
    }

    private void initComponents() {
        this.LabelPanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.CardPanel = new JTabbedPane();
        this.setLayout(new BoxLayout(this, 1));
        this.TitleLabel.setText("Client History");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.LabelPanel.add(this.TitleLabel);
        this.add(this.LabelPanel);
        this.add(this.CardPanel);
    }

    private void createFullMatchPanel() {
        this.LabelPanel.setPreferredSize(new Dimension(450, 35));
        this.LabelPanel.setMaximumSize(new Dimension(20000, 35));
        this.FullPanel.setLayout(new BoxLayout(this.FullPanel, 1));
        JPanel titlePanel = new JPanel();
        this.buildTotalTitlePanel(titlePanel);
        this.FullPanel.add(titlePanel);
        JTabbedPane setPanel = new JTabbedPane();
        JScrollPane singleSetScroller = new JScrollPane();
        int[][] setInfo = this.getSetInfo();
        if (setInfo == null) {
            return;
        }
        for (int i = 0; i < setInfo.length; ++i) {
            int firstMatch = setInfo[i][0];
            int lastMatch = setInfo[i][1];
            JScrollPane scroller = new JScrollPane();
            scroller.setPreferredSize(new Dimension(300, 200));
            scroller.setMinimumSize(new Dimension(300, 200));
            JLabel[] columnHeaders = null;
            JPanel headPanel = new JPanel();
            scroller.setColumnHeaderView(headPanel);
            this.initLayout(headPanel);
            for (int match = firstMatch; match < lastMatch; ++match) {
                if (match == firstMatch) {
                    columnHeaders = this.buildMatchHeaders(match, headPanel, false, null);
                }
                this.buildMatchHistory(match, headPanel, 0);
            }
            JViewport headerView = scroller.getColumnHeader();
            headerView.setPreferredSize(new Dimension(300, this.getLargestHeight(columnHeaders)));
            int maxRounds = 0;
            JPanel infoPanel = new JPanel();
            scroller.setViewportView(infoPanel);
            this.initLayout(infoPanel);
            for (int match = firstMatch; match < lastMatch; ++match) {
                if (match == firstMatch) {
                    this.buildMatchHeaders(match, infoPanel, true, columnHeaders);
                }
                maxRounds += this.buildMatchHistory(match, infoPanel, maxRounds);
            }
            JPanel filler = new JPanel();
            this.gridbag.setConstraints(filler, this.fillerConstraints);
            infoPanel.add(filler);
            scroller.getVerticalScrollBar().setMaximum(infoPanel.getPreferredSize().height);
            scroller.getVerticalScrollBar().setValue(infoPanel.getPreferredSize().height);
            if (setInfo.length > 1) {
                setPanel.add("Set " + (i + 1), scroller);
                continue;
            }
            singleSetScroller = scroller;
        }
        if (setInfo.length > 1) {
            this.FullPanel.add(setPanel);
            setPanel.setSelectedIndex(setPanel.getComponentCount() - 1);
        } else {
            this.FullPanel.add(singleSetScroller);
        }
    }

    private int[][] getSetInfo() {
        if (this.cdata == null) {
            return null;
        }
        int numMatches = this.cdata.getNumMatches();
        int numSets = 0;
        Vector prevTitles = new Vector();
        Vector<Integer> firstMatches = new Vector<Integer>();
        Vector<Integer> lastMatches = new Vector<Integer>();
        boolean firstMatch = true;
        for (int i = 0; i < numMatches; ++i) {
            Vector columns = this.cdata.getColumnData(i);
            Vector titles = this.getTitles(columns);
            if (!titles.equals(prevTitles)) {
                firstMatches.add(new Integer(i));
                if (!firstMatch) {
                    lastMatches.add(new Integer(i));
                }
                firstMatch = false;
                ++numSets;
            }
            prevTitles = titles;
        }
        lastMatches.add(new Integer(numMatches));
        int[][] setInfo = new int[numSets][2];
        for (int i = 0; i < setInfo.length; ++i) {
            setInfo[i][0] = (Integer)firstMatches.get(i);
            setInfo[i][1] = (Integer)lastMatches.get(i);
        }
        return setInfo;
    }

    private JLabel[] buildMatchHeaders(int match, JPanel panel, boolean blankOut, JLabel[] clabels) {
        Vector columns = this.cdata.getColumnData(match);
        JLabel matchNum = new JLabel(this.matchStr);
        Color foreground = Color.blue;
        if (blankOut) {
            foreground = matchNum.getBackground();
            matchNum.setMaximumSize(new Dimension(32000, 2));
            if (clabels != null) {
                matchNum.setPreferredSize(new Dimension(clabels[0].getPreferredSize().width, 2));
            }
        }
        matchNum.setForeground(foreground);
        matchNum.setHorizontalAlignment(0);
        if (columns == null || columns.size() < 1) {
            this.gridbag.setConstraints(matchNum, this.endRowConstraints);
        } else {
            this.gridbag.setConstraints(matchNum, this.normalConstraints);
        }
        panel.add(matchNum);
        JLabel[] nonMatchLabels = clabels;
        if (clabels != null && clabels.length > 1) {
            nonMatchLabels = new JLabel[clabels.length - 1];
            for (int i = 0; i < nonMatchLabels.length; ++i) {
                nonMatchLabels[i] = clabels[i + 1];
            }
        }
        JLabel[] temp = this.buildHeaders(match, panel, blankOut, nonMatchLabels);
        JLabel[] allLabels = new JLabel[temp.length + 1];
        allLabels[0] = matchNum;
        for (int i = 0; i < temp.length; ++i) {
            allLabels[i + 1] = temp[i];
        }
        return allLabels;
    }

    private int buildMatchHistory(int match, JPanel panel, int maxRounds) {
        int firstRound;
        Vector columns = this.cdata.getColumnData(match);
        int numRounds = this.cdata.getNumRounds(match);
        for (int i = firstRound = 0; i < numRounds; ++i) {
            Color backColor = i % 2 == 0 && maxRounds % 2 == 0 || i % 2 == 1 && maxRounds % 2 == 1 ? new Color(220, 220, 220) : new Color(204, 204, 204);
            JPanel mNumPanel = new JPanel();
            JLabel mNum = new JLabel("" + (match + 1));
            mNum.setForeground(Color.black);
            mNum.setHorizontalAlignment(0);
            mNumPanel.setBackground(backColor);
            mNumPanel.add(mNum);
            if (columns == null || columns.size() < 1) {
                this.gridbag.setConstraints(mNumPanel, this.endRowConstraints);
            } else {
                this.gridbag.setConstraints(mNumPanel, this.normalConstraints);
            }
            panel.add(mNumPanel);
            if (columns == null || columns.size() <= 0) continue;
            for (int k = 0; k < columns.size(); ++k) {
                Hashtable column = (Hashtable)columns.get(k);
                Color foreColor = (Color)column.get("color");
                JPanel columnPanel = new JPanel();
                JLabel columnLabel = new JLabel();
                String data = (String)column.get(new Integer(i));
                if (data == null) {
                    data = "";
                }
                columnLabel.setText(data);
                columnLabel.setForeground(foreColor);
                columnLabel.setHorizontalAlignment(0);
                columnPanel.add(columnLabel);
                columnPanel.setBackground(backColor);
                if (k == columns.size() - 1) {
                    this.gridbag.setConstraints(columnPanel, this.endRowConstraints);
                } else {
                    this.gridbag.setConstraints(columnPanel, this.normalConstraints);
                }
                panel.add(columnPanel);
            }
        }
        return numRounds;
    }

    private void buildTotalTitlePanel(JPanel titlePanel) {
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setPreferredSize(new Dimension(450, 40));
        titlePanel.setMaximumSize(new Dimension(20000, 40));
        JPanel payoffPanel = new JPanel();
        this.buildTotalPayoffPanel(payoffPanel);
        if (this.showTotalPayoff) {
            titlePanel.add((Component)payoffPanel, "West");
        }
        JButton tabButton = new JButton();
        this.buildTabbedSwitchButton(tabButton);
        titlePanel.add((Component)tabButton, "East");
    }

    private void buildTabbedSwitchButton(JButton tabButton) {
        tabButton.setText("Switch to Tabbed View");
        tabButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientHistoryPanel.this.expandMatches();
            }
        });
        if (!this.viewSwitchable) {
            tabButton.setEnabled(false);
        }
        tabButton.setHorizontalAlignment(4);
    }

    private void buildTotalPayoffPanel(JPanel payoffPanel) {
        payoffPanel.setLayout(new BoxLayout(payoffPanel, 0));
        JLabel matchPayoff = new JLabel();
        matchPayoff.setForeground(Color.red);
        JLabel payoffTitle = new JLabel(this.totalStr + ": ");
        payoffTitle.setForeground(Color.black);
        payoffTitle.setFont(new Font("Book Antiqua", 1, 16));
        payoffPanel.add(payoffTitle);
        if (this.cdata == null) {
            matchPayoff.setText("0.0");
        } else {
            DecimalFormat numFormatter = new DecimalFormat("#########.##");
            DecimalFormat currencyFormatter = new DecimalFormat("########.##");
            ((NumberFormat)currencyFormatter).setMinimumFractionDigits(2);
            matchPayoff.setText("" + numFormatter.format(this.cdata.getTotalPayoff()) + " ($" + currencyFormatter.format(this.cdata.getTotalPayoffExchanged()) + ")");
        }
        matchPayoff.setFont(new Font("Book Antiqua", 1, 18));
        payoffPanel.add(matchPayoff);
    }

    private void createMatchCard(int match) {
        this.LabelPanel.setPreferredSize(new Dimension(450, 35));
        this.LabelPanel.setMaximumSize(new Dimension(20000, 35));
        JPanel ComponentsPanel = new JPanel();
        ComponentsPanel.setLayout(new BoxLayout(ComponentsPanel, 1));
        JPanel titlePanel = new JPanel();
        this.buildMatchTitlePanel(match, titlePanel);
        ComponentsPanel.add(titlePanel);
        JScrollPane scroller = new JScrollPane();
        scroller.setPreferredSize(new Dimension(300, 200));
        scroller.setMinimumSize(new Dimension(300, 200));
        JPanel headPanel = new JPanel();
        this.initLayout(headPanel);
        JLabel[] columnLabels = this.buildHeaders(match, headPanel, false, null);
        this.buildHistory(match, headPanel);
        scroller.setColumnHeaderView(headPanel);
        JViewport headerView = scroller.getColumnHeader();
        headerView.setPreferredSize(new Dimension(300, this.getLargestHeight(columnLabels)));
        JPanel infoPanel = new JPanel();
        this.initLayout(infoPanel);
        this.buildHeaders(match, infoPanel, true, columnLabels);
        int numRounds = this.buildHistory(match, infoPanel);
        scroller.setViewportView(infoPanel);
        JPanel filler = new JPanel();
        this.gridbag.setConstraints(filler, this.fillerConstraints);
        infoPanel.add(filler);
        scroller.getVerticalScrollBar().setMaximum(infoPanel.getPreferredSize().height);
        scroller.getVerticalScrollBar().setValue(infoPanel.getPreferredSize().height);
        ComponentsPanel.add(scroller);
        this.CardPanel.add(this.matchStr + " " + (match + 1), ComponentsPanel);
    }

    private int getLargestHeight(JLabel[] columnLabels) {
        int largestHeight = 0;
        for (int i = 0; i < columnLabels.length; ++i) {
            int height = columnLabels[i].getPreferredSize().height;
            if (height <= largestHeight) continue;
            largestHeight = height;
        }
        return largestHeight;
    }

    private void initLayout(JPanel panel) {
        this.gridbag = new GridBagLayout();
        panel.setLayout(this.gridbag);
        this.normalConstraints = new GridBagConstraints();
        this.endRowConstraints = new GridBagConstraints();
        this.fillerConstraints = new GridBagConstraints();
        this.normalConstraints.fill = 1;
        this.normalConstraints.weightx = 1.0;
        this.normalConstraints.ipadx = 10;
        this.fillerConstraints.fill = 1;
        this.fillerConstraints.weighty = 1.0;
        this.endRowConstraints.fill = 1;
        this.endRowConstraints.gridwidth = 0;
        this.endRowConstraints.weightx = 1.0;
        this.endRowConstraints.ipadx = 10;
    }

    private void buildMatchTitlePanel(int match, JPanel titlePanel) {
        titlePanel.setLayout(new GridLayout(2, 1));
        titlePanel.setPreferredSize(new Dimension(450, 60));
        titlePanel.setMaximumSize(new Dimension(20000, 60));
        JPanel headerPanel = new JPanel();
        this.buildMatchHeaderPanel(match, headerPanel);
        titlePanel.add(headerPanel);
        JPanel payoffPanel = new JPanel();
        this.buildMatchPayoffPanel(match, payoffPanel);
        if (this.showTotalPayoff) {
            titlePanel.add(payoffPanel);
        }
    }

    private void buildMatchHeaderPanel(int match, JPanel headerPanel) {
        boolean practice = false;
        if (this.cdata != null) {
            practice = this.cdata.isPracticeMatch(match);
        }
        headerPanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        if (practice) {
            title.setText(this.practiceMatchStr);
            title.setForeground(new Color(16, 120, 11));
        } else {
            title.setText(this.normalMatchStr);
            title.setForeground(Color.black);
        }
        title.setFont(new Font("Book Antiqua", 1, 14));
        headerPanel.add((Component)title, "West");
        JButton fullButton = new JButton("Switch to Full View");
        fullButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientHistoryPanel.this.collapseMatches();
            }
        });
        if (!this.viewSwitchable) {
            fullButton.setEnabled(false);
        }
        headerPanel.add((Component)fullButton, "East");
    }

    private void buildMatchPayoffPanel(int match, JPanel payoffPanel) {
        boolean practice = false;
        if (this.cdata != null) {
            practice = this.cdata.isPracticeMatch(match);
        }
        JLabel matchPayoff = new JLabel();
        if (practice) {
            matchPayoff.setForeground(new Color(16, 120, 11));
        } else {
            matchPayoff.setForeground(Color.red);
        }
        payoffPanel.setLayout(new BoxLayout(payoffPanel, 0));
        JLabel payoffTitle = new JLabel(this.matchTotalStr + ": ");
        payoffTitle.setForeground(Color.black);
        payoffTitle.setFont(new Font("Book Antiqua", 1, 16));
        payoffPanel.add(payoffTitle);
        if (this.cdata == null) {
            matchPayoff.setText("0.0");
        } else {
            DecimalFormat numFormatter = new DecimalFormat("#########.##");
            DecimalFormat currencyFormatter = new DecimalFormat("########.##");
            ((NumberFormat)currencyFormatter).setMinimumFractionDigits(2);
            matchPayoff.setText("" + numFormatter.format(this.cdata.getMatchPayoff(match)) + " ($" + currencyFormatter.format(this.cdata.getMatchPayoffExchanged(match)) + ")");
        }
        matchPayoff.setFont(new Font("Book Antiqua", 1, 18));
        payoffPanel.add(matchPayoff);
    }

    private JLabel[] buildHeaders(int match, JPanel panel, boolean blankOut, JLabel[] clabels) {
        Vector columns = null;
        if (this.cdata != null) {
            columns = this.cdata.getColumnData(match);
        }
        if (columns != null && columns.size() > 0) {
            JLabel[] columnLabels = new JLabel[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                Hashtable column = (Hashtable)columns.get(i);
                JLabel columnLabel = new JLabel();
                String text = (String)column.get("title");
                Color foreground = Color.blue;
                if (blankOut) {
                    foreground = columnLabel.getBackground();
                    columnLabel.setMaximumSize(new Dimension(32000, 2));
                    if (clabels != null) {
                        columnLabel.setPreferredSize(new Dimension(clabels[i].getPreferredSize().width, 2));
                    }
                }
                columnLabel.setText(text);
                columnLabel.setForeground(foreground);
                columnLabel.setHorizontalAlignment(0);
                if (i == columns.size() - 1) {
                    this.gridbag.setConstraints(columnLabel, this.endRowConstraints);
                } else {
                    this.gridbag.setConstraints(columnLabel, this.normalConstraints);
                }
                panel.add(columnLabel);
                columnLabels[i] = columnLabel;
            }
            return columnLabels;
        }
        JLabel[] temp = new JLabel[]{new JLabel()};
        temp[0].setPreferredSize(new Dimension(200, 15));
        return temp;
    }

    private int buildHistory(int match, JPanel panel) {
        Vector columns = null;
        if (this.cdata != null) {
            columns = this.cdata.getColumnData(match);
        }
        int numRounds = this.cdata == null ? -1 : this.cdata.getNumRounds(match);
        int firstRound = 0;
        if (this.historyNumber > -1 && this.historyNumber <= numRounds) {
            firstRound = numRounds - this.historyNumber;
        }
        for (int i = firstRound; i < numRounds; ++i) {
            Color backColor = i % 2 == 0 ? new Color(220, 220, 220) : new Color(204, 204, 204);
            if (columns == null || columns.size() <= 0) continue;
            for (int k = 0; k < columns.size(); ++k) {
                Hashtable column = (Hashtable)columns.get(k);
                Color foreColor = (Color)column.get("color");
                JPanel columnPanel = new JPanel();
                JLabel columnLabel = new JLabel();
                String data = (String)column.get(new Integer(i));
                if (data == null) {
                    data = "";
                }
                columnLabel.setText(data);
                columnLabel.setForeground(foreColor);
                columnLabel.setHorizontalAlignment(0);
                columnPanel.add(columnLabel);
                columnPanel.setBackground(backColor);
                if (k == columns.size() - 1) {
                    this.gridbag.setConstraints(columnPanel, this.endRowConstraints);
                } else {
                    this.gridbag.setConstraints(columnPanel, this.normalConstraints);
                }
                panel.add(columnPanel);
            }
        }
        return numRounds;
    }

    public void rebuild(ClientData cdata) {
        try {
            this.cdata = cdata;
            final ClientData clientData = cdata;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientHistoryPanel.this.remove(ClientHistoryPanel.this.FullPanel);
                    ClientHistoryPanel.this.remove(ClientHistoryPanel.this.CardPanel);
                    if (ClientHistoryPanel.this.collapseMatches) {
                        ClientHistoryPanel.this.add(ClientHistoryPanel.this.FullPanel);
                        ClientHistoryPanel.this.FullPanel.removeAll();
                        ClientHistoryPanel.this.createFullMatchPanel();
                    } else {
                        ClientHistoryPanel.this.add(ClientHistoryPanel.this.CardPanel);
                        ClientHistoryPanel.this.CardPanel.removeAll();
                        for (int i = 0; i < clientData.getNumMatches(); ++i) {
                            ClientHistoryPanel.this.createMatchCard(i);
                        }
                        ClientHistoryPanel.this.CardPanel.setSelectedIndex(ClientHistoryPanel.this.CardPanel.getComponentCount() - 1);
                    }
                    ClientHistoryPanel.this.validate();
                    ClientHistoryPanel.this.repaint();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to rebuild the client history panel from scratch" + MSConstants.newline + e));
        }
    }

    public void rebuildAndWait(ClientData cdata) {
        try {
            this.cdata = cdata;
            final ClientData clientData = cdata;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientHistoryPanel.this.remove(ClientHistoryPanel.this.FullPanel);
                    ClientHistoryPanel.this.remove(ClientHistoryPanel.this.CardPanel);
                    if (ClientHistoryPanel.this.collapseMatches) {
                        ClientHistoryPanel.this.add(ClientHistoryPanel.this.FullPanel);
                        ClientHistoryPanel.this.FullPanel.removeAll();
                        ClientHistoryPanel.this.createFullMatchPanel();
                    } else {
                        ClientHistoryPanel.this.add(ClientHistoryPanel.this.CardPanel);
                        ClientHistoryPanel.this.CardPanel.removeAll();
                        for (int i = 0; i < clientData.getNumMatches(); ++i) {
                            ClientHistoryPanel.this.createMatchCard(i);
                        }
                        ClientHistoryPanel.this.CardPanel.setSelectedIndex(ClientHistoryPanel.this.CardPanel.getComponentCount() - 1);
                    }
                    ClientHistoryPanel.this.validate();
                    ClientHistoryPanel.this.repaint();
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to rebuild the client history panel from scratch" + MSConstants.newline + e));
        }
    }

    public void disablePreviousMatches() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (!ClientHistoryPanel.this.collapseMatches) {
                    for (int i = 0; i < ClientHistoryPanel.this.CardPanel.getComponentCount() - 1; ++i) {
                        ClientHistoryPanel.this.CardPanel.setEnabledAt(i, false);
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Vector getTitles(Vector columns) {
        Vector<String> titles = new Vector<String>();
        for (int i = 0; i < columns.size(); ++i) {
            Hashtable column = (Hashtable)columns.get(i);
            String title = (String)column.get("title");
            if (title == null) continue;
            titles.add(title);
        }
        return titles;
    }

    private void setTitle(String name) {
        this.TitleLabel.setText(name);
    }

    public ClientData getClientData() {
        return this.cdata;
    }

    public void setMatchStr(String matchStr) {
        this.matchStr = matchStr;
    }

    public void setTotalStr(String totalStr) {
        this.totalStr = totalStr;
    }

    public void setMatchTotalStr(String matchTotalStr) {
        this.matchTotalStr = matchTotalStr;
    }

    public void setPracticeMatchStr(String practiceMatchStr) {
        this.practiceMatchStr = practiceMatchStr;
    }

    public void setNormalMatchStr(String normalMatchStr) {
        this.normalMatchStr = normalMatchStr;
    }

    public boolean getViewSwitchable() {
        return this.viewSwitchable;
    }

    public void setViewSwitchable(boolean viewSwitchable) {
        this.viewSwitchable = viewSwitchable;
    }

    public int getHistoryNumber() {
        return this.historyNumber;
    }

    public void setHistoryNumber(int historyNumber) {
        this.historyNumber = historyNumber;
    }

    public boolean getShowTotalPayoff() {
        return this.showTotalPayoff;
    }

    public void setShowTotalPayoff(boolean showTotalPayoff) {
        this.showTotalPayoff = showTotalPayoff;
    }
}

