/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.Question;
import java.util.Random;

public class SliderQuestion
extends Question {
    public SliderQuestion(String question, String answer, int min, int increment, int max) {
        this.question = question;
        this.options = new String[3];
        this.options[0] = "" + min;
        this.options[1] = "" + increment;
        this.options[2] = "" + max;
        this.answer = answer;
        this.isSurvey = false;
        this.style = SLIDER_QUESTION;
        this.outputName = null;
    }

    public SliderQuestion(String question, int min, int increment, int max, String outputName) {
        this.question = question;
        this.options = new String[3];
        this.options[0] = "" + min;
        this.options[1] = "" + increment;
        this.options[2] = "" + max;
        this.isSurvey = true;
        this.answer = null;
        this.outputName = outputName;
        this.style = SLIDER_QUESTION;
    }

    public SliderQuestion(String question, int min, int increment, int max) {
        this(question, min, increment, max, null);
    }

    public int getMin() {
        return Integer.parseInt(this.options[0]);
    }

    public void setMin(int min) {
        this.options[0] = "" + min;
    }

    public int getMax() {
        return Integer.parseInt(this.options[2]);
    }

    public void setMax(int max) {
        this.options[2] = "" + max;
    }

    public int getInc() {
        return Integer.parseInt(this.options[1]);
    }

    public void setInc(int inc) {
        this.options[1] = "" + inc;
    }

    public String getTestingModeAnswer() {
        if (!this.isSurvey && this.answer != null) {
            return this.answer;
        }
        if (this.options != null && this.options.length > 0) {
            Random rand = new Random();
            int randChoice = rand.nextInt(this.getMax() - this.getMin()) + this.getMin();
            return "" + randChoice;
        }
        return "test error";
    }
}

