/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public class RandomDotOrg {
    private int minNum = 0;
    private int maxNum = 100;
    private int cacheSize = 100;
    private int[] cachedArray;
    private int i = -1;

    public RandomDotOrg() {
    }

    public RandomDotOrg(int min, int max) {
        this.minNum = min;
        this.maxNum = max;
    }

    public RandomDotOrg(int size, int min, int max) {
        this.cacheSize = size;
        this.minNum = min;
        this.maxNum = max;
    }

    public synchronized int nextInt() {
        if (this.i == -1 || this.i >= this.cacheSize) {
            this.cachedArray = this.getNewList(this.cacheSize, this.minNum, this.maxNum);
            this.i = 0;
        }
        ++this.i;
        return this.cachedArray[this.i - 1];
    }

    private int[] getNewList(int size, int min, int max) {
        int[] returnArray = new int[size];
        try {
            URL randomOrg = new URL("http://www.random.org/cgi-bin/randnum?num=" + size + "&min=" + min + "&max=" + max + "&col=1");
            HttpURLConnection con = (HttpURLConnection)randomOrg.openConnection();
            con.setRequestMethod("GET");
            con.setDoInput(true);
            InputStream in = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            for (int i = 0; i < size; ++i) {
                returnArray[i] = Integer.parseInt(br.readLine());
            }
            con.disconnect();
        }
        catch (Exception e) {
            Random r = new Random();
            r.setSeed(r.hashCode());
            for (int i = 0; i < size; ++i) {
                returnArray[i] = r.nextInt(max);
            }
        }
        return returnArray;
    }

    public static final void main(String[] args) {
        RandomDotOrg rand = new RandomDotOrg();
        for (int i = 0; i < 200; ++i) {
            System.out.print(" " + rand.nextInt());
        }
    }
}

