/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;

public class MatchHistory
implements Serializable {
    private Hashtable payoffs = new Hashtable();
    private Hashtable roundStatus = new Hashtable();
    public boolean practice;
    public float exchangeRate;
    public int partnerNum;
    public int[] group;
    public int groupId;
    private int numRounds;
    private boolean matchFinished = false;
    private Hashtable roundOutput = new Hashtable();
    private Vector matchOutput = new Vector();
    private Hashtable columns = new Hashtable();
    public static int ROUND_OK = 0;
    public static int ROUND_ABORTED = 1;
    public static int ROUND_UNPLAYED = 2;
    public static Category log = Category.getInstance(MatchHistory.class);

    public void addPayoff(int round, float payoff) {
        this.payoffs.put(new Integer(round), new Float(payoff));
    }

    public float getPayoff(int round) {
        Float payoff = (Float)this.payoffs.get(new Integer(round));
        if (payoff == null) {
            return 0.0f;
        }
        return payoff.floatValue();
    }

    public float getMatchPayoff() {
        float payoff = 0.0f;
        Enumeration e = this.payoffs.elements();
        while (e.hasMoreElements()) {
            payoff += ((Float)e.nextElement()).floatValue();
        }
        return payoff;
    }

    public float getMatchPayoffExchanged() {
        return this.getMatchPayoff() * this.exchangeRate;
    }

    public void clearPayoff(int round) {
        this.payoffs.remove(new Integer(round));
    }

    public void clearPayoffs() {
        Enumeration rounds = this.payoffs.keys();
        while (rounds.hasMoreElements()) {
            this.payoffs.remove(rounds.nextElement());
        }
    }

    public void setRoundStatus(int round, int status) {
        if (status == ROUND_OK || status == ROUND_ABORTED || status == ROUND_UNPLAYED) {
            this.roundStatus.put(new Integer(round), new Integer(status));
        } else {
            log.warn((Object)"Attempted to set round status to an invalid value");
        }
    }

    public int getRoundStatus(int round) {
        Integer status = (Integer)this.roundStatus.get(new Integer(round));
        if (status == null) {
            return ROUND_ABORTED;
        }
        return status;
    }

    public void addRoundOutput(int round, String[] output) {
        Vector<String[]> out = (Vector<String[]>)this.roundOutput.get(new Integer(round));
        if (out == null) {
            out = new Vector<String[]>();
            this.roundOutput.put(new Integer(round), out);
        }
        out.add(output);
    }

    public void addMatchOutput(String[] output) {
        this.matchOutput.add(output);
    }

    public Vector getMatchOutput() {
        return this.matchOutput;
    }

    public Vector getRoundOutput(int round) {
        Vector routput = (Vector)this.roundOutput.get(new Integer(round));
        if (routput == null) {
            return new Vector();
        }
        return routput;
    }

    public void addColumnData(int roundNum, String columnName, String data, Color color) {
        try {
            Hashtable column = (Hashtable)this.columns.get(columnName);
            if (column == null) {
                this.columns.put(columnName, new Hashtable());
                column = (Hashtable)this.columns.get(columnName);
                column.put("title", columnName);
                column.put("visible", new Boolean(true));
                int position = this.getLatestColumnPosition();
                column.put("position", new Integer(position));
                if (color == null) {
                    color = Color.black;
                }
                column.put("color", color);
            }
            column.put(new Integer(roundNum), data);
        }
        catch (Exception e) {
            log.error((Object)("Failed to add column data to MatchHistory object using round: " + roundNum + ", column name: " + columnName + ", and data: " + data), (Throwable)e);
        }
    }

    public void setColumnVisible(String columnName, boolean visible) {
        Hashtable column = (Hashtable)this.columns.get(columnName);
        if (column == null) {
            log.warn((Object)("Attempted to set visibility status of nonexistent column " + columnName));
            return;
        }
        column.put("visible", new Boolean(visible));
    }

    public void removeColumnData(int roundNum, String columnName) {
        Hashtable column = (Hashtable)this.columns.get(columnName);
        if (column == null) {
            return;
        }
        try {
            column.remove(new Integer(roundNum));
        }
        catch (Exception e) {
            log.warn((Object)"Attempted to remove column data given an invalid round number");
        }
    }

    public void removeColumnData(String columnName) {
        try {
            Hashtable column = (Hashtable)this.columns.get(columnName);
            if (column == null) {
                return;
            }
            int position = (Integer)column.get("position");
            this.columns.remove(columnName);
            Enumeration en = this.columns.elements();
            while (en.hasMoreElements()) {
                Hashtable col = (Hashtable)en.nextElement();
                int pos = (Integer)col.get("position");
                if (pos <= position) continue;
                col.put("position", new Integer(pos - 1));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Attempted to remove column data given an invalid column name");
        }
    }

    public void removeColumnData() {
        this.columns = new Hashtable();
    }

    public Hashtable getColumnDataTable() {
        return this.columns;
    }

    private int getLatestColumnPosition() {
        return this.columns.size() - 1;
    }

    public Vector getColumnData() {
        Enumeration en = this.columns.elements();
        Vector<Hashtable> vect = new Vector<Hashtable>();
        vect.setSize(this.columns.size());
        while (en.hasMoreElements()) {
            Hashtable column = (Hashtable)en.nextElement();
            int position = (Integer)column.get("position");
            vect.remove(position);
            vect.add(position, column);
        }
        return this.filterInvisibleColumns(vect);
    }

    public Vector getAllColumnData(Hashtable columns) {
        Enumeration en = columns.elements();
        Vector<Hashtable> vect = new Vector<Hashtable>();
        vect.setSize(columns.size());
        while (en.hasMoreElements()) {
            Hashtable column = (Hashtable)en.nextElement();
            int position = (Integer)column.get("position");
            vect.remove(position);
            vect.add(position, column);
        }
        return vect;
    }

    public void appendColumns(Hashtable oldColumns) {
        if (this.columns == null) {
            this.columns = new Hashtable();
        }
        if (oldColumns == null) {
            return;
        }
        Vector vect = this.getAllColumnData(oldColumns);
        for (int i = 0; i < vect.size(); ++i) {
            Hashtable oldColumn = (Hashtable)vect.get(i);
            String title = (String)oldColumn.get("title");
            Hashtable column = (Hashtable)this.columns.get(title);
            if (column == null) {
                this.columns.put(title, oldColumn);
                continue;
            }
            Enumeration en = oldColumn.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                Object value = oldColumn.get(key);
                column.put(key, value);
            }
        }
    }

    private Vector filterInvisibleColumns(Vector vect) {
        Vector<Hashtable> filtered = new Vector<Hashtable>();
        for (int i = 0; i < vect.size(); ++i) {
            Hashtable column = (Hashtable)vect.get(i);
            boolean visible = (Boolean)column.get("visible");
            if (!visible) continue;
            filtered.add(column);
        }
        return filtered;
    }

    public void setNumRounds(int numRounds) {
        this.numRounds = numRounds;
    }

    public int getFinalRound() {
        return this.numRounds - 1;
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public boolean getMatchFinished() {
        return this.matchFinished;
    }

    public void setMatchFinished(boolean matchFinished) {
        this.matchFinished = matchFinished;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getGroupId() {
        return this.groupId;
    }
}

