/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import java.io.Serializable;
import java.util.Hashtable;
import org.apache.log4j.Category;

public class Information
implements Serializable {
    private Hashtable info = new Hashtable();
    public static Category log = Category.getInstance(Information.class);

    public Object getInfo(Object key) {
        return this.info.get(key);
    }

    public void addInfo(Object key, Object value) {
        this.info.put(key, value);
    }

    public String getStringInfo(Object key) {
        try {
            return (String)this.info.get(key);
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse a string in information object", (Throwable)e);
            return null;
        }
    }

    public void addStringInfo(Object key, String value) {
        try {
            this.info.put(key, value);
        }
        catch (Exception e) {
            log.error((Object)"Failed to place a string value into information object", (Throwable)e);
        }
    }

    public int getIntInfo(Object key) {
        try {
            return (Integer)this.info.get(key);
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse an int in information object", (Throwable)e);
            return -1;
        }
    }

    public void addIntInfo(Object key, int value) {
        try {
            this.info.put(key, new Integer(value));
        }
        catch (Exception e) {
            log.error((Object)"Failed to place an int value into information object", (Throwable)e);
        }
    }

    public float getFloatInfo(Object key) {
        try {
            return ((Float)this.info.get(key)).floatValue();
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse a float in information object", (Throwable)e);
            return -1.0f;
        }
    }

    public void addFloatInfo(Object key, float value) {
        try {
            this.info.put(key, new Float(value));
        }
        catch (Exception e) {
            log.error((Object)"Failed to place a float value into information object", (Throwable)e);
        }
    }

    public boolean getBooleanInfo(Object key) {
        try {
            return (Boolean)this.info.get(key);
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse a boolean in information object", (Throwable)e);
            return false;
        }
    }

    public void addBooleanInfo(Object key, boolean value) {
        try {
            this.info.put(key, new Boolean(value));
        }
        catch (Exception e) {
            log.error((Object)"Failed to place a boolean value into information object", (Throwable)e);
        }
    }

    public Hashtable getTable() {
        return this.info;
    }
}

