/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;

public class GeneralMap
implements Serializable {
    private Hashtable mappings = new Hashtable();
    public static Category log = Category.getInstance(GeneralMap.class);

    public void addMapping(String ruleString) {
        try {
            int i;
            if (ruleString == null) {
                return;
            }
            log.debug((Object)("Rule string-- " + ruleString + ", received to construct an input-output mapping"));
            StringTokenizer st = new StringTokenizer(ruleString, ",");
            String token = st.nextToken();
            String[] rs = token.split("-");
            token = st.nextToken();
            String[] as = token.split("-");
            if (rs == null || as == null) {
                return;
            }
            Vector<String> rules = new Vector<String>();
            Vector<String> actions = new Vector<String>();
            for (i = 0; i < rs.length; ++i) {
                rules.add(rs[i].trim());
            }
            for (i = 0; i < as.length; ++i) {
                actions.add(as[i].trim());
            }
            this.mappings.put(rules, actions);
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse the rule-- " + ruleString + " : " + e.toString()));
            e.printStackTrace();
        }
    }

    public void addMapping(String[] rules, String[] actions) {
        this.mappings.put(rules, actions);
    }

    public String[] getMapping(String[] rs) {
        Vector<String> rules = new Vector<String>();
        for (int i = 0; i < rs.length; ++i) {
            rules.add(rs[i]);
        }
        Vector actions = (Vector)this.mappings.get(rules);
        if (actions == null) {
            return null;
        }
        String[] as = new String[actions.size()];
        for (int i = 0; i < as.length; ++i) {
            as[i] = (String)actions.get(i);
        }
        return as;
    }

    public String getMapping(int index, String[] rules) {
        String[] actions = this.getMapping(rules);
        if (actions == null || index < 0 || index >= actions.length) {
            return null;
        }
        return actions[index];
    }
}

