/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.Question;
import java.util.Random;

public class DropdownQuestion
extends Question {
    public DropdownQuestion(String question, String answer, String[] options) {
        this.question = question;
        this.options = options;
        this.answer = answer;
        this.isSurvey = false;
        this.outputName = null;
        this.style = DROP_DOWN_QUESTION;
    }

    public DropdownQuestion(String question, String[] options, String outputName) {
        this.question = question;
        this.options = options;
        this.answer = null;
        this.isSurvey = true;
        this.outputName = outputName;
        this.style = DROP_DOWN_QUESTION;
    }

    public DropdownQuestion(String question, String[] options) {
        this(question, options, null);
    }

    public DropdownQuestion(String question) {
        this(question, "", null);
    }

    public String getTestingModeAnswer() {
        if (!this.isSurvey && this.answer != null) {
            return this.answer;
        }
        if (this.options != null && this.options.length > 0) {
            int numOptions = this.options.length;
            Random rand = new Random();
            int randChoice = rand.nextInt(numOptions);
            return this.options[randChoice];
        }
        return "test error";
    }

    public void setAnswerIndex(int index) {
        if (this.style != DROP_DOWN_QUESTION) {
            return;
        }
        if (this.options != null && 0 <= index && index < this.options.length) {
            this.answer = this.options[index];
        }
    }

    public int getAnswerIndex() {
        if (this.answer == null || this.options == null || this.isSurvey || this.style != DROP_DOWN_QUESTION) {
            return -1;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.answer.equals(this.options[i])) continue;
            return i;
        }
        return -1;
    }

    public int getChosenAnswerIndex() {
        if (this.chosenAnswer == null || this.options == null || this.style != DROP_DOWN_QUESTION) {
            return -1;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.chosenAnswer.equals(this.options[i])) continue;
            return i;
        }
        return -1;
    }
}

