/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.Question;

public class DegreeQuestion
extends Question {
    private String[] questions;
    private String[] choices;

    public DegreeQuestion(String instructions, String[] questions, String[] options, String outputName) {
        this.options = questions;
        this.choices = options;
        this.question = this.generateQuestion(instructions, options);
        this.isSurvey = true;
        this.outputName = outputName;
        this.style = DEGREE_QUESTION;
    }

    public DegreeQuestion(String instructions, String[] questions, String[] options) {
        this(instructions, questions, options, null);
    }

    public String[] getQuestions() {
        return this.questions;
    }

    public void setQuestions(String[] questions) {
        this.questions = questions;
    }

    private String generateQuestion(String instructions, String[] options) {
        int i;
        StringBuffer sb = new StringBuffer("<html>");
        sb.append(instructions);
        sb.append("<br><table border=1 cellspacing=5><tr align=center>");
        for (i = 1; i <= options.length; ++i) {
            sb.append("<td>" + i + "</td>");
        }
        sb.append("</tr><tr align=center>");
        for (i = 0; i < options.length; ++i) {
            sb.append("<td>" + options[i] + "</td>");
        }
        sb.append("</table></html>");
        return sb.toString();
    }

    public int getMaxOption() {
        return this.choices.length;
    }

    public int getMinOption() {
        return 1;
    }
}

