/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.MatchHistory;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class ClientUpdate
implements Serializable {
    private int currentRound;
    private int numRounds;
    private float payoff;
    private Hashtable clientColumns;
    private Hashtable futureClientColumns;
    private int groupId;
    private int partnerNum;
    private int[] partners;
    private int currentMatch;
    private MatchHistory matchHistory;
    private boolean isMatchUpdate;
    public static Category log = Category.getInstance(ClientUpdate.class);

    public ClientUpdate(int currentMatch, int currentRound) {
        this.currentMatch = currentMatch;
        this.currentRound = currentRound;
        this.isMatchUpdate = false;
        this.clientColumns = new Hashtable();
        this.futureClientColumns = new Hashtable();
    }

    public void installMatchInfo(ClientData cdata) {
        this.groupId = cdata.getGroupId();
        this.partnerNum = cdata.getPartnerNum();
        this.partners = cdata.getPartners();
        this.matchHistory = (MatchHistory)cdata.getMatchHistory().get(new Integer(this.currentMatch));
        this.isMatchUpdate = true;
    }

    public ClientData updateMatchData(ClientData cdata) {
        cdata.setGroupId(this.groupId);
        cdata.setPartnerNum(this.partnerNum);
        cdata.setPartners(this.partners);
        cdata.setCurrentMatch(this.currentMatch);
        Hashtable hist = cdata.getMatchHistory();
        hist.put(new Integer(this.currentMatch), this.matchHistory);
        cdata.setMatchHistory(hist);
        cdata.setCurrentMatch(this.currentMatch);
        return cdata;
    }

    public ClientData updateRoundData(ClientData cdata) {
        try {
            cdata.addPayoffToHistory(this.currentMatch, this.currentRound, this.payoff);
            if (cdata.getNumRounds(this.currentMatch) < this.numRounds) {
                cdata.setNumRounds(this.currentMatch, this.numRounds);
            }
            this.updateClientColumnData(cdata, this.clientColumns, this.currentRound);
            this.updateClientColumnData(cdata, this.futureClientColumns, this.currentRound + 1);
            return cdata;
        }
        catch (Exception e) {
            log.error((Object)("Failed to update round data using ClientUpdate procedures" + MSConstants.newline + e));
            return null;
        }
    }

    private void updateClientColumnData(ClientData cdata, Hashtable clientColumns, int round) {
        if (clientColumns == null || clientColumns.size() <= 0) {
            return;
        }
        Set hashSet = clientColumns.entrySet();
        for (Map.Entry element : hashSet) {
            String visible;
            Object[] id = (Object[])element.getKey();
            int match = (Integer)id[0];
            String column = (String)id[1];
            Object[] columnData = (Object[])element.getValue();
            String data = (String)columnData[0];
            Color color = (Color)columnData[1];
            if (data != null && color != null) {
                cdata.addColumnData(match, round, column, data, color);
            }
            if ((visible = (String)columnData[2]) != null && visible.equals("true")) {
                cdata.setColumnVisible(match, column, true);
            }
            if (visible == null || !visible.equals("false")) continue;
            cdata.setColumnVisible(match, column, false);
        }
    }

    public void setPayoff(float payoff) {
        this.payoff = payoff;
    }

    public void setPartnerNum(int partnerNum) {
        this.partnerNum = partnerNum;
    }

    public void setPartners(int[] partners) {
        this.partners = partners;
    }

    public void setCurrentMatch(int match) {
        this.currentMatch = match;
    }

    public void setFutureClientColumns(Hashtable c) {
        this.futureClientColumns = c;
    }

    public Hashtable getClientColumns() {
        return this.clientColumns;
    }

    public void resetClientColumns() {
        this.clientColumns = new Hashtable();
    }

    public void incrementRound() {
        ++this.currentRound;
    }

    public boolean isMatchUpdate() {
        return this.isMatchUpdate;
    }

    public void addColumnData(int match, String columnName, String data, Color color) {
        Object[] id = new Object[]{new Integer(match), columnName};
        Object[] priorData = (Object[])this.clientColumns.get(id);
        if (priorData != null) {
            priorData[0] = data;
            priorData[1] = color;
            this.clientColumns.put(id, priorData);
        } else {
            Object[] columnData = new Object[]{data, color, null};
            this.clientColumns.put(id, columnData);
        }
    }

    public void setColumnVisible(int match, String columnName, boolean visible) {
        Object[] priorData;
        Object[] id = new Object[]{new Integer(match), columnName};
        String visible_str = "true";
        if (!visible) {
            visible_str = "false";
        }
        if ((priorData = (Object[])this.clientColumns.get(id)) != null) {
            priorData[2] = visible_str;
            this.clientColumns.put(id, priorData);
        } else {
            Object[] columnData = new Object[]{null, null, visible_str};
            this.clientColumns.put(id, columnData);
        }
    }

    public void setNumRounds(int numRounds) {
        this.numRounds = numRounds;
    }
}

