/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.MatchHistory;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClientData
implements Serializable {
    private int id;
    private int groupId;
    private String name;
    private boolean connected;
    private int partnerNum;
    private int[] partners;
    private Hashtable matchHistory;
    private MatchHistory currentHistory;
    private int currentMatch;

    public ClientData(int id, String name, boolean connected) {
        this.id = id;
        this.name = name;
        this.connected = connected;
        this.partners = null;
        this.matchHistory = new Hashtable();
        this.partnerNum = -1;
        this.currentMatch = 0;
    }

    public ClientData() {
    }

    public void createNewMatch(int matchNum) {
        this.matchHistory.put(new Integer(matchNum), new MatchHistory());
    }

    public int getNumMatches() {
        return this.matchHistory.size();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(boolean connected) {
        this.connected = connected;
    }

    public boolean getStatus() {
        return this.connected;
    }

    public void setPartners(int[] partners) {
        this.partners = partners;
    }

    public int[] getPartners() {
        return this.partners;
    }

    public int getPartnerNum() {
        return this.partnerNum;
    }

    public void setPartnerNum(int partnerNum) {
        this.partnerNum = partnerNum;
    }

    public float getPayoff(int match, int round) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 0.0f;
        }
        return hist.getPayoff(round);
    }

    public void setNumRounds(int match, int numRounds) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.setNumRounds(numRounds);
    }

    public int getCurrentRound() {
        return this.getFinalRound(this.currentMatch);
    }

    public int getFinalRound(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 0;
        }
        return hist.getFinalRound();
    }

    public int getNumRounds(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 0;
        }
        return hist.getNumRounds();
    }

    public Vector getRoundOutput(int matchNum, int roundNum) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return new Vector();
        }
        return hist.getRoundOutput(roundNum);
    }

    public Vector getMatchOutput(int matchNum) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return new Vector();
        }
        return hist.getMatchOutput();
    }

    public void setCurrentMatch(int currentMatch) {
        this.currentMatch = currentMatch;
        this.currentHistory = (MatchHistory)this.matchHistory.get(new Integer(currentMatch));
    }

    public int getCurrentMatch() {
        return this.currentMatch;
    }

    public int getPartnerNum(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return -1;
        }
        int[] group = hist.group;
        for (int i = 0; i < group.length; ++i) {
            if (group[i] != this.id) continue;
            return i;
        }
        return -1;
    }

    public boolean getMatchFinished(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return false;
        }
        return hist.getMatchFinished();
    }

    public void setMatchFinished(int match, boolean matchFinished) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.setMatchFinished(matchFinished);
    }

    public void addRoundOutput(int match, int round, String[] output) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.addRoundOutput(round, output);
    }

    public void addMatchOutput(int match, String[] output) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.addMatchOutput(output);
    }

    public void addPayoffToHistory(int match, int round, float payoff) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.addPayoff(round, payoff);
    }

    public float getTotalPayoff() {
        float totalPayoff = 0.0f;
        Enumeration matches = this.matchHistory.elements();
        while (matches.hasMoreElements()) {
            MatchHistory hist = (MatchHistory)matches.nextElement();
            if (hist.practice) continue;
            totalPayoff += hist.getMatchPayoff();
        }
        return totalPayoff;
    }

    public float getMatchPayoff(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 0.0f;
        }
        return hist.getMatchPayoff();
    }

    public float getMatchPayoffExchanged(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 0.0f;
        }
        return hist.getMatchPayoffExchanged();
    }

    public float getLastMatchPayoffExchanged() {
        return this.getMatchPayoffExchanged(this.currentMatch);
    }

    public void clearPayoffs(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.clearPayoffs();
    }

    public void clearAllPayoffs() {
        Enumeration matches = this.matchHistory.elements();
        while (matches.hasMoreElements()) {
            MatchHistory hist = (MatchHistory)matches.nextElement();
            hist.clearPayoffs();
        }
    }

    public float getTotalPayoffExchanged() {
        float totalPayoff = 0.0f;
        Enumeration matches = this.matchHistory.elements();
        while (matches.hasMoreElements()) {
            MatchHistory hist = (MatchHistory)matches.nextElement();
            if (hist.practice) continue;
            totalPayoff += hist.getMatchPayoffExchanged();
        }
        return totalPayoff;
    }

    public double getTotalPayoffExchangedAndRounded() {
        float totalPayoff = this.getTotalPayoffExchanged();
        if (Math.IEEEremainder(totalPayoff, 0.25) == 0.0) {
            return totalPayoff;
        }
        double quotient = Math.floor(totalPayoff * 100.0f / 25.0f);
        double rounded = quotient * 25.0 / 100.0;
        return rounded + 0.25;
    }

    public void addPartnersToHistory(int match, int[] partners) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.group = partners;
    }

    public int[] getPartnerHistory(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return null;
        }
        return hist.group;
    }

    public void setGroupId(int match, int groupId) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.groupId = groupId;
    }

    public int getGroupId(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return -1;
        }
        return hist.groupId;
    }

    public void addExchangeRate(float exchangeRate) {
        this.currentHistory.exchangeRate = exchangeRate;
    }

    public float getExchangeRate(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return 1.0f;
        }
        return hist.exchangeRate;
    }

    public void addPracticeMatch(boolean practice) {
        this.currentHistory.practice = practice;
    }

    public boolean isPracticeMatch(int match) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return false;
        }
        return hist.practice;
    }

    public void setRoundStatus(int match, int round, int status) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return;
        }
        hist.setRoundStatus(round, status);
    }

    public int getRoundStatus(int match, int round) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(match));
        if (hist == null) {
            return MatchHistory.ROUND_ABORTED;
        }
        return hist.getRoundStatus(round);
    }

    public boolean isPracticeLastMatch() {
        return this.currentHistory.practice;
    }

    public void vectorAdd(Vector vect, int index) {
        int size;
        for (int i = size = vect.size(); i <= index; ++i) {
            vect.add(new Vector());
        }
    }

    public void addColumnData(int matchNum, int roundNum, String columnName, String data, Color color) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return;
        }
        hist.addColumnData(roundNum, columnName, data, color);
    }

    public Vector getColumnData(int matchNum) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return new Vector();
        }
        return hist.getColumnData();
    }

    public void removeColumnData(int matchNum, int roundNum, String columnName) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return;
        }
        hist.removeColumnData(roundNum, columnName);
    }

    public void setColumnVisible(int matchNum, String columnName, boolean visible) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return;
        }
        hist.setColumnVisible(columnName, visible);
    }

    public void removeColumnData(int matchNum, String columnName) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return;
        }
        hist.removeColumnData(columnName);
    }

    public void removeColumnData(int matchNum) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return;
        }
        hist.removeColumnData();
    }

    public Hashtable getColumnDataTable(int matchNum) {
        MatchHistory hist = (MatchHistory)this.matchHistory.get(new Integer(matchNum));
        if (hist == null) {
            return null;
        }
        return hist.getColumnDataTable();
    }

    public Hashtable getMatchHistory() {
        return this.matchHistory;
    }

    public void setMatchHistory(Hashtable matchHistory) {
        this.matchHistory = matchHistory;
    }

    public Vector getMatchHistoryVector() {
        Vector hist = new Vector(this.matchHistory.values());
        return hist;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }
}

