/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.shared.data;

import edu.caltech.ssel.multistage.shared.data.Question;
import java.util.Random;

public class ChoiceQuestion
extends Question {
    private String other;

    public ChoiceQuestion(String question, String answer, String[] options) {
        this.question = question;
        this.options = options;
        this.answer = answer;
        this.isSurvey = false;
        this.outputName = null;
        this.style = CHOICE_QUESTION;
    }

    public ChoiceQuestion(String question, String[] options, String outputName) {
        this.question = question;
        this.options = options;
        this.answer = null;
        this.isSurvey = true;
        this.outputName = outputName;
        this.style = CHOICE_QUESTION;
    }

    public ChoiceQuestion(String question, String[] options) {
        this(question, options, null);
    }

    public ChoiceQuestion(String question) {
        this(question, "", null);
    }

    public String getTestingModeAnswer() {
        if (!this.isSurvey && this.answer != null) {
            return this.answer;
        }
        if (this.options != null && this.options.length > 0) {
            Random rand;
            int randChoice;
            int numOptions = this.options.length;
            if (this.getOtherChoice() != null) {
                ++numOptions;
            }
            if ((randChoice = (rand = new Random()).nextInt(numOptions)) == numOptions - 1 && this.getOtherChoice() != null) {
                return "Test Answer";
            }
            return this.options[randChoice];
        }
        return "test error";
    }

    public void setAnswerIndex(int index) {
        if (this.style != CHOICE_QUESTION) {
            return;
        }
        if (this.options != null && 0 <= index && index < this.options.length) {
            this.answer = this.options[index];
        }
    }

    public int getAnswerIndex() {
        if (this.answer == null || this.options == null || this.isSurvey || this.style != CHOICE_QUESTION) {
            return -1;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.answer.equals(this.options[i])) continue;
            return i;
        }
        return -1;
    }

    public int getChosenAnswerIndex() {
        if (this.chosenAnswer == null || this.options == null || this.style != CHOICE_QUESTION) {
            return -1;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.chosenAnswer.equals(this.options[i])) continue;
            return i;
        }
        return -1;
    }

    public void setOtherChoice(String other) {
        this.other = other;
    }

    public String getOtherChoice() {
        return this.other;
    }

    public boolean hasOtherQuestion() {
        return this.other != null;
    }
}

