/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.pluginservice;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginDescriptor;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginService
extends ServerVariables {
    private String pluginPath;
    private Hashtable<String, PluginDescriptor> table;
    public static Category log = Logger.getLogger(PluginService.class);
    private Vector<String> dependenciesFound;

    public PluginService(String path) {
        this.pluginPath = path;
        this.dependenciesFound = new Vector();
        pluginDescriptors = new Vector();
        this.gatherAllDescriptors(this.pluginPath);
    }

    private String getName(String id, String version) {
        return id + "," + version;
    }

    public PluginDescriptor getDescriptor(String name, String version) {
        if (this.table.containsKey(this.getName(name, version))) {
            return this.table.get(this.getName(name, version));
        }
        return null;
    }

    public PluginDescriptor getDescriptor(String name) {
        log.debug((Object)("PluginService.getDescriptor called with name==" + name));
        if (this.table.containsKey(name)) {
            log.debug((Object)("returning descriptor with serverController==" + this.table.get(name).getServerClassname()));
            return this.table.get(name);
        }
        log.debug((Object)("returning NULL DESCRIPTOR (asked for: " + name + ")"));
        return null;
    }

    public boolean pluginFound(String name) {
        return this.table.containsKey(name);
    }

    private void gatherAllDescriptors(String path) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        this.pluginPath = path;
        File rootDir = new File(path);
        if (rootDir.isDirectory()) {
            String[] contents = rootDir.list();
            for (int i = 0; i < contents.length; ++i) {
                String completePath = rootDir.getAbsolutePath() + File.separator + contents[i];
                File f = new File(completePath);
                if (f.isDirectory()) {
                    this.gatherAllDescriptors(completePath);
                    continue;
                }
                if (!f.isFile() || !f.getName().equalsIgnoreCase("plugin.xml")) continue;
                log.debug((Object)("PluginService trying to open: " + f.getAbsolutePath()));
                PluginDescriptor pd = this.getPluginDescriptor(f);
                if (pd == null) continue;
                log.debug((Object)("inserting plugin with name== " + pd.getName()));
                this.table.put(pd.getName(), pd);
            }
        }
    }

    private PluginDescriptor getPluginDescriptor(File f) {
        boolean matches = false;
        try {
            PluginDescriptor pd;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(f);
            NamedNodeMap atts = doc.getDocumentElement().getAttributes();
            if (doc == null || atts == null || atts.getNamedItem("name") == null) {
                log.error((Object)("PluginService: something in doc.getAttributes is NULL - this indicates a malformed xml file: " + f.getAbsolutePath()));
                return null;
            }
            String idAttribute = doc.getDocumentElement().getAttributes().getNamedItem("name").getTextContent();
            NodeList controlList = doc.getElementsByTagName("serverController");
            NodeList guiList = doc.getElementsByTagName("clientGUI");
            if (controlList.getLength() > 0 && guiList.getLength() > 0) {
                log.debug((Object)("serverController==" + controlList.item(0).getTextContent() + ", clientGUI==" + guiList.item(0).getTextContent()));
                pd = new PluginDescriptor(idAttribute, controlList.item(0).getTextContent(), guiList.item(0).getTextContent());
            } else {
                pd = new PluginDescriptor(idAttribute);
            }
            if (doc.getElementsByTagName("matcher").getLength() > 0) {
                pd.setMatchingClassname(doc.getElementsByTagName("matcher").item(0).getTextContent());
            }
            if (doc.getElementsByTagName("parameterVerifier").getLength() > 0) {
                pd.setMatchingClassname(doc.getElementsByTagName("parameterVerifier").item(0).getTextContent());
            }
            this.dependenciesFound.clear();
            if (doc.getElementsByTagName("dependency").getLength() > 0) {
                for (int d = 0; d < doc.getElementsByTagName("dependency").getLength(); ++d) {
                    Node dep = doc.getElementsByTagName("dependency").item(d);
                    String nameDep = dep.getAttributes().getNamedItem("name").getTextContent();
                    String versionDep = dep.getAttributes().getNamedItem("version").getTextContent();
                    if (!this.checkForDependency(".." + File.separator + "plugins", nameDep, versionDep)) {
                        log.error((Object)("Plugin is asking for a dependency named " + nameDep + " (version " + versionDep + "), but that plugin isn't found..."));
                        return null;
                    }
                    log.debug((Object)("Plugin is asking for a dependency named " + nameDep + " (version " + versionDep + "), and that plugin is found"));
                }
            }
            return pd;
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
            log.error((Object)("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId()));
            log.error((Object)(" " + err.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkForDependency(String nameAttribute, String versionAttribute) {
        return this.table.containsKey(this.getName(nameAttribute, versionAttribute));
    }

    private boolean checkForDependency(String path, String nameAttribute, String versionAttribute) {
        log.debug((Object)("checkForDependency called with path==" + path + ", and nameAttribute==" + nameAttribute + ", and versionAttribute=" + versionAttribute));
        File rootDir = new File(path);
        if (this.dependenciesFound.contains(this.getName(nameAttribute, versionAttribute))) {
            log.debug((Object)("a dependency had been previously discovered which matches id-version " + this.getName(nameAttribute, versionAttribute)));
            return true;
        }
        boolean rval = false;
        if (rootDir.isDirectory()) {
            String[] contents = rootDir.list();
            log.debug((Object)("path is a directory - it has contents.length==" + contents.length));
            for (int i = 0; i < contents.length; ++i) {
                log.debug((Object)("examining contents[" + i + "]==" + contents[i]));
                String completePath = rootDir.getAbsolutePath() + File.separator + contents[i];
                File f = new File(completePath);
                if (f.isDirectory()) {
                    log.debug((Object)("recursively calling checkForDependency on new path: " + completePath));
                    if (!this.checkForDependency(completePath, nameAttribute, versionAttribute)) continue;
                    return true;
                }
                if (!f.isFile() || !f.getName().equalsIgnoreCase("plugin.xml")) continue;
                try {
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(f);
                    NamedNodeMap atts = doc.getDocumentElement().getAttributes();
                    if (doc == null || atts == null || atts.getNamedItem("name") == null || atts.getNamedItem("version") == null) {
                        log.debug((Object)"something in doc.getAttributes is NULL");
                        return false;
                    }
                    String checkName = doc.getDocumentElement().getAttributes().getNamedItem("name").getTextContent();
                    String checkVersion = doc.getDocumentElement().getAttributes().getNamedItem("version").getTextContent();
                    String entry = this.getName(checkName, checkVersion);
                    if (!this.dependenciesFound.contains(this.getName(checkName, checkVersion))) {
                        log.debug((Object)("adding a previously undiscovered dependency to the list: " + entry));
                        this.dependenciesFound.add(entry);
                    }
                    if (checkName.equalsIgnoreCase(nameAttribute) && checkVersion.equalsIgnoreCase(versionAttribute)) {
                        log.debug((Object)("Found dependency plugin with name=" + checkName + " and version=" + checkVersion));
                        if (doc.getElementsByTagName("dependency").getLength() > 0) {
                            boolean[] found = new boolean[doc.getElementsByTagName("dependency").getLength()];
                            for (int d = 0; d < doc.getElementsByTagName("dependency").getLength(); ++d) {
                                Node dep = doc.getElementsByTagName("dependency").item(d);
                                String nameDep = dep.getAttributes().getNamedItem("name").getTextContent();
                                String versionDep = dep.getAttributes().getNamedItem("version").getTextContent();
                                if (!this.checkForDependency(".." + File.separator + "plugins", nameDep, versionDep)) {
                                    log.error((Object)("Plugin is asking for a dependency named " + nameDep + " (version " + versionDep + "), but that plugin isn't found..."));
                                    found[d] = false;
                                    continue;
                                }
                                log.debug((Object)("Plugin is asking for a dependency named " + nameDep + " (version " + versionDep + "), and that plugin is found...(inside checkForDependency)!"));
                                found[d] = true;
                            }
                            boolean allFound = true;
                            for (int af = 0; af < found.length; ++af) {
                                if (found[af]) continue;
                                allFound = false;
                            }
                            if (!allFound) {
                                log.error((Object)("The plugin service found the requested dependency (" + this.getName(nameAttribute, versionAttribute) + "), but that plugin itself is missing dependencies."));
                                return false;
                            }
                        }
                        return true;
                    }
                    log.debug((Object)("Failed to find dependency with name=" + nameAttribute + " and version=" + versionAttribute + " in file " + contents[i]));
                    continue;
                }
                catch (SAXParseException err) {
                    System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println(" " + err.getMessage());
                    continue;
                }
                catch (SAXException e) {
                    Exception x = e.getException();
                    (x == null ? e : x).printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("path==" + path + " is NOT a directory!");
        }
        return rval;
    }
}

