/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.paramverifiers;

import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class VoterVerifier
extends ParamVerifier {
    private boolean useCommonNP;
    private int distributionType;
    private static int NO_DISTRIBUTION_USED = 0;
    private static int UNIFORM_DISTRIBUTION = 1;
    private static int BINOMIAL_DISTRIBUTION = 2;
    private static int NORMAL_DISTRIBUTION = 3;

    protected void fillGameSpecificParams(int groupSize) {
        final int gsize = groupSize;
        Param majoritySize = new Param("majoritySize"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (value == null) {
                    throw new InvalidParameterException("Majority group size must be specified (majoritySize)");
                }
                if (!VoterVerifier.this.isInt(value)) {
                    throw new InvalidParameterException("Majority size must be specified as an integer");
                }
                int size = Integer.parseInt(value);
                if (size > gsize) {
                    throw new InvalidParameterException("The majority party size must be less than the group size");
                }
                if (size <= 0) {
                    throw new InvalidParameterException("The majority party size must be greater than zero");
                }
                return true;
            }
        };
        this.addParam(majoritySize);
        Param winPayoff = new Param("winPayoff"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (value == null) {
                    throw new InvalidParameterException("Win payoff must be specified (winPayoff)");
                }
                if (!VoterVerifier.this.isFloat(value)) {
                    throw new InvalidParameterException("Win payoff must be specified as a float (number) value");
                }
                return true;
            }
        };
        this.addParam(winPayoff);
        Param lossPayoff = new Param("lossPayoff"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (value == null) {
                    throw new InvalidParameterException("Loss payoff must be specified (lossPayoff)");
                }
                if (!VoterVerifier.this.isFloat(value)) {
                    throw new InvalidParameterException("Loss payoff must be specified as a float (number) value");
                }
                return true;
            }
        };
        this.addParam(lossPayoff);
        Param tiePayoff = new Param("tiePayoff"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (value == null) {
                    throw new InvalidParameterException("Tie payoff must be specified (tiePayoff)");
                }
                if (!VoterVerifier.this.isFloat(value)) {
                    throw new InvalidParameterException("Tie payoff must be specified as a float (number) value");
                }
                return true;
            }
        };
        this.addParam(tiePayoff);
        Param useCommonNPBonus = new Param("useCommonNPBonus"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (!VoterVerifier.this.isBoolean(value)) {
                    throw new InvalidParameterException("The common NP bonus parameter must be set to either 'true' or 'false'");
                }
                if (value.equals("true")) {
                    VoterVerifier.this.useCommonNP = true;
                } else {
                    VoterVerifier.this.useCommonNP = false;
                }
                return true;
            }
        };
        this.addParam(useCommonNPBonus);
        Param nonPartBonus = new Param("nonParticipationBonus"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (!VoterVerifier.this.useCommonNP) {
                    return true;
                }
                if (value == null) {
                    throw new InvalidParameterException("Non participation bonus must be specified if useCommonNPBonus is set to true");
                }
                if (!VoterVerifier.this.isInt(value)) {
                    throw new InvalidParameterException("Non participation bonus must be specified as an integer");
                }
                return true;
            }
        };
        this.addParam(nonPartBonus);
        this.distributionType = NO_DISTRIBUTION_USED;
        Param distribution = new Param("distribution"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (VoterVerifier.this.useCommonNP) {
                    return true;
                }
                if (value == null) {
                    throw new InvalidParameterException("A distribution type (binomial, uniform, or normal) must be specified if useCommonNPBonus is set to false");
                }
                if (!(value.equalsIgnoreCase("binomial") || value.equalsIgnoreCase("uniform") || value.equalsIgnoreCase("normal"))) {
                    throw new InvalidParameterException("The distribution type must be equal to 'uniform', 'binomial', or 'normal'");
                }
                if (value.equalsIgnoreCase("binomial")) {
                    VoterVerifier.this.distributionType = BINOMIAL_DISTRIBUTION;
                }
                if (value.equalsIgnoreCase("uniform")) {
                    VoterVerifier.this.distributionType = UNIFORM_DISTRIBUTION;
                }
                if (value.equalsIgnoreCase("normal")) {
                    VoterVerifier.this.distributionType = NORMAL_DISTRIBUTION;
                }
                return true;
            }
        };
        this.addParam(distribution);
        Param distParams = new Param("distributionParams"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (VoterVerifier.this.distributionType == NO_DISTRIBUTION_USED) {
                    return true;
                }
                if (value == null) {
                    throw new InvalidParameterException("Distribution parameters must be specified if using a distribution");
                }
                try {
                    double[] params = null;
                    StringTokenizer st = new StringTokenizer(value, ",");
                    params = new double[st.countTokens()];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = Double.parseDouble(st.nextToken());
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new InvalidParameterException("Error parsing the distribution params. Make sure they are in the proper (comma-separated) format");
                }
            }
        };
        this.addParam(distParams);
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        if (groupSize == 1) {
            throw new InvalidParameterException("This game requires more than one player");
        }
        return true;
    }
}

