/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.paramverifiers;

import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import java.util.Hashtable;

public class TestVerifier
extends ParamVerifier {
    protected void fillGameSpecificParams(int groupSize) {
        Param stringParam = new Param("stringTestParameter"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                return true;
            }
        };
        stringParam.setRequired(true);
        this.addParam(stringParam);
        Param intParam = new Param("intTestParameter"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                if (value == null) {
                    return true;
                }
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidParameterException("intTestParameter must have an integer value.");
                }
                return true;
            }
        };
        intParam.setRequired(false);
        intParam.setInitialValue("0");
        this.addParam(intParam);
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        if (groupSize > 30) {
            throw new InvalidParameterException("Test group size MUST be no more than 30");
        }
        return true;
    }
}

