/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.paramverifiers;

import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SocialnetVerifier
extends ParamVerifier {
    protected void fillGameSpecificParams(int groupSize) {
        final int gsize = groupSize;
        Param revealNet = new Param("revealnet", true);
        revealNet.setLabel("Reveal Network");
        revealNet.setInitialValue("true");
        this.addParam(revealNet);
        for (int i = 0; i < groupSize; ++i) {
            final int playerNum = i;
            Param net = new Param("socialnet." + i + ".net", true){

                public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                    try {
                        Vector vect = SocialnetVerifier.this.getIdsValues(value);
                        int[] ids = (int[])vect.get(0);
                        int[] values = (int[])vect.get(1);
                        for (int i = 0; i < ids.length; ++i) {
                            if (ids[i] > gsize) {
                                throw new InvalidParameterException("Invalid ID given in network: there is no player " + ids[i] + " in a group size of " + gsize);
                            }
                            if (ids[i] != playerNum) continue;
                            throw new InvalidParameterException("Player " + playerNum + " cannot reward his/her self");
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw new InvalidParameterException(e.getMessage());
                    }
                }
            };
            net.setLabel("Player " + i + " Network");
            net.setInitialValue("(Id, Value), ...");
            this.addParam(net);
        }
    }

    private Vector getIdsValues(String idStr) throws InvalidParameterException {
        try {
            StringTokenizer tok = new StringTokenizer(idStr, "(");
            int numIds = tok.countTokens();
            int[] ids = new int[numIds];
            int[] values = new int[numIds];
            for (int i = 0; i < numIds; ++i) {
                String leftParen = tok.nextToken();
                StringTokenizer numberTok = new StringTokenizer(leftParen, ", )");
                ids[i] = Integer.parseInt(numberTok.nextToken());
                values[i] = Integer.parseInt(numberTok.nextToken());
            }
            Vector<int[]> vect = new Vector<int[]>();
            if (ids.length != values.length) {
                throw new Exception();
            }
            vect.add(ids);
            vect.add(values);
            return vect;
        }
        catch (Exception e) {
            throw new InvalidParameterException("The Network string is improperly formatted");
        }
    }

    public String getLetter(int player) {
        int charIndex = player % 26 + 65;
        int numLetters = 1 + player / 26;
        char letter = (char)charIndex;
        String letters = "";
        for (int i = 0; i < numLetters; ++i) {
            letters = letters + letter;
        }
        return letters;
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        if (groupSize < 2) {
            throw new InvalidParameterException("Social Networks group size must be greater than 1");
        }
        return true;
    }
}

