/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.paramverifiers;

import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PldkVerifier
extends ParamVerifier {
    protected void fillGameSpecificParams(int groupSize) {
        Param showPartnerHistory = new Param("showPartnerHistory");
        this.addParam(showPartnerHistory);
        Param showPartnerPayoff = new Param("showPartnerPayoff");
        this.addParam(showPartnerPayoff);
        Param showPlayerPayoff = new Param("showPlayerPayoff");
        this.addParam(showPlayerPayoff);
        Param showPreviousHistory = new Param("showPreviousHistory");
        this.addParam(showPreviousHistory);
        Param rowLabels = new Param("rowLabels"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                String rowPayoff = (String)allValues.get("rowPayoffMatrix");
                String colPayoff = (String)allValues.get("colPayoffMatrix");
                String colLabels = (String)allValues.get("columnLabels");
                int numLabels = PldkVerifier.this.countEntries(value);
                int numPayoffs = PldkVerifier.this.countEntries(rowPayoff);
                if (!PldkVerifier.this.isMultiple(numPayoffs, numLabels)) {
                    throw new InvalidParameterException("The number of row payoffs must be a multiple of the number of row labels");
                }
                int total = PldkVerifier.this.countEntries(colLabels) * numLabels;
                if (total != PldkVerifier.this.countEntries(rowPayoff)) {
                    throw new InvalidParameterException("The row payoff matrix does not have the proper amount of entries to match the labels");
                }
                if (total != PldkVerifier.this.countEntries(colPayoff)) {
                    throw new InvalidParameterException("Thw column payoff matrix does not have the proper amount of entries to match the labels");
                }
                return true;
            }
        };
        this.addParam(rowLabels);
        Param colLabels = new Param("columnLabels"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                String colPayoff = (String)allValues.get("colPayoffMatrix");
                String rowPayoff = (String)allValues.get("rowPayoffMatrix");
                String rowLabels = (String)allValues.get("rowLabels");
                int numLabels = PldkVerifier.this.countEntries(value);
                int numPayoffs = PldkVerifier.this.countEntries(colPayoff);
                if (!PldkVerifier.this.isMultiple(numPayoffs, numLabels)) {
                    throw new InvalidParameterException("The number of column payoffs must be a multiple of the number of column labels");
                }
                int total = PldkVerifier.this.countEntries(rowLabels) * numLabels;
                if (total != PldkVerifier.this.countEntries(rowPayoff)) {
                    throw new InvalidParameterException("The row payoff matrix does not have the proper amount of entries to match the labels");
                }
                if (total != PldkVerifier.this.countEntries(colPayoff)) {
                    throw new InvalidParameterException("Thw column payoff matrix does not have the proper amount of entries to match the labels");
                }
                return true;
            }
        };
        this.addParam(colLabels);
        Param rowPayoff = new Param("rowPayoffMatrix"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                String colPayoff = (String)allValues.get("colPayoffMatrix");
                int numRow = PldkVerifier.this.countEntries(value);
                int numCol = PldkVerifier.this.countEntries(colPayoff);
                String rowLabels = (String)allValues.get("rowLabels");
                String colLabels = (String)allValues.get("columnLabels");
                int total = PldkVerifier.this.countEntries(rowLabels) * PldkVerifier.this.countEntries(colLabels);
                if (total != numCol) {
                    throw new InvalidParameterException("The number of labels do not match correctly with the number of payoff entries");
                }
                if (numRow != numCol) {
                    throw new InvalidParameterException("The number of row entries in the payoff matrix must be EQUAL to the number of column entries in the payoff matrix");
                }
                return true;
            }
        };
        this.addParam(rowPayoff);
        Param colPayoff = new Param("colPayoffMatrix"){

            public boolean verify(String value, Hashtable allValues) throws InvalidParameterException {
                String rowPayoff = (String)allValues.get("rowPayoffMatrix");
                String rowLabels = (String)allValues.get("rowLabels");
                String colLabels = (String)allValues.get("columnLabels");
                int total = PldkVerifier.this.countEntries(rowLabels) * PldkVerifier.this.countEntries(colLabels);
                int numCol = PldkVerifier.this.countEntries(value);
                int numRow = PldkVerifier.this.countEntries(rowPayoff);
                if (total != numCol) {
                    throw new InvalidParameterException("The number of labels do not match correctly with the number of payoff entries");
                }
                if (numRow != numCol) {
                    throw new InvalidParameterException("The number of row entries in the payoff matrix must be EQUAL to the number of column entries in the payoff matrix");
                }
                return true;
            }
        };
        this.addParam(colPayoff);
    }

    private int countEntries(String str) {
        StringTokenizer s = new StringTokenizer(str, ",");
        return s.countTokens();
    }

    private boolean isMultiple(int a, int b) {
        return a % b == 0;
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        if (groupSize != 2) {
            throw new InvalidParameterException("PLDK group size MUST be 2");
        }
        return true;
    }

    private String[] toArray(String labels) {
        StringTokenizer token = new StringTokenizer(labels, ",");
        int numTokens = token.countTokens();
        String[] strings = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            strings[i] = token.nextToken();
        }
        return strings;
    }
}

