/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml.recoverOutput;

import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.TableFormatter;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.recoverOutput.WC_ClientData;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.recoverOutput.WC_Question;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.recoverOutput.WC_Survey;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WebCampaignOutputSaver {
    public static final String L = System.getProperty("line.separator");
    public static final String ST = "state.";
    public static final String QS = ".query.";
    public static final String RS = ".response";
    public static final String NC = ".numClicks";
    public static final String TM = ".time";
    public static final int numStates = 5;
    public static final int numQS = 4;
    public static final int numSUR = 4;
    public static final String SQ = "question.";
    public static final String ANS = ".answer";
    public static final String DISCLAIMER = "Multistage Output Data Provided by the Multistage OutputService.  1997-2003, CASSEL/SSEL, Caltech and UCLA.";
    public static List headers = new ArrayList();
    public static List sheaders;
    private Document xmlDoc = null;
    private Element experiment = null;
    private SAXBuilder builder = null;
    private List clients = null;

    public WebCampaignOutputSaver(String xmlFileName) throws IOException, JDOMException {
        if (xmlFileName == null) {
            throw new IOException("Input XML file is null!");
        }
        this.builder = new SAXBuilder();
        this.xmlDoc = this.builder.build(new File(xmlFileName));
        this.experiment = this.xmlDoc.getRootElement();
        this.clients = new ArrayList();
    }

    public void getClientData() {
        WC_ClientData client;
        Element match = this.experiment.getChild("match");
        List groups = match.getChildren("group");
        for (int i = 0; i < groups.size(); ++i) {
            Element group = (Element)groups.get(i);
            int gid = Integer.parseInt(group.getAttributeValue("id"));
            List cs = group.getChildren("client");
            for (int j = 0; j < cs.size(); ++j) {
                client = new WC_ClientData();
                Element c = (Element)cs.get(j);
                client.setId(Integer.parseInt(c.getAttributeValue("id")));
                client.setGid(gid);
                this.clients.add(client);
            }
        }
        Element round = match.getChild("round");
        List cs = round.getChildren("client");
        for (int j = 0; j < cs.size(); ++j) {
            Element c = (Element)cs.get(j);
            int cid = Integer.parseInt(c.getAttributeValue("id"));
            client = this.findClientData(cid);
            for (int k = 0; k < 5; ++k) {
                String sname = "";
                if (c.getChild(ST + k) != null) {
                    sname = c.getChildText(ST + k);
                }
                for (int l = 0; l < 4; ++l) {
                    WC_Question qs = new WC_Question();
                    qs.setId(l);
                    qs.setState(sname);
                    if (c.getChild(ST + k + QS + l + RS) != null) {
                        qs.setResponse(c.getChildText(ST + k + QS + l + RS));
                    }
                    if (c.getChild(ST + k + QS + l + NC) != null) {
                        qs.setNumOfClicks(Integer.parseInt(c.getChildTextTrim(ST + k + QS + l + NC)));
                    }
                    if (c.getChild(ST + k + QS + l + TM) != null) {
                        qs.setTime(Integer.parseInt(c.getChildTextTrim(ST + k + QS + l + TM)));
                    }
                    client.addQuestion(qs);
                }
                for (int m = 0; m < 4; ++m) {
                    WC_Survey sv = new WC_Survey();
                    sv.setState(sname);
                    if (c.getChild(SQ + m + ANS) != null) {
                        sv.setInput(c.getChildText(SQ + m + ANS));
                    }
                    client.addSurvey(sv);
                }
            }
        }
    }

    private WC_ClientData findClientData(int cid) {
        for (int i = 0; i < this.clients.size(); ++i) {
            WC_ClientData client = (WC_ClientData)this.clients.get(i);
            if (client.getId() != cid) continue;
            return client;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Number of clients found: " + this.clients.size());
        buffer.append(L);
        for (int i = 0; i < this.clients.size(); ++i) {
            WC_ClientData client = (WC_ClientData)this.clients.get(i);
            buffer.append(client.toString());
        }
        return buffer.toString();
    }

    public void writeHTML(String outputFileName) throws IOException, BadExperimentDataException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));
        writer.write(this.formatToHTML());
        writer.flush();
        writer.close();
    }

    private String formatToHTML() throws BadExperimentDataException {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        sb.append(L).append("<html lang=\"en\">");
        sb.append(L).append("<head>");
        sb.append(L).append("<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\">");
        sb.append(L).append("<title>WebCampaign Data Summary Page</title>");
        sb.append(L).append("</head>");
        sb.append(L).append("<body>").append(L);
        TableFormatter tf = new TableFormatter("WebCampaign State Questionnaire Data Table", null, headers);
        for (int i = 0; i < this.clients.size(); ++i) {
            WC_ClientData client = (WC_ClientData)this.clients.get(i);
            List qs = client.getQuestions();
            for (int j = 0; j < qs.size(); ++j) {
                WC_Question q = (WC_Question)qs.get(j);
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add(String.valueOf(client.getId()));
                rowData.add(String.valueOf(client.getGid()));
                rowData.add(q.getState());
                rowData.add(String.valueOf(q.getId()));
                rowData.add(String.valueOf(q.getNumOfClicks()));
                rowData.add(String.valueOf(q.getTime()));
                rowData.add(q.getResponse());
                tf.addRow(rowData);
            }
        }
        sb.append(tf.tableToHTML());
        sb.append("<br>");
        TableFormatter tf_sv = new TableFormatter("WebCampaign State Survey Data Table", null, sheaders);
        for (int i = 0; i < this.clients.size(); ++i) {
            WC_ClientData client = (WC_ClientData)this.clients.get(i);
            List svs = client.getSurveys();
            for (int j = 0; j < svs.size(); ++j) {
                WC_Survey s = (WC_Survey)svs.get(j);
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add(String.valueOf(client.getId()));
                rowData.add(String.valueOf(client.getGid()));
                rowData.add(s.getState());
                rowData.add(String.valueOf(j));
                rowData.add(s.getInput());
                tf_sv.addRow(rowData);
            }
        }
        sb.append(tf_sv.tableToHTML());
        sb.append(L).append("<h4>").append(DISCLAIMER).append("</h4></body>").append(L);
        sb.append("</html>");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            WebCampaignOutputSaver wc = new WebCampaignOutputSaver("F:\\proj\\multistage\\dist\\output\\webcampaign\\03-05-13-00.output.xml");
            wc.getClientData();
            System.out.print(wc.toString());
            wc.writeHTML("F:\\proj\\multistage\\dist\\output\\webcampaign\\output3.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        headers.add("subject");
        headers.add("groupId");
        headers.add("state");
        headers.add("question");
        headers.add("numClicks");
        headers.add("time");
        headers.add("response");
        sheaders = new ArrayList();
        sheaders.add("subject");
        sheaders.add("groupId");
        sheaders.add("state");
        sheaders.add("surveyId");
        sheaders.add("input");
    }
}

