/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.BadOutputFormatException;
import edu.caltech.ssel.multistage.server.util.outputservice.OutputBuilder;
import edu.caltech.ssel.multistage.server.util.outputservice.OutputBuilderCommons;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.CSVOutputWriter;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.HTMLOutputWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLOutputBuilder
implements OutputBuilder,
OutputBuilderCommons {
    private static final String CLIENT = "client.";
    private static final String TOTALPAYOFF = ".totalPayoff";
    private static final String NAME = ".name";
    private static final String RS = ".repetitions";
    private static final String STATUS = ".status";
    private static final String MS = "match.";
    private static final String TS = ".type";
    private Properties props = new Properties();
    private int numOfMatches;
    private int numOfSubjects;
    private Document xmlDoc = null;
    private Element experiment = null;
    private XMLOutputter outputter = null;
    private boolean xmlReady = false;
    private Element refMatch = null;

    public XMLOutputBuilder(String propFileName) throws IOException {
        this(new File(propFileName));
    }

    public XMLOutputBuilder(File propFile) throws IOException {
        this.props.load(new FileInputStream(propFile));
        this.initialize();
    }

    protected void initialize() {
        this.experiment = new Element("experiment");
        this.xmlDoc = new Document(this.experiment);
        this.outputter = new XMLOutputter(Format.getPrettyFormat());
    }

    public void buildExperimentElement() throws BadExperimentDataException {
        if (this.xmlReady) {
            return;
        }
        String p = this.props.getProperty("exptime");
        if (p == null) {
            throw new BadExperimentDataException("Can't find experiment time in the output file!");
        }
        this.experiment.setAttribute(new Attribute("exptime", p));
        p = this.props.getProperty("exp.id");
        if (p == null) {
            throw new BadExperimentDataException("Can't find experiment ID in the output file!");
        }
        this.experiment.setAttribute(new Attribute("exp.id", p));
        p = this.props.getProperty("numOfMatches");
        if (p == null) {
            throw new BadExperimentDataException("Can't find number of matches in the output file!");
        }
        try {
            this.numOfMatches = Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            throw new BadExperimentDataException("Bad number of matches value in the output file!");
        }
        this.experiment.setAttribute(new Attribute("numOfMatches", p));
        p = this.props.getProperty("numOfSubjects");
        if (p == null) {
            throw new BadExperimentDataException("Can't find number of subjects in the output file!");
        }
        try {
            this.numOfSubjects = Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            throw new BadExperimentDataException("Bad number of subjects value in the output file!");
        }
        this.experiment.setAttribute(new Attribute("numOfSubjects", p));
        this.buildMatchElements();
        this.xmlReady = true;
    }

    public void buildMatchElements() throws BadExperimentDataException {
        Element match = null;
        for (int i = 0; i < this.numOfMatches; ++i) {
            match = new Element("match");
            match.setAttribute(new Attribute("id", Integer.toString(i)));
            this.experiment.addContent((Content)match);
            String statusStr = this.props.getProperty(MS + i + STATUS);
            if (statusStr == null) {
                throw new BadExperimentDataException("Match status unknown for match: " + i + ". " + LINESEP + "This is likely an output file from older version Multistage, you can correct the format by adding the match.i.status property for each match.");
            }
            match.setAttribute(new Attribute("status", statusStr));
            if (statusStr.equalsIgnoreCase("ABORT")) continue;
            String practiceStr = this.props.getProperty(MS + i + ".practice");
            if (practiceStr != null) {
                match.setAttribute(new Attribute("practice", practiceStr));
            }
            this.buildMatchElement(match);
        }
    }

    public void buildMatchElement(Element match) throws BadExperimentDataException {
        this.buildGroupElements(match);
        this.buildRoundElements(match);
    }

    public void buildGroupElements(Element match) throws BadExperimentDataException {
        String grpStr = null;
        String grpAssignment = null;
        String matchId = match.getAttributeValue("id");
        int i = 0;
        while ((grpAssignment = this.props.getProperty(grpStr = MS + matchId + ".group." + i + ".clients")) != null) {
            StringTokenizer st = new StringTokenizer(grpAssignment, ",");
            Element grp = new Element("group");
            grp.setAttribute(new Attribute("id", Integer.toString(i)));
            while (st.hasMoreTokens()) {
                Element client = new Element("client");
                String id = st.nextToken();
                client.setAttribute(new Attribute("id", id));
                grp.addContent((Content)client);
                String matchData = MS + matchId + ".client." + id + ".";
                Enumeration<Object> keys = this.props.keys();
                while (keys.hasMoreElements()) {
                    String data;
                    String key = (String)keys.nextElement();
                    if (!key.startsWith(matchData) || (data = key.substring(matchData.length(), key.length())).indexOf(".") >= 0) continue;
                    client.addContent((Content)new Element(data).addContent(this.props.getProperty(key)));
                }
            }
            match.addContent((Content)grp);
            ++i;
        }
    }

    public void buildRoundElements(Element match) throws BadExperimentDataException {
        String matchId = match.getAttributeValue("id");
        String roundStatusStr = null;
        Element round = null;
        List groups = match.getChildren("group");
        List clients = null;
        ArrayList<String> params = null;
        int j = 0;
        while ((roundStatusStr = this.props.getProperty(MS + match.getAttributeValue("id") + ".round." + j + STATUS)) != null) {
            round = new Element("round");
            round.setAttribute(new Attribute("status", roundStatusStr));
            round.setAttribute(new Attribute("id", Integer.toString(j)));
            match.addContent((Content)round);
            if (!roundStatusStr.equalsIgnoreCase("UNPLAYED")) {
                int numOfGroups = groups.size();
                for (int i = 0; i < numOfGroups; ++i) {
                    Element grp = (Element)groups.get(i);
                    Element newGrp = new Element("group");
                    newGrp.setAttribute(new Attribute("id", grp.getAttributeValue("id")));
                    round.addContent((Content)newGrp);
                    clients = grp.getChildren("client");
                    int grpSize = clients.size();
                    for (int z = 0; z < grpSize; ++z) {
                        Element client = (Element)clients.get(z);
                        Element newClient = new Element("client");
                        newClient.setAttribute(new Attribute("id", client.getAttributeValue("id")));
                        newGrp.addContent((Content)newClient);
                        String prefix = MS + matchId + ".client." + client.getAttributeValue("id") + ".round." + j;
                        params = new ArrayList<String>();
                        Enumeration<?> keys = this.props.propertyNames();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            if (key.indexOf(prefix) < 0) continue;
                            int last = prefix.length();
                            params.add(key.substring(last + 1, key.length()));
                        }
                        int numOfParams = params.size();
                        for (int k = 0; k < numOfParams; ++k) {
                            String shortName = (String)params.get(k);
                            System.out.println("shortName==" + shortName);
                            String param = "";
                            param = shortName.startsWith(".") ? prefix + shortName : prefix + "." + shortName;
                            if (shortName.startsWith(".")) {
                                newClient.addContent((Content)new Element(shortName.substring(1)).addContent(this.props.getProperty(param)));
                                continue;
                            }
                            newClient.addContent((Content)new Element(shortName).addContent(this.props.getProperty(param)));
                        }
                    }
                }
            }
            ++j;
        }
    }

    public void buildPayoffsElement() {
        StringBuffer payoffsb = new StringBuffer();
        StringBuffer namesb = new StringBuffer();
        Element payoffs = new Element("payoffs");
        this.experiment.addContent((Content)payoffs);
        for (int i = 0; i < this.numOfSubjects; ++i) {
            payoffsb.append(CLIENT).append(i).append(TOTALPAYOFF);
            namesb.append(CLIENT).append(i).append(NAME);
            String pfs = this.props.getProperty(payoffsb.toString());
            String ns = this.props.getProperty(namesb.toString());
            Element name = new Element("name");
            Element payoff = new Element("payoff");
            if (pfs != null) {
                payoff.addContent(pfs);
            }
            if (ns != null) {
                name.addContent(ns);
            }
            Element client = new Element("client");
            client.setAttribute(new Attribute("id", Integer.toString(i)));
            client.addContent((Content)name);
            client.addContent((Content)payoff);
            payoffs.addContent((Content)client);
            payoffsb.delete(0, payoffsb.length());
            namesb.delete(0, namesb.length());
        }
    }

    public Document cloneExperimentDocument() {
        return (Document)this.xmlDoc.clone();
    }

    public Element cloneExperimentElement() {
        return (Element)this.experiment.clone();
    }

    public Element getExperimentElement() {
        return this.experiment;
    }

    public void outputFormatter(OutputStream out) throws IOException, BadOutputFormatException {
        if (out == null) {
            throw new IOException("The destined OutputStream is null for writing output.");
        }
        this.buildExperimentElement();
        this.outputter.output(this.xmlDoc, out);
    }

    public String outputFormatter() throws BadOutputFormatException {
        this.buildExperimentElement();
        return this.outputter.outputString(this.xmlDoc);
    }

    public static String getHelpMsg() {
        StringBuffer sb = new StringBuffer("Usage: java XMLOutputBuilder (inputFileName [outputFileName] | [-help])");
        sb.append(LINESEP).append("When outFileName is omitted, a default name, xml-inputFileName will be used.");
        return sb.toString();
    }

    public static void main(String[] args) {
        int size = args.length;
        if (size == 0 || size > 2) {
            System.out.print(XMLOutputBuilder.getHelpMsg());
            System.exit(0);
        }
        if (size == 1 && args[0].equals("-help")) {
            System.out.print(XMLOutputBuilder.getHelpMsg());
            System.exit(0);
        }
        String inFile = args[0];
        String outFile = null;
        if (size == 1) {
            outFile = "xml" + inFile;
        }
        if (size == 2) {
            outFile = args[1];
        }
        try {
            XMLOutputBuilder xmlb = new XMLOutputBuilder(inFile);
            BufferedOutputStream bs = new BufferedOutputStream(new FileOutputStream(outFile + ".xml"));
            xmlb.outputFormatter(bs);
            bs.flush();
            bs.close();
            Element exp = xmlb.getExperimentElement();
            CSVOutputWriter csvWriter = new CSVOutputWriter(outFile + ".csv", exp);
            csvWriter.writeOutputToCSV();
            HTMLOutputWriter htmlWriter = new HTMLOutputWriter(outFile + ".html", exp);
            htmlWriter.writeOutputToHTML();
            System.out.println("Output service has successfully transformed output file: " + inFile + " to xml file: " + outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

