/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import java.util.ArrayList;
import java.util.List;

public class TableFormatter {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String NAME = "Table Name: ";
    public static final String DESC = "Table Description: ";
    private List headers = null;
    private ArrayList rows = null;
    private int cellWidth = 15;
    private String tableName = null;
    private String tableDesc = null;

    public TableFormatter(String name, String desc, List headers) {
        if (name != null) {
            this.tableName = name;
        }
        if (desc != null) {
            this.tableDesc = desc;
        }
        if (headers == null || headers.size() <= 0) {
            headers = new ArrayList();
        }
        this.headers = headers;
        this.rows = new ArrayList();
    }

    public void addRow(List rowData) throws BadExperimentDataException {
        if (rowData == null) {
            throw new BadExperimentDataException("Row data is null.");
        }
        if (this.headers.size() != rowData.size()) {
            throw new BadExperimentDataException("Table with " + this.headers.size() + " but tried add data with " + rowData.size() + " columns");
        }
        this.rows.add(rowData);
    }

    public void addRows(List mRowData) throws BadExperimentDataException {
        if (mRowData != null) {
            for (int i = 0; i < mRowData.size(); ++i) {
                this.addRow((List)mRowData.get(i));
            }
        } else {
            throw new BadExperimentDataException("Multi-row data is null.");
        }
    }

    public String tableToHTML() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("<h3>" + this.toString() + "</h3><hr align=\"left\" width=\"50%\"><br>");
        sb.append("<table border=\"1\">").append(NEWLINE);
        int size = this.headers.size();
        int width = 100 / size;
        sb.append("<tr>").append(NEWLINE);
        for (i = 0; i < size; ++i) {
            sb.append("<th width=\"" + width + "%\">" + (String)this.headers.get(i) + "</th>").append(NEWLINE);
        }
        sb.append("</tr>").append(NEWLINE);
        for (i = 0; i < this.rows.size(); ++i) {
            List data = (List)this.rows.get(i);
            sb.append("<tr>").append(NEWLINE);
            for (int j = 0; j < size; ++j) {
                sb.append("<td width=\"" + width + "%\">" + (String)data.get(j) + "</td>");
                sb.append(NEWLINE);
            }
            sb.append("</tr>").append(NEWLINE);
        }
        sb.append("</table>");
        return sb.toString();
    }

    public String tableToCSV() {
        StringBuffer sb = new StringBuffer();
        sb.append(";; ").append(NAME).append(this.tableName).append(NEWLINE);
        sb.append(this.listToString(this.headers, ',', ',')).append(NEWLINE);
        for (int i = 0; i < this.rows.size(); ++i) {
            sb.append(this.listToString((List)this.rows.get(i), ',', ','));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    public String tableToASCII() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMetaLineSep());
        sb.append(NEWLINE);
        sb.append(this.toString());
        sb.append(NEWLINE);
        sb.append(this.getMetaLineSep());
        sb.append(NEWLINE).append(NEWLINE);
        String h = this.getHeaderString();
        String line = TableFormatter.getLineSep(h.length());
        assert (h.length() == line.length());
        sb.append(h).append(NEWLINE).append(line).append(NEWLINE);
        for (int i = 0; i < this.rows.size(); ++i) {
            sb.append(this.listToString((List)this.rows.get(i), ' '));
            sb.append(NEWLINE);
        }
        sb.append(line).append(NEWLINE);
        return sb.toString();
    }

    public String getHeaderString() {
        return this.listToString(this.headers, ' ');
    }

    public String listToString(List strings, char delim) {
        StringBuffer h = new StringBuffer();
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            str = str.replaceAll("\n", " | ");
            if (delim == ' ') {
                h.append(this.paddedCell(str));
                continue;
            }
            h.append(str).append(delim);
        }
        return h.toString();
    }

    public String listToString(List strings, char delim, char elim) {
        StringBuffer h = new StringBuffer();
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            str = str.replaceAll("\n", " | ");
            if (delim == ' ') {
                h.append(this.paddedCell((String)strings.get(i)));
                continue;
            }
            h.append(str.replace(elim, ' ')).append(delim);
        }
        return h.toString();
    }

    private String paddedCell(String value) {
        if (value.length() >= this.cellWidth) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value);
        for (int len = this.cellWidth - value.length(); len > 0; --len) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setCellWidth(int w) {
        this.cellWidth = w;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public String getMetaLineSep() {
        String str = NAME + this.tableName;
        if (this.tableDesc != null) {
            str = DESC + this.tableDesc;
        }
        return TableFormatter.getLineSep(str.length(), '#');
    }

    protected List getRows() {
        return (List)this.rows.clone();
    }

    public static String getLineSep(int length) {
        return TableFormatter.getLineSep(length, '-');
    }

    public static String getLineSep(int length, char symbol) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length + 4; ++i) {
            sb.append(symbol);
        }
        return sb.toString();
    }

    public static TableFormatter append(TableFormatter orig, TableFormatter append) throws BadExperimentDataException {
        if (orig == null) {
            return append;
        }
        if (append != null) {
            orig.addRows(append.getRows());
        }
        return orig;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(NAME + this.tableName);
        sb.append(NEWLINE);
        if (this.tableDesc != null) {
            sb.append(DESC + this.tableDesc);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ArrayList<String> h = new ArrayList<String>();
        h.add("match");
        h.add("round");
        h.add("choice");
        h.add("payoff");
        try {
            TableFormatter tf = new TableFormatter("Round Data", "test", h);
            ArrayList rs = new ArrayList();
            int choice = 0;
            double payoff = 5.12;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 10; ++j) {
                    ArrayList<String> r = new ArrayList<String>();
                    r.add(Integer.toString(i));
                    r.add(Integer.toString(j));
                    r.add(Integer.toString(choice));
                    r.add(Double.toString(payoff));
                    rs.add(r);
                }
            }
            tf.addRows(rs);
            System.out.print(tf.tableToASCII());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

