/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.OutputBuilderCommons;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.TableFormatter;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.XMLOutputBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class TableBuilder
implements OutputBuilderCommons {
    protected XMLOutputBuilder xmlBuilder = null;
    private Element exp;
    private String expId;
    private TableFormatter expTable;
    private TableFormatter matchTable;
    private TableFormatter gameTable;
    private TableFormatter roundTable;
    private TableFormatter totalPayoffTable;

    public TableBuilder(String propFileName) throws IOException, BadExperimentDataException {
        this.xmlBuilder = new XMLOutputBuilder(propFileName);
        this.init();
    }

    public TableBuilder(File propFile) throws IOException, BadExperimentDataException {
        this.xmlBuilder = new XMLOutputBuilder(propFile);
        this.init();
    }

    private void init() throws BadExperimentDataException {
        this.xmlBuilder.buildExperimentElement();
        this.exp = this.xmlBuilder.getExperimentElement();
        this.expId = this.exp.getAttributeValue("exp.id");
        this.expTable = this.constructExperimentTable();
        this.matchTable = this.constructMatchTable();
        this.gameTable = this.constructGameTable();
        this.roundTable = this.constructRoundTable();
    }

    public TableFormatter getExperimentTable() {
        return this.expTable;
    }

    private TableFormatter constructExperimentTable() throws BadExperimentDataException {
        ArrayList<String> row = new ArrayList<String>();
        TableFormatter tf = new TableFormatter("Experiment Description", null, Arrays.asList(EXPHEADERS));
        row.add(this.expId);
        row.add(this.exp.getAttributeValue("exptime"));
        row.add(this.exp.getAttributeValue("numOfMatches"));
        row.add(this.exp.getAttributeValue("numOfSubjects"));
        tf.addRow(row);
        return tf;
    }

    public TableFormatter getMatchTable() {
        return this.matchTable;
    }

    private TableFormatter constructMatchTable() throws BadExperimentDataException {
        return this.constructTable(0, this.expId, null, this.exp);
    }

    public TableFormatter getGameTable() {
        return this.gameTable;
    }

    private TableFormatter constructGameTable() throws BadExperimentDataException {
        List matches = this.exp.getChildren("match");
        Iterator it = matches.iterator();
        TableFormatter tf = null;
        while (it.hasNext()) {
            Element match = (Element)it.next();
            tf = TableFormatter.append(tf, this.constructTable(1, this.expId, null, match));
        }
        return tf;
    }

    public TableFormatter getRoundTable() {
        return this.roundTable;
    }

    private TableFormatter constructRoundTable() throws BadExperimentDataException {
        List matches = this.exp.getChildren("match");
        Iterator it = matches.iterator();
        TableFormatter tf = null;
        while (it.hasNext()) {
            Element match = (Element)it.next();
            List rounds = match.getChildren("round");
            for (Element rnd : rounds) {
                tf = TableFormatter.append(tf, this.constructTable(2, this.expId, match, rnd));
            }
        }
        return tf;
    }

    public TableFormatter getTotalPayoffTable() {
        return this.totalPayoffTable;
    }

    private TableFormatter constructTotalPayoffTable() throws BadExperimentDataException {
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<ArrayList<String>> rows = new ArrayList<ArrayList<String>>();
        TableFormatter tf = new TableFormatter("Client Payoff Summary", null, Arrays.asList(CLIENTHEADERS));
        Element payoffs = this.exp.getChild("payoffs");
        List clients = payoffs.getChildren("client");
        for (Element c : clients) {
            row.add(this.expId);
            row.add(c.getAttributeValue("id"));
            row.add(c.getChildTextTrim("name"));
            row.add(c.getChildTextTrim("payoff"));
            rows.add(row);
            row = new ArrayList();
        }
        tf.addRows(rows);
        return tf;
    }

    private TableFormatter constructTable(int type, String expId, Element match, Element parent) throws BadExperimentDataException {
        ArrayList<Object> row = new ArrayList();
        ArrayList<ArrayList<Object>> rows = new ArrayList<ArrayList<Object>>();
        List subEles = null;
        String[] dHeaders = null;
        int dLen = -1;
        String tableName = null;
        String sn = null;
        switch (type) {
            case 0: {
                tableName = "Match Description";
                sn = "matchSpecifics";
                row = new ArrayList<String>(Arrays.asList(MATCHHEADERS));
                subEles = parent.getChildren("match");
                dHeaders = MATCHHEADERS;
                dLen = MATCHHEADERS.length;
                break;
            }
            case 1: {
                tableName = "Game Description";
                sn = "gameSpecifics";
                row = new ArrayList<String>(Arrays.asList(GAMEHEADERS));
                subEles = parent.getChildren("game");
                dHeaders = GAMEHEADERS;
                dLen = GAMEHEADERS.length;
                break;
            }
            case 2: {
                tableName = "Round Description";
                sn = "roundSpecifics";
                row = new ArrayList<String>(Arrays.asList(ROUNDHEADERS));
                subEles = parent.getChildren("client");
                dHeaders = ROUNDHEADERS;
                dLen = ROUNDHEADERS.length;
                break;
            }
        }
        for (Element e : subEles) {
            Element es = e.getChild(sn);
            if (es == null || es.getChildren().size() == 0) continue;
            List props = es.getChildren();
            for (Element prop : props) {
                String esn = prop.getAttributeValue("name");
                if (row.contains(esn)) continue;
                row.add(esn);
            }
        }
        TableFormatter tf = new TableFormatter(tableName, null, row);
        ArrayList<Object> headers = row;
        row = new ArrayList();
        for (Element m : subEles) {
            int i;
            row.add(expId);
            int offset = 2;
            if (type == 1) {
                row.add(parent.getAttributeValue("id"));
                offset = 3;
            }
            if (type == 2) {
                row.add(match.getAttributeValue("id"));
                row.add(parent.getAttributeValue("id"));
                row.add(m.getAttributeValue("gid"));
                offset = 5;
            }
            row.add(m.getAttributeValue("id"));
            for (i = offset; i < dLen; ++i) {
                if (type == 2 && dHeaders[i].equals("gameId")) {
                    row.add(m.getChild("game").getAttributeValue("id"));
                    continue;
                }
                row.add(this.getChildValue(dHeaders[i], m));
            }
            for (i = dLen; i < headers.size(); ++i) {
                row.add(" ");
            }
            Element ms = m.getChild(sn);
            if (ms != null && ms.getChildren().size() != 0) {
                List props = ms.getChildren();
                for (Element prop : props) {
                    int index = headers.indexOf(prop.getAttributeValue("name"));
                    if (index <= 0) continue;
                    row.set(index, prop.getAttributeValue("value"));
                }
            }
            rows.add(row);
            row = new ArrayList();
        }
        tf.addRows(rows);
        return tf;
    }

    private String getChildValue(String childElementName, Element parent) {
        String value = parent.getChildTextTrim(childElementName);
        return value == null ? " " : value;
    }
}

