/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.TableFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class OutputTableBuilder {
    private static final String[] payoffHeaders = new String[]{"clientId", "totalPayOff"};
    private List roundTableHeaders;
    private List clientRoundHeaders;
    private List clientMatchHeaders;
    private List groupMatchHeaders;
    private List groupRoundHeaders;
    private List generalMatcherHeaders;
    private List clientMatcherHeaders;
    private boolean roundTableHeaderSet = false;
    private Element exp;
    String exp_time;

    public OutputTableBuilder(Element exp) throws BadExperimentDataException {
        if (exp == null) {
            throw new BadExperimentDataException("Null experiment root element, failed to initialize OutputTableBuilder.");
        }
        this.exp = exp;
        this.exp_time = exp.getAttributeValue("exptime");
        this.populateHeaders();
    }

    private void populateHeaders() {
        ArrayList<String> fixedHeaders = new ArrayList<String>();
        fixedHeaders.add("matchId");
        this.generalMatcherHeaders = this.constructHeaders(fixedHeaders, "match", "matcher", "general", null);
        fixedHeaders = new ArrayList();
        fixedHeaders.add("matchId");
        fixedHeaders.add("clientId");
        this.clientMatcherHeaders = this.constructHeaders(fixedHeaders, "match", "matcher", "client", null);
        fixedHeaders = new ArrayList();
        fixedHeaders.add("matchId");
        fixedHeaders.add("groupId");
        this.groupMatchHeaders = this.constructHeaders(fixedHeaders, "match", "group", "general", null);
        fixedHeaders = new ArrayList();
        fixedHeaders.add("matchId");
        fixedHeaders.add("groupId");
        fixedHeaders.add("clientId");
        this.clientMatchHeaders = this.constructHeaders(fixedHeaders, "match", "group", "client", null);
        fixedHeaders = new ArrayList();
        fixedHeaders.add("matchId");
        fixedHeaders.add("roundId");
        fixedHeaders.add("groupId");
        this.groupRoundHeaders = this.constructHeaders(fixedHeaders, "match", "round", "group", "general");
        fixedHeaders = new ArrayList();
        fixedHeaders.add("matchId");
        fixedHeaders.add("roundId");
        fixedHeaders.add("groupId");
        fixedHeaders.add("clientId");
        this.clientRoundHeaders = this.constructHeaders(fixedHeaders, "match", "round", "group", "client");
    }

    public TableFormatter getGeneralMatcherTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            Element general;
            Element matcher;
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true") || (matcher = match.getChild("matcher")) == null || (general = matcher.getChild("general")) == null) continue;
            tf = TableFormatter.append(tf, this.constructGeneralMatcherTable(match, general));
        }
        return tf;
    }

    public TableFormatter getClientMatcherTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            Element matcher;
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true") || (matcher = match.getChild("matcher")) == null) continue;
            List children = matcher.getChildren("client");
            for (Element client : children) {
                tf = TableFormatter.append(tf, this.constructClientMatcherTable(match, client));
            }
        }
        return tf;
    }

    public TableFormatter getGroupMatchTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true")) continue;
            List groups = match.getChildren("group");
            for (Element group : groups) {
                Element general = group.getChild("general");
                if (general == null) continue;
                tf = TableFormatter.append(tf, this.constructGroupMatchTable(match, group, general));
            }
        }
        return tf;
    }

    public TableFormatter getClientMatchTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true")) continue;
            List groups = match.getChildren("group");
            for (Element group : groups) {
                List clients = group.getChildren("client");
                for (Element client : clients) {
                    List children = client.getChildren();
                    if (children == null || children.size() <= 0) continue;
                    tf = TableFormatter.append(tf, this.constructClientMatchTable(match, group, client));
                }
            }
        }
        return tf;
    }

    public TableFormatter getGroupRoundTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true")) continue;
            List rounds = match.getChildren("round");
            for (Element round : rounds) {
                List groups = round.getChildren("group");
                for (Element group : groups) {
                    Element general = group.getChild("general");
                    if (general == null) continue;
                    tf = TableFormatter.append(tf, this.constructGroupRoundTable(match, round, group, general));
                }
            }
        }
        return tf;
    }

    public TableFormatter getClientRoundTable() throws BadExperimentDataException {
        TableFormatter tf = null;
        List matches = this.exp.getChildren("match");
        for (Element match : matches) {
            if (match.getAttributeValue("status").equalsIgnoreCase("ABORTED") || match.getAttributeValue("practice").equalsIgnoreCase("true")) continue;
            List rounds = match.getChildren("round");
            for (Element round : rounds) {
                List groups = round.getChildren("group");
                for (Element group : groups) {
                    List clients = group.getChildren("client");
                    for (Element client : clients) {
                        tf = TableFormatter.append(tf, this.constructClientRoundTable(match, round, group, client));
                    }
                }
            }
        }
        return tf;
    }

    private TableFormatter constructClientRoundTable(Element match, Element round, Element group, Element client) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String gid = group.getAttributeValue("id");
        String rid = round.getAttributeValue("id");
        String cid = client.getAttributeValue("id");
        String tableName = "Client Round Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.clientRoundHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.clientRoundHeaders.size(); ++i) {
            String header = (String)this.clientRoundHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            if (header.equalsIgnoreCase("groupId")) {
                row.add(gid);
                continue;
            }
            if (header.equalsIgnoreCase("roundId")) {
                row.add(rid);
                continue;
            }
            if (header.equalsIgnoreCase("clientId")) {
                row.add(cid);
                continue;
            }
            Element prop = client.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private TableFormatter constructGroupRoundTable(Element match, Element round, Element group, Element general) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String gid = group.getAttributeValue("id");
        String rid = round.getAttributeValue("id");
        String tableName = "Group Round Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.groupRoundHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.groupRoundHeaders.size(); ++i) {
            String header = (String)this.groupRoundHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            if (header.equalsIgnoreCase("groupId")) {
                row.add(gid);
                continue;
            }
            if (header.equalsIgnoreCase("roundId")) {
                row.add(rid);
                continue;
            }
            Element prop = general.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private TableFormatter constructClientMatchTable(Element match, Element group, Element client) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String gid = group.getAttributeValue("id");
        String cid = client.getAttributeValue("id");
        String tableName = "Client Match Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.clientMatchHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.clientMatchHeaders.size(); ++i) {
            String header = (String)this.clientMatchHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            if (header.equalsIgnoreCase("groupId")) {
                row.add(gid);
                continue;
            }
            if (header.equalsIgnoreCase("clientId")) {
                row.add(cid);
                continue;
            }
            Element prop = client.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private TableFormatter constructGroupMatchTable(Element match, Element group, Element general) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String gid = group.getAttributeValue("id");
        String tableName = "Group Match Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.groupMatchHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.groupMatchHeaders.size(); ++i) {
            String header = (String)this.groupMatchHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            if (header.equalsIgnoreCase("groupId")) {
                row.add(gid);
                continue;
            }
            Element prop = general.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private TableFormatter constructClientMatcherTable(Element match, Element client) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String cid = client.getAttributeValue("id");
        String tableName = "Manual Matcher Client Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.clientMatcherHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.clientMatcherHeaders.size(); ++i) {
            String header = (String)this.clientMatcherHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            if (header.equalsIgnoreCase("clientId")) {
                row.add(cid);
                continue;
            }
            Element prop = client.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private TableFormatter constructGeneralMatcherTable(Element match, Element general) throws BadExperimentDataException {
        String mid = match.getAttributeValue("id");
        String tableName = "Manual Matcher General Data";
        TableFormatter tf = new TableFormatter(tableName, null, this.generalMatcherHeaders);
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.generalMatcherHeaders.size(); ++i) {
            String header = (String)this.generalMatcherHeaders.get(i);
            if (header.equalsIgnoreCase("matchId")) {
                row.add(mid);
                continue;
            }
            Element prop = general.getChild(header);
            String text = "N/A";
            if (prop != null) {
                text = prop.getText();
            }
            row.add(text);
        }
        tf.addRow(row);
        return tf;
    }

    private ArrayList getHeaders(Element elm) {
        ArrayList<String> headers = new ArrayList<String>();
        List properties = elm.getChildren();
        for (Element prop : properties) {
            headers.add(prop.getName());
        }
        return headers;
    }

    private List constructHeaders(ArrayList fixedHeaders, String parent1, String parent2, String parent3, String parent4) {
        ArrayList headers = new ArrayList();
        for (int i = 0; i < fixedHeaders.size(); ++i) {
            headers.add(fixedHeaders.get(i));
        }
        List first = this.exp.getChildren(parent1);
        for (Element firstElm : first) {
            List second = firstElm.getChildren(parent2);
            for (Element secondElm : second) {
                List third = secondElm.getChildren(parent3);
                Iterator tit = third.iterator();
                while (tit.hasNext()) {
                    if (parent4 != null) {
                        Element thirdElm = (Element)tit.next();
                        List fourth = thirdElm.getChildren(parent4);
                        for (Element child : fourth) {
                            ArrayList props = this.getHeaders(child);
                            for (int i = 0; i < props.size(); ++i) {
                                Object prop = props.get(i);
                                if (headers.contains(prop)) continue;
                                headers.add(prop);
                            }
                        }
                        continue;
                    }
                    while (tit.hasNext()) {
                        Element child = (Element)tit.next();
                        ArrayList props = this.getHeaders(child);
                        for (int i = 0; i < props.size(); ++i) {
                            Object prop = props.get(i);
                            if (headers.contains(prop)) continue;
                            headers.add(prop);
                        }
                    }
                }
            }
        }
        return headers;
    }

    public TableFormatter getTotalPayoffTable() throws BadExperimentDataException {
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<ArrayList<String>> rows = new ArrayList<ArrayList<String>>();
        TableFormatter tf = new TableFormatter("Client Payoff Summary", null, Arrays.asList(payoffHeaders));
        Element payoffs = this.exp.getChild("payoffs");
        List clients = payoffs.getChildren("client");
        for (Element c : clients) {
            row.add(c.getAttributeValue("id"));
            row.add(c.getChildTextTrim("payoff"));
            rows.add(row);
            row = new ArrayList();
        }
        tf.addRows(rows);
        return tf;
    }

    private String getChildValue(String childElementName, Element parent) {
        String value = parent.getChildTextTrim(childElementName);
        return value == null ? " " : value;
    }
}

