/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.BadOutputFormatException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.OutputTableBuilder;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.TableFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import org.apache.log4j.Category;
import org.jdom.Element;

public class HTMLOutputWriter {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String DISCLAIMER = "Multistage Output Data Provided by the Multistage OutputService.  1997-2003, CASSEL/SSEL, Caltech and UCLA.";
    private static Category log = Category.getInstance(HTMLOutputWriter.class);
    private Element exp = null;
    private File outputFile = null;
    private OutputTableBuilder tableBuilder = null;

    public HTMLOutputWriter(String outputFileName, Element exp) throws BadOutputFormatException {
        this(new File(outputFileName), exp);
    }

    public HTMLOutputWriter(File outputFile, Element exp) throws BadOutputFormatException {
        this.outputFile = outputFile;
        this.exp = exp;
        if (exp == null) {
            throw new BadOutputFormatException("Null root experiment element, faled to initiate HTML output writer.");
        }
        this.tableBuilder = new OutputTableBuilder(exp);
    }

    public void writeOutputToHTML() throws BadOutputFormatException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));
        writer.write(this.formatToHTML());
        writer.flush();
        writer.close();
    }

    private String formatToHTML() throws BadOutputFormatException, IOException {
        TableFormatter clientRoundTable;
        TableFormatter groupRoundTable;
        TableFormatter clientMatchTable;
        TableFormatter groupMatchTable;
        TableFormatter clientMatcherTable;
        StringBuffer sb = new StringBuffer(this.getHTMLHeader());
        sb.append(NEWLINE).append("<body>").append(NEWLINE);
        sb.append(this.getExperimentMetaInfo()).append(NEWLINE);
        TableFormatter generalMatcherTable = this.tableBuilder.getGeneralMatcherTable();
        if (generalMatcherTable != null) {
            sb.append(generalMatcherTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientMatcherTable = this.tableBuilder.getClientMatcherTable()) != null) {
            sb.append(clientMatcherTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        if ((groupMatchTable = this.tableBuilder.getGroupMatchTable()) != null) {
            sb.append(groupMatchTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientMatchTable = this.tableBuilder.getClientMatchTable()) != null) {
            sb.append(clientMatchTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        if ((groupRoundTable = this.tableBuilder.getGroupRoundTable()) != null) {
            sb.append(groupRoundTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientRoundTable = this.tableBuilder.getClientRoundTable()) != null) {
            sb.append(clientRoundTable.tableToHTML()).append(NEWLINE).append(NEWLINE);
        }
        sb.append("<hr>").append(this.getMatchParams()).append("<hr>").append(NEWLINE);
        sb.append(NEWLINE).append("<h4>").append(DISCLAIMER).append("</h4></body>").append(NEWLINE).append(this.getHTMLFooter());
        return sb.toString();
    }

    private String getHTMLHeader() {
        StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        sb.append(NEWLINE).append("<html lang=\"en\">");
        sb.append(NEWLINE).append("<head>");
        sb.append(NEWLINE).append("<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\">");
        sb.append(NEWLINE).append("<title>Multistage Data Summary Page</title>");
        sb.append(NEWLINE).append("</head>");
        return sb.toString();
    }

    private String getExperimentMetaInfo() {
        String email;
        StringBuffer meta = new StringBuffer();
        String name = this.exp.getAttributeValue("experimenterName");
        if (name != null) {
            meta.append("<h2>Experimenter Name: ").append(name).append("</h2><br>");
        }
        if ((email = this.exp.getAttributeValue("experimenterEmail")) != null) {
            meta.append("<h2>Experimenter Email: ").append(email).append("</h2><br>");
        }
        meta.append("<h2>Experiment Time: ").append(this.exp.getAttributeValue("exptime")).append("</h2><br>");
        meta.append("<h2>Number of Subjects Used: ").append(this.exp.getAttributeValue("numOfSubjects")).append("</h2><br>");
        meta.append("<h2>Number of Matches Run: ").append(this.exp.getAttributeValue("numOfMatches")).append("</h2><br>");
        meta.append("<hr><br>");
        return meta.toString();
    }

    private String getMatchParams() throws IOException {
        Element matchParams = this.exp.getChild("matchParams");
        if (matchParams == null) {
            return "No match parameters found!";
        }
        BufferedReader reader = new BufferedReader(new StringReader(matchParams.getText()));
        StringBuffer sb = new StringBuffer("<h3>Experiment Parameters</h3><br><p><div>");
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("<br>");
        }
        sb.append("</div></p>");
        return sb.toString();
    }

    private String getHTMLFooter() {
        return "</html>";
    }

    public static void main(String[] args) {
    }
}

