/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.xml;

import edu.caltech.ssel.multistage.server.util.outputservice.BadOutputFormatException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.BadExperimentDataException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.OutputTableBuilder;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.TableFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import org.apache.log4j.Category;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class CSVOutputWriter {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String DISCLAIMER = ";; Multistage Output Data Provided by the Multistage OutputService.  1997-2003, CASSEL/SSEL, Caltech and UCLA.";
    private static Category log = Category.getInstance(CSVOutputWriter.class);
    private Element exp = null;
    private File outputFile = null;
    private OutputTableBuilder tableBuilder = null;

    public CSVOutputWriter(String outputFileName, Element exp) throws BadOutputFormatException {
        this(new File(outputFileName), exp);
    }

    public CSVOutputWriter(File outputFile, Element exp) throws BadOutputFormatException {
        this.outputFile = outputFile;
        this.exp = exp;
        if (exp == null) {
            throw new BadOutputFormatException("Null root experiment element, faled to initiate CSV output writer.");
        }
        this.tableBuilder = new OutputTableBuilder(exp);
    }

    public void writeOutputToCSV() throws BadOutputFormatException, IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));
        writer.write(this.formatToCSV());
        writer.flush();
        writer.close();
    }

    private String formatToCSV() throws IOException, BadExperimentDataException {
        TableFormatter clientRoundTable;
        TableFormatter groupRoundTable;
        TableFormatter clientMatchTable;
        TableFormatter groupMatchTable;
        TableFormatter clientMatcherTable;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getExperimentMetaInfo());
        TableFormatter generalMatcherTable = this.tableBuilder.getGeneralMatcherTable();
        if (generalMatcherTable != null) {
            sb.append(generalMatcherTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientMatcherTable = this.tableBuilder.getClientMatcherTable()) != null) {
            sb.append(clientMatcherTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        if ((groupMatchTable = this.tableBuilder.getGroupMatchTable()) != null) {
            sb.append(groupMatchTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientMatchTable = this.tableBuilder.getClientMatchTable()) != null) {
            sb.append(clientMatchTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        if ((groupRoundTable = this.tableBuilder.getGroupRoundTable()) != null) {
            sb.append(groupRoundTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        if ((clientRoundTable = this.tableBuilder.getClientRoundTable()) != null) {
            sb.append(clientRoundTable.tableToCSV()).append(NEWLINE).append(NEWLINE);
        }
        sb.append(this.getMatchParams()).append(NEWLINE).append(NEWLINE);
        sb.append(DISCLAIMER);
        return sb.toString();
    }

    private String getExperimentMetaInfo() {
        String email;
        StringBuffer meta = new StringBuffer();
        String name = this.exp.getAttributeValue("experimenterName");
        if (name != null) {
            meta.append(";; Experimenter Name: ").append(name).append(NEWLINE);
        }
        if ((email = this.exp.getAttributeValue("experimenterEmail")) != null) {
            meta.append(";; Experimenter Email: ").append(email).append(NEWLINE);
        }
        meta.append(";; Experiment Time: ").append(this.exp.getAttributeValue("exptime")).append(NEWLINE);
        meta.append(";; Number of Subjects Used: ").append(this.exp.getAttributeValue("numOfSubjects")).append(NEWLINE);
        meta.append(";; Number of Matches Run: ").append(this.exp.getAttributeValue("numOfMatches")).append(NEWLINE);
        meta.append(";;").append(NEWLINE);
        return meta.toString();
    }

    private String getMatchParams() throws IOException {
        Element matchParams = this.exp.getChild("matchParams");
        if (matchParams == null) {
            return ";; No match parameters found!";
        }
        BufferedReader reader = new BufferedReader(new StringReader(matchParams.getText()));
        StringBuffer sb = new StringBuffer(";;");
        sb.append(NEWLINE);
        sb.append(";; Experiment Parameters").append(NEWLINE);
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(";; ").append(line).append(NEWLINE);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            File inFile = new File("C:\\downloads\\bystander_st1n3se1_101508_1030\\bystander_st1n3se1_101508_1030.tmp");
            String outFile = "C:\\downloads\\bystander_st1n3se1_101508_1030ucla3\\bystander_st1n3se1_101508_1030ucla3.csv";
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inFile);
            CSVOutputWriter outWriter = new CSVOutputWriter(outFile, doc.getRootElement());
            outWriter.writeOutputToCSV();
            System.out.println("Output service has successfully transformed output file: " + inFile + " into a CSV file: " + outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

