/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice.gui;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class CentipedeOutputConverter
extends JFrame {
    private File dataFile;
    private File outputFile;
    private Properties props;
    private TableModel model = new DataTableModel();
    private ExpType type = null;
    private JTable dataTable;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuBar fileMenuBar;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JMenuItem openMenuItem;
    private JMenuItem saveMenuItem;

    public CentipedeOutputConverter() {
        this.props = new Properties();
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.dataTable = new JTable();
        this.fileMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Multistage Output Data Converter");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 770, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 53, Short.MAX_VALUE));
        this.dataTable.setModel(this.model);
        this.jScrollPane1.setViewportView(this.dataTable);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 770, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 331, -2)));
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CentipedeOutputConverter.this.fileMenuActionPerformed(evt);
            }
        });
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CentipedeOutputConverter.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save As");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CentipedeOutputConverter.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CentipedeOutputConverter.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.fileMenuBar.add(this.fileMenu);
        this.setJMenuBar(this.fileMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            String dataFileName = fc.getSelectedFile().getAbsolutePath();
            try {
                this.dataFile = new File(dataFileName);
            }
            catch (SecurityException e) {
                JOptionPane.showMessageDialog(this, "Failed to access data file: " + dataFileName);
            }
            try {
                this.processDataFile();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed to process data file: " + dataFileName);
                ex.printStackTrace();
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            String outputFileName = fc.getSelectedFile().getAbsolutePath();
            try {
                this.outputFile = new File(outputFileName);
            }
            catch (SecurityException e) {
                JOptionPane.showMessageDialog(this, "Failed to access output file: " + outputFileName);
            }
            try {
                this.writeOutputFile();
                JOptionPane.showMessageDialog(this, "Data have been successfully converted to the new data file: " + outputFileName);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Failed to write out data file: " + this.outputFile.getName());
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CentipedeOutputConverter().setVisible(true);
            }
        });
    }

    CentipedeData parseRoundData(int matchNum, int groupNum, int[] clientIds, String data) {
        StringTokenizer st = new StringTokenizer(data, ",");
        CentipedeData mv = new CentipedeData();
        mv.matchNum = matchNum;
        mv.groupNum = groupNum;
        mv.stageNum = Integer.parseInt(st.nextToken());
        mv.partnerNum = Integer.parseInt(st.nextToken());
        mv.myId = clientIds[mv.partnerNum];
        mv.move = st.nextToken();
        if (!mv.move.equalsIgnoreCase("decision")) {
            mv.payoffX = Integer.parseInt(st.nextToken());
            mv.payoffY = Integer.parseInt(st.nextToken());
        }
        mv.time = Long.parseLong(st.nextToken());
        return mv;
    }

    private void processDataFile() throws IOException {
        this.props.load(new FileReader(this.dataFile));
        int numMatches = Integer.parseInt(this.props.getProperty("numOfMatches"));
        for (int m = 0; m < numMatches; ++m) {
            String group;
            boolean practice = Boolean.parseBoolean(this.props.getProperty("match." + m + ".practice"));
            if (practice) continue;
            if (m == 0) {
                this.type = ExpType.valueOf(this.props.getProperty("match." + m + ".type"));
            }
            for (int g = 0; g < Integer.MAX_VALUE && (group = this.props.getProperty("match." + m + "." + "group." + g + ".clients")) != null; ++g) {
                StringTokenizer st = new StringTokenizer(group, ",");
                int grpSize = st.countTokens();
                int[] map = new int[grpSize];
                for (int i = 0; i < grpSize; ++i) {
                    map[i] = Integer.parseInt(st.nextToken());
                }
                for (int r = 0; r <= Integer.MAX_VALUE && this.props.getProperty("match." + m + "." + "group." + g + ".move." + r) != null; ++r) {
                    CentipedeData mv = this.parseRoundData(m, g, map, this.props.getProperty("match." + m + "." + "group." + g + ".move." + r));
                    ((DataTableModel)this.model).addData(mv);
                }
            }
        }
    }

    private void writeOutputFile() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));
        StringBuffer content = new StringBuffer();
        String NL = System.getProperty("line.separator");
        content.append(";;Experiment time: ").append(this.props.getProperty("exptime")).append(NL);
        content.append(";;Original output file name: ").append(this.dataFile.getName()).append(NL);
        content.append(";;" + (Object)((Object)this.type) + " Experiment Data Table").append(NL);
        content.append(";;");
        for (int c = 0; c < this.model.getColumnCount(); ++c) {
            content.append(this.model.getColumnName(c)).append(",");
        }
        content.append(NL);
        DataTableModel table = (DataTableModel)this.model;
        for (int l = 0; l < table.getdata().size(); ++l) {
            content.append(table.getdata().get(l).toString()).append(NL);
        }
        writer.write(content.toString());
        writer.flush();
        writer.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataTableModel
    extends AbstractTableModel {
        private List<CentipedeData> data;
        private String[] colNames = new String[]{"Match #", "Group #", "Stage #", "ClientId", "Subject #", "Move", "Payoff X", "Payoff Y", "Timestamp"};

        public DataTableModel() {
            this.data = new ArrayList<CentipedeData>();
        }

        public DataTableModel(List<CentipedeData> data) {
            this.data = data;
        }

        public List<CentipedeData> getdata() {
            return this.data;
        }

        public void addData(CentipedeData d) {
            if (this.data.add(d)) {
                this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            }
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CentipedeData d = this.data.get(row);
            switch (col) {
                case 0: {
                    return d.matchNum;
                }
                case 1: {
                    return d.groupNum;
                }
                case 2: {
                    return d.stageNum;
                }
                case 3: {
                    return d.myId;
                }
                case 4: {
                    return d.partnerNum;
                }
                case 5: {
                    return d.move;
                }
                case 6: {
                    return d.payoffX;
                }
                case 7: {
                    return d.payoffY;
                }
                case 8: {
                    return d.time;
                }
            }
            return "Unknown Cell";
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }
    }

    class CentipedeData {
        int matchNum;
        int groupNum;
        int myId;
        int stageNum;
        String move;
        int payoffX;
        int payoffY;
        long time;
        private int partnerNum;

        CentipedeData() {
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.matchNum).append(",").append(this.groupNum).append(",").append(this.stageNum).append(",").append(this.myId).append(",").append(this.partnerNum).append(",").append(this.move).append(",").append(this.payoffX).append(",").append(this.payoffY).append(",").append(this.time);
            return b.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpType {
        Centipede;

    }
}

