/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.outputservice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TransactionConvertor {
    public static void main(String[] args) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        try {
            String fname = args[0];
            try {
                BufferedReader br = new BufferedReader(new FileReader(fname));
                String line = br.readLine();
                while (line != null) {
                    if (!line.startsWith("#")) {
                        String[] parval = line.split("=");
                        if (parval.length == 2) {
                            params.put(parval[0], parval[1]);
                        } else {
                            System.out.println("line doesn't parse correctly: *" + line + "*");
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Invalid parameter received: " + e.getMessage());
            e.printStackTrace();
        }
        int nMatches = Integer.parseInt((String)params.get("numOfMatches"));
        System.out.println("numMatches==" + nMatches);
        int groupSize = 0;
        int nRounds = 0;
        try {
            int i;
            BufferedWriter file = new BufferedWriter(new FileWriter("out.csv"));
            file.write("\\;\\; Experiment Time: " + (String)params.get("exptime") + "\n");
            file.write("\\;\\; Number of Subjects Used: \n");
            file.write("\\;\\; Number of Matches Run: " + (String)params.get("numOfMatches") + "\n");
            file.write("\\;\\;\n");
            file.write("\\;\\; Table Name: Group Transaction Data\n");
            file.write("matchId,roundId,groupId,transactionId,");
            String[] keyStrings = new String[]{"time", "marketNum", "bidder", "bidderId", "bidderParty", "bidderSamples", "bid", "lowSeller", "seller", "sellerId", "sellerParty", "sellerSamples", "transacted", "blockSize", "tradeExecuted", "bidderGives", "bidderReceives"};
            Set keyset = params.keySet();
            Vector newKeys = new Vector();
            for (int i2 = 0; i2 < keyset.size(); ++i2) {
            }
            boolean[] display = new boolean[keyStrings.length];
            for (i = 0; i < keyStrings.length; ++i) {
                display[i] = false;
                Enumeration keys = params.keys();
                boolean found = false;
                while (keys.hasMoreElements() && !found) {
                    if (!((String)keys.nextElement()).endsWith(keyStrings[i])) continue;
                    System.out.println("found key which ends with " + keyStrings[i]);
                    file.write(keyStrings[i] + ",");
                    if (keyStrings[i].equalsIgnoreCase("bidder")) {
                        file.write("bidderValue,");
                    } else if (keyStrings[i].equalsIgnoreCase("seller")) {
                        file.write("sellerValue,");
                    }
                    found = true;
                    display[i] = true;
                }
            }
            file.write("\n");
            for (i = 0; i < nMatches; ++i) {
                int nTransactions = 0;
                if (!((String)params.get("match." + i + ".status")).equalsIgnoreCase("OK")) {
                    System.out.println("match." + i + ".status != OK");
                    continue;
                }
                if (((String)params.get("match." + i + ".practice")).equalsIgnoreCase("true")) {
                    System.out.println("match." + i + "practice==true");
                    continue;
                }
                int nGroups = 0;
                boolean more = true;
                while (more) {
                    if (params.containsKey("match." + i + ".group." + nGroups + ".clients")) {
                        ++nGroups;
                        continue;
                    }
                    more = false;
                }
                System.out.println("match." + i + ".numGroups==" + nGroups);
                if (params.containsKey("match." + i + ".groupSize")) {
                    groupSize = Integer.parseInt((String)params.get("match." + i + ".groupSize"));
                } else {
                    groupSize = -1;
                    for (int currM = i - 1; groupSize == -1 && currM >= 0; --currM) {
                        System.out.println("looking for match." + currM + ".groupSize...");
                        if (!params.containsKey("match." + currM + ".groupSize")) continue;
                        groupSize = Integer.parseInt((String)params.get("match." + currM + ".groupSize"));
                        System.out.println("match." + currM + ".groupSize=" + groupSize);
                    }
                }
                System.out.println("match." + i + ".groupSize==" + groupSize);
                for (int g = 0; g < nGroups; ++g) {
                    if (params.containsKey("match." + i + ".maxRounds")) {
                        nRounds = Integer.parseInt((String)params.get("match." + i + ".maxRounds"));
                    } else {
                        nRounds = -1;
                        for (int currM = i - 1; nRounds == -1 && currM >= 0; --currM) {
                            if (!params.containsKey("match." + currM + ".maxRounds")) continue;
                            nRounds = Integer.parseInt((String)params.get("match." + currM + ".maxRounds"));
                        }
                    }
                    System.out.println("match." + i + ".maxRounds=" + nRounds);
                    for (int r = 0; r < nRounds; ++r) {
                        if (!((String)params.get("match." + i + ".round." + r + ".status")).equalsIgnoreCase("OK")) {
                            System.out.println("match." + i + ".round." + r + ".status != OK");
                            continue;
                        }
                        boolean moreT = true;
                        int roundTransactions = 0;
                        while (moreT) {
                            System.out.println("looking for match." + i + ".group." + g + ".round." + r + ".transaction." + (nTransactions + roundTransactions) + ".time");
                            if (params.containsKey("match." + i + ".group." + g + ".round." + r + ".transaction." + (nTransactions + roundTransactions) + ".time")) {
                                ++roundTransactions;
                                continue;
                            }
                            moreT = false;
                        }
                        System.out.println("match." + i + ".group." + g + ".round." + r + ".numTransactions=" + roundTransactions);
                        for (int t = nTransactions; t < nTransactions + roundTransactions; ++t) {
                            String prefix = "match." + i + ".group." + g + ".round." + r + ".transaction." + t + ".";
                            file.write("" + i + "," + r + "," + g + "," + t + ",");
                            for (int k = 0; k < keyStrings.length; ++k) {
                                if (!display[k]) continue;
                                if (params.containsKey(prefix + keyStrings[k])) {
                                    int num;
                                    int next;
                                    int token;
                                    int numTokens;
                                    StringTokenizer tok;
                                    String clientString;
                                    int group;
                                    boolean foundIndex;
                                    int numGroups;
                                    boolean keepGoing;
                                    int index;
                                    int marketNum;
                                    file.write((String)params.get(prefix + keyStrings[k]) + ",");
                                    if (keyStrings[k].equalsIgnoreCase("bidder")) {
                                        int bidderNum = Integer.parseInt((String)params.get(prefix + keyStrings[k]));
                                        marketNum = 0;
                                        if (params.containsKey(prefix + "marketNum")) {
                                            marketNum = Integer.parseInt((String)params.get(prefix + "marketNum"));
                                        }
                                        index = -1;
                                        keepGoing = true;
                                        numGroups = 0;
                                        while (keepGoing) {
                                            if (params.containsKey("match.0.group." + numGroups + ".clients")) {
                                                ++numGroups;
                                                continue;
                                            }
                                            keepGoing = false;
                                        }
                                        foundIndex = false;
                                        for (group = 0; group < numGroups && !foundIndex; ++group) {
                                            clientString = (String)params.get("match.0.group." + group + ".clients");
                                            tok = new StringTokenizer(clientString, ",");
                                            numTokens = tok.countTokens();
                                            for (token = 0; token < numTokens; ++token) {
                                                next = Integer.parseInt(tok.nextToken());
                                                if (token != bidderNum) continue;
                                                foundIndex = true;
                                                index = token;
                                                num = next;
                                                file.write((String)params.get("match." + i + ".client." + num + ".round." + r + ".value." + marketNum) + ",");
                                            }
                                        }
                                    }
                                    if (!keyStrings[k].equalsIgnoreCase("seller")) continue;
                                    int sellerNum = Integer.parseInt((String)params.get(prefix + keyStrings[k]));
                                    marketNum = 0;
                                    if (params.containsKey(prefix + "marketNum")) {
                                        marketNum = Integer.parseInt((String)params.get(prefix + "marketNum"));
                                    }
                                    index = -1;
                                    keepGoing = true;
                                    numGroups = 0;
                                    while (keepGoing) {
                                        if (params.containsKey("match.0.group." + numGroups + ".clients")) {
                                            ++numGroups;
                                            continue;
                                        }
                                        keepGoing = false;
                                    }
                                    foundIndex = false;
                                    for (group = 0; group < numGroups && !foundIndex; ++group) {
                                        clientString = (String)params.get("match.0.group." + group + ".clients");
                                        tok = new StringTokenizer(clientString, ",");
                                        numTokens = tok.countTokens();
                                        for (token = 0; token < numTokens; ++token) {
                                            next = Integer.parseInt(tok.nextToken());
                                            if (token != sellerNum) continue;
                                            foundIndex = true;
                                            index = token;
                                            num = next;
                                            file.write((String)params.get("match." + i + ".client." + num + ".round." + r + ".value." + marketNum) + ",");
                                        }
                                    }
                                    continue;
                                }
                                file.write("N/A,");
                                if (!keyStrings[k].equalsIgnoreCase("bidder") && !keyStrings[k].equalsIgnoreCase("seller")) continue;
                                file.write("N/A,");
                            }
                            file.write("\n");
                        }
                    }
                }
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

