/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Category;

public class ProjectPropertiesReader {
    private static Category log;
    private Properties prop;
    private static final String NEWLINE;
    private static final String FILESEP;
    private static final String OS;
    private String projectName;
    private String propFileName;
    private String path = "";
    private String unixPropFile = "/home/yolanda/projs/matching-service/conf/matching-service.properties";
    private String winPropFile = "d:\\projs\\matching-service\\conf\\matching-service.properties";
    private String projectPropFile;
    private String matchFileDir;
    private String matchFileDirName = "matchFile.dir";

    public ProjectPropertiesReader() {
        try {
            this.path = System.getProperty("prop.home");
        }
        catch (Exception exception) {
            log.error((Object)"Failed in getting System Property for 'prop.home'");
        }
        try {
            this.projectName = System.getProperty("proj.name").toLowerCase();
            this.propFileName = this.projectName + ".properties";
        }
        catch (Exception exception1) {
            log.error((Object)"Failed in getting System Property for 'proj.name'");
        }
        this.projectPropFile = this.path != null && this.projectName != null ? this.path + FILESEP + this.propFileName : (OS.startsWith("Windows") ? this.winPropFile : this.unixPropFile);
        log.info((Object)("Loading properties file: " + this.projectPropFile));
        this.loadProperties();
    }

    public ProjectPropertiesReader(String propFile) {
        this.projectPropFile = propFile;
        log.info((Object)("Loading properties file: " + this.projectPropFile));
        this.loadProperties();
    }

    public String getMatchFileDir() {
        return this.matchFileDir;
    }

    public String getMatchFileDir(String def) {
        if (this.matchFileDir != null) {
            return this.matchFileDir;
        }
        return def;
    }

    private void loadProperties() {
        try {
            Object value = null;
            FileInputStream in = new FileInputStream(this.projectPropFile);
            Properties prop = new Properties();
            prop.load(in);
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.matchFileDir = prop.getProperty(this.matchFileDirName);
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to construct property for " + this.projectPropFile + ". " + e));
        }
    }

    static Class _mthclass$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        FILESEP = System.getProperty("file.separator");
        OS = System.getProperty("os.name");
        log = Category.getInstance(ProjectPropertiesReader.class);
    }
}

