/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.DataFormatException;
import java.util.Vector;

public class Types {
    Vector players = new Vector();
    int typenum = 0;

    public Types(int typenumber) {
        this.typenum = typenumber;
        this.players.clear();
    }

    public Types(int typenumber, Vector p) throws DataFormatException, NullPointerException {
        this.typenum = typenumber;
        boolean flag = true;
        for (int i = 0; i < p.size(); ++i) {
            flag = flag && p.elementAt(i) instanceof Integer;
        }
        if (!flag) {
            throw new DataFormatException();
        }
        this.players = p;
    }

    public Types(int typenumber, int player) {
        this.typenum = typenumber;
        this.players = new Vector();
        this.players.add(new Integer(player));
    }

    public void add(int playernum) {
        this.players.add(new Integer(playernum));
    }

    public int getTypeNumber() {
        return this.typenum;
    }

    public void setTypeNumber(int t) {
        this.typenum = t;
    }

    public int getTypeSize() {
        return this.players.size();
    }

    public boolean equals(Types g) {
        boolean flag = this.getTypeSize() == g.getTypeSize();
        for (int i = 0; i < this.getTypeSize(); ++i) {
            flag = flag && g.contains(this.getPlayerAt(i));
        }
        return flag;
    }

    public boolean contains(int playernum) {
        boolean flag = false;
        for (int i = 0; i < this.getTypeSize(); ++i) {
            flag = flag || playernum == this.getPlayerAt(i);
        }
        return flag;
    }

    public Object clone() {
        return new Types(this.getTypeNumber(), (Vector)this.players.clone());
    }

    public String toString() {
        String temp = "Type " + this.getTypeNumber() + ": ";
        for (int i = 0; i < this.players.size(); ++i) {
            temp = temp + Integer.toString((Integer)this.players.elementAt(i)) + " ";
        }
        return temp;
    }

    public boolean cyclic() {
        boolean flag;
        boolean bl = flag = this.players.size() > 0;
        if (flag) {
            int temp = (Integer)this.players.elementAt(0);
            flag = this.removePlayerAt(0);
            this.add(temp);
        }
        return flag;
    }

    public boolean removePlayerAt(int index) {
        boolean flag;
        boolean bl = flag = index < this.players.size();
        if (flag) {
            this.players.removeElementAt(index);
        }
        return flag;
    }

    public boolean removePlayer(int player) {
        boolean flag = this.players.contains(new Integer(player));
        if (flag) {
            flag = this.players.removeElement(new Integer(player));
        }
        return flag;
    }

    public int getPlayerAt(int index) throws IndexOutOfBoundsException {
        return (Integer)this.players.elementAt(index);
    }
}

