/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.DataFormatException;
import edu.caltech.ssel.multistage.server.util.matchingservice.Types;
import java.util.Random;
import java.util.Vector;

public class TypeClass {
    private Vector types = new Vector();
    private int numplayers = 0;

    public TypeClass(int tsize, int tnum, int num, boolean sortType, boolean random) {
        this.numplayers = num;
        this.types = new Vector(this.numplayers);
        this.types.setSize(this.numplayers);
        int leftover = num - tsize * tnum;
        if (random) {
            int r1;
            int i;
            Vector<Integer> temp = new Vector<Integer>(this.numplayers);
            Random r = new Random();
            for (i = 0; i < this.numplayers; ++i) {
                temp.add(i, new Integer(i));
            }
            for (i = 0; i < tnum; ++i) {
                for (int j = 0; j < tsize; ++j) {
                    int r12 = r.nextInt(temp.size());
                    this.types.set((Integer)temp.elementAt(r12), new Integer(i + 1));
                    temp.removeElementAt(r12);
                }
            }
            if (sortType) {
                for (i = 0; i < leftover; ++i) {
                    r1 = r.nextInt(temp.size());
                    this.types.set((Integer)temp.elementAt(r1), new Integer(i % tnum + 1));
                    temp.removeElementAt(r1);
                }
            } else {
                for (i = 0; i < leftover; ++i) {
                    r1 = r.nextInt(temp.size());
                    this.types.set((Integer)temp.elementAt(r1), new Integer(tnum + 1));
                    temp.removeElementAt(r1);
                }
            }
        } else {
            int i;
            for (i = 0; i < tnum; ++i) {
                for (int j = 0; j < tsize; ++j) {
                    this.types.set(i * tsize + j, new Integer(i + 1));
                }
            }
            if (sortType) {
                for (i = 0; i < leftover; ++i) {
                    this.types.set(tnum * tsize + i, new Integer(i % tnum + 1));
                }
            } else {
                for (i = 0; i < leftover; ++i) {
                    this.types.set(tnum * tsize + i, new Integer(tnum + 1));
                }
            }
        }
    }

    public TypeClass(int num) {
        this.numplayers = num;
        this.types = new Vector(this.numplayers);
    }

    public TypeClass(Vector t) throws NullPointerException, DataFormatException {
        boolean flag = true;
        for (int i = 0; i < t.size(); ++i) {
            flag = flag && t.elementAt(i) instanceof Integer;
        }
        if (!flag) {
            throw new DataFormatException("Data for TypeClass initialization is of wrong format");
        }
        this.numplayers = t.size();
        this.types = t;
    }

    public static TypeClass parse(String line) throws NullPointerException {
        Vector<Integer> type = new Vector<Integer>();
        if (!(line = line.trim()).startsWith("type")) {
            return null;
        }
        int player = 0;
        int typ = 0;
        int index = 0;
        while ((index = line.indexOf(" ", index) + 1) > 0) {
            ++player;
            try {
                int nextindex = line.indexOf(" ", index);
                typ = nextindex > index ? Integer.parseInt(line.substring(index, nextindex)) : Integer.parseInt(line.substring(index));
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
            type.add(player - 1, new Integer(typ));
        }
        return new TypeClass(type);
    }

    public Object clone() {
        return new TypeClass((Vector)this.types.clone());
    }

    public boolean equals(TypeClass g) {
        boolean flag;
        boolean bl = flag = this.getNumberOfPlayers() == g.getNumberOfPlayers();
        if (flag) {
            for (int i = 0; i < this.getNumberOfPlayers(); ++i) {
                flag = flag && this.getTypeOfPlayer(i + 1) == g.getTypeOfPlayer(i + 1);
            }
        }
        return flag;
    }

    public String toString() {
        String output = "type ";
        for (int i = 0; i < this.numplayers; ++i) {
            output = output + ((Integer)this.types.elementAt(i)).toString() + " ";
        }
        return output + "\r\n";
    }

    public void add(int typ) {
        this.types.add(new Integer(typ));
    }

    public boolean setType(int player, int typ) {
        boolean flag = this.contains(player);
        this.types.add(player - 1, new Integer(typ));
        return flag;
    }

    public int getNumberOfPlayers() {
        return this.numplayers;
    }

    public Types getType(int typ) {
        Types temp = new Types(typ);
        for (int i = 0; i < this.numplayers; ++i) {
            if (this.getTypeOfPlayer(i + 1) != typ) continue;
            temp.add(i + 1);
        }
        return temp;
    }

    public boolean contains(int player) {
        return player <= this.numplayers;
    }

    public int getTypeOfPlayer(int player) {
        if (this.contains(player)) {
            return (Integer)this.types.elementAt(player - 1);
        }
        return -1;
    }

    public Vector getTypes() {
        Vector<Types> temp = new Vector<Types>();
        for (int i = 0; i < this.getNumberOfPlayers(); ++i) {
            int j;
            boolean newtype = true;
            for (j = 0; j < temp.size() && newtype; ++j) {
                newtype = newtype && ((Types)temp.elementAt(j)).getTypeNumber() != this.getTypeOfPlayer(i + 1);
            }
            if (newtype) {
                temp.add(new Types(this.getTypeOfPlayer(i + 1), i + 1));
                continue;
            }
            ((Types)temp.elementAt(j - 1)).add(i + 1);
        }
        return temp;
    }

    public int getNumberOfTypes() {
        return this.getTypes().size();
    }
}

