/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.DataFormatException;
import edu.caltech.ssel.multistage.server.util.matchingservice.Types;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class TypeButton
extends JButton {
    private Types type = null;

    public TypeButton() {
        this.type = new Types(0);
    }

    public TypeButton(int number) {
        this.type = new Types(number);
    }

    public TypeButton(int number, Vector players) throws DataFormatException {
        this.type = new Types(number, players);
    }

    public TypeButton(int number, int player) {
        this.type = new Types(number, player);
    }

    public TypeButton(String text) {
        super(text);
        this.type = new Types(0);
    }

    public TypeButton(int number, String text) {
        super(text);
        this.type = new Types(number);
    }

    public TypeButton(int number, Vector players, String text) throws DataFormatException {
        super(text);
        this.type = new Types(number, players);
    }

    public TypeButton(int number, int player, String text) {
        super(text);
        this.type = new Types(number, player);
    }

    public TypeButton(Types t) {
        this.type = t;
    }

    public TypeButton(Types t, String text) {
        super(text);
        this.type = t;
    }

    public void setTypeNumber(int num) {
        this.type.setTypeNumber(num);
    }

    public int getTypeNumber() {
        return this.type.getTypeNumber();
    }

    public int getTypeSize() {
        return this.type.getTypeSize();
    }

    public int selectPlayer(boolean random) {
        if (this.type.getTypeSize() < 1) {
            return -1;
        }
        int selectedPlayer = 0;
        if (random) {
            Random r = new Random();
            selectedPlayer = this.type.getPlayerAt(r.nextInt(this.type.getTypeSize()));
        } else {
            Object[] selectionValues = new Integer[this.type.getTypeSize()];
            for (int i = 0; i < this.type.getTypeSize(); ++i) {
                selectionValues[i] = new Integer(this.type.getPlayerAt(i));
            }
            Object inputValue = JOptionPane.showInputDialog(this, "Select a Player from this Type:", "Player Selection", -1, null, selectionValues, selectionValues[0]);
            try {
                if (inputValue == null) {
                    throw new NullPointerException();
                }
                selectedPlayer = (Integer)inputValue;
                if (!this.type.contains(selectedPlayer)) {
                    throw new NumberFormatException();
                }
            }
            catch (NullPointerException nullpointerexception) {
                return -2;
            }
            catch (NumberFormatException numberformatexception) {
                return -3;
            }
        }
        return selectedPlayer;
    }

    boolean removePlayer(int player) {
        return this.type.removePlayer(player);
    }
}

