/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.Grouping;
import edu.caltech.ssel.multistage.server.util.matchingservice.GroupingList;
import edu.caltech.ssel.multistage.server.util.matchingservice.Groupings;
import edu.caltech.ssel.multistage.server.util.matchingservice.IDClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchFile;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchFileReader;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchGroup;
import edu.caltech.ssel.multistage.server.util.matchingservice.NotMatchFileException;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.Types;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Category;

public class MatchingService {
    private static Category log = Category.getInstance(MatchingService.class);
    private int num_players;
    private int group_size;
    private int matching_algorithm;
    private int num_types;
    private boolean random_typing;
    private int repetitions = 1;
    private MatchFile matchFile;
    private MatchFileReader matchFileReader;
    private IDClass idClass;
    private TypeClass typeClass;
    private MatchClass matchClass;
    private Vector matchClasses;
    private Grouping grouping;
    private Groupings groupings;
    private GroupingList groupingList;

    public MatchingService(String file_path) {
        this.readMatchFile(file_path);
    }

    public MatchingService(int num_players, int group_size) {
        this.num_players = num_players;
        this.group_size = group_size;
        this.num_types = 1;
        this.matching_algorithm = 2;
        this.random_typing = false;
        this.startService();
    }

    public MatchingService(int num_players, int num_types, int matching_algorithm) {
        this(num_players, num_types, matching_algorithm, false);
    }

    public MatchingService(int num_players, int num_types, int matching_algorithm, boolean random_typing) {
        this.num_players = num_players;
        this.group_size = num_players / num_types;
        this.num_types = num_types;
        this.matching_algorithm = matching_algorithm;
        this.random_typing = random_typing;
        this.startService();
    }

    private void startService() {
        this.matchFile = new MatchFile();
        this.groupings = new Groupings();
        this.setIDClass();
        this.setTypes();
        this.setMatches();
        this.setGroupings();
    }

    private void setIDClass() {
        this.idClass = new IDClass(this.num_players);
        log.debug((Object)("Number of Players = " + this.idClass.getNumberOfPlayers()));
        this.matchFile.addIDClass(this.idClass);
    }

    private void setTypes() {
        int type_size = this.num_players / this.num_types;
        this.typeClass = new TypeClass(type_size, this.num_types, this.num_players, true, this.random_typing);
        this.matchFile.addTypeClass(this.typeClass);
        log.debug((Object)("Number of Types = " + this.typeClass.getNumberOfTypes()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setMatches() {
        Vector typesVector = this.typeClass.getTypes();
        if (this.matching_algorithm == 1) {
            if (this.typeClass.getNumberOfTypes() <= 1) {
                log.error((Object)"Number of types must be > 1 to use Zipper.  Matching aborted");
                System.err.println("Number of types must be > 1 to use Zipper.  Matching aborted");
                return;
            }
            this.matchClasses = this.getZipperMatching(typesVector);
            log.debug((Object)"Matching Algorithm = Zipper");
        } else if (this.matching_algorithm == 2) {
            if (this.typeClass.getNumberOfTypes() <= 0) {
                log.error((Object)"Number of types must be > 0 to use Random.  Matching aborted");
                System.err.println("Number of types must be > 0 to use Random.  Matching aborted");
                return;
            }
            this.matchClasses = this.getRandomMatching(typesVector);
            log.debug((Object)"Matching Algorithm = Random");
        } else if (this.matching_algorithm == 3) {
            log.debug((Object)"Using round robin");
            if (this.typeClass.getNumberOfTypes() != 1) {
                log.error((Object)"Number of types must be 1 to use RoundRobin.  Matching aborted");
                System.err.println("Number of types must be 1 to use RoundRobin.  Matching aborted");
                return;
            }
            this.matchClasses = this.getRoundRobinMatching();
            log.debug((Object)"Matching Algorithm = Round Robin");
        }
        log.debug((Object)("Number of match classes = " + this.matchClasses.size()));
    }

    private void setGroupings() {
        for (int i = 0; i < this.matchClasses.size(); ++i) {
            MatchClass mc = new MatchClass();
            mc = (MatchClass)this.matchClasses.elementAt(i);
            this.matchFile.addMatchClass(mc);
            this.groupingList = new GroupingList();
            for (int g = 0; g < mc.getNumberOfMatchGroups(); ++g) {
                MatchGroup mg = mc.getMatchGroupAt(g);
                for (int p = 0; p < mg.getSize(); ++p) {
                    int p_id = mg.getPlayerAt(p);
                    this.grouping = new Grouping(p_id, g, this.typeClass.getTypeOfPlayer(p_id));
                    this.groupingList.addGrouping(this.grouping);
                }
            }
            this.groupings.add(i, this.groupingList);
        }
    }

    private Vector getZipperMatching(Vector typesVector) {
        Vector<MatchClass> matchClassVector = new Vector<MatchClass>();
        Types[] types = new Types[typesVector.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (Types)((Types)typesVector.elementAt(i)).clone();
        }
        int t_size = types[0].getTypeSize();
        for (int i = 1; i < types.length; ++i) {
            if (t_size == types[i].getTypeSize()) continue;
            log.error((Object)"Types are not of equal size.  Matching aborted");
            return null;
        }
        boolean new_match_group = true;
        block2: for (int r = 0; r < this.repetitions; ++r) {
            for (int i = 0; i < t_size; ++i) {
                this.matchClass = new MatchClass();
                for (int j = 0; j < t_size; ++j) {
                    new_match_group = true;
                    for (int k = 0; k < types.length; ++k) {
                        this.matchClass.addToMatchGroup(types[k].getPlayerAt(j), new_match_group);
                        new_match_group = false;
                    }
                }
                matchClassVector.add(this.matchClass);
                boolean rotation_end = false;
                if ((i + 1) * (types.length - 1) >= t_size) continue block2;
                for (int m = 0; m < types.length; ++m) {
                    for (int num_cycles = m; num_cycles > 0; --num_cycles) {
                        types[m].cyclic();
                    }
                }
            }
        }
        return matchClassVector;
    }

    private Vector getRandomMatching(Vector typesVector) {
        Vector<MatchClass> matchClassVector = new Vector<MatchClass>();
        boolean new_match_group = true;
        Random rand = new Random();
        if (typesVector.size() == 1) {
            int num_groups = this.num_players / this.group_size;
            for (int r = 0; r < this.repetitions; ++r) {
                long seed = rand.nextLong();
                Random ra = new Random(seed);
                this.matchClass = new MatchClass();
                Vector<Integer> playersLeft = new Vector<Integer>();
                for (int i = 0; i < this.num_players; ++i) {
                    playersLeft.addElement(new Integer(i));
                }
                for (int g = 0; g < num_groups; ++g) {
                    new_match_group = true;
                    int[] randomPlayer = new int[this.group_size];
                    for (int i = 0; i < this.group_size; ++i) {
                        int random_num = ra.nextInt(playersLeft.size());
                        randomPlayer[i] = Integer.parseInt(playersLeft.elementAt(random_num).toString()) + 1;
                        this.matchClass.addToMatchGroup(randomPlayer[i], new_match_group);
                        new_match_group = false;
                        playersLeft.removeElementAt(random_num);
                    }
                }
                matchClassVector.add(this.matchClass);
            }
        } else {
            for (int r = 0; r < this.repetitions; ++r) {
                Types[] types = new Types[typesVector.size()];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = (Types)((Types)typesVector.elementAt(i)).clone();
                }
                int t_size = types[0].getTypeSize();
                for (int i = 1; i < types.length; ++i) {
                    if (t_size == types[i].getTypeSize()) continue;
                    log.error((Object)"Types are not of equal size.  Matching aborted");
                    return null;
                }
                long seed = rand.nextLong();
                Random ra = new Random(seed);
                int[] randomPlayer = new int[types.length];
                this.matchClass = new MatchClass();
                for (int j = 0; j < t_size; ++j) {
                    new_match_group = true;
                    for (int i = 0; i < randomPlayer.length; ++i) {
                        randomPlayer[i] = ra.nextInt(types[i].getTypeSize());
                    }
                    for (int k = 0; k < types.length; ++k) {
                        this.matchClass.addToMatchGroup(types[k].getPlayerAt(randomPlayer[k]), new_match_group);
                        new_match_group = false;
                    }
                    for (int m = 0; m < types.length; ++m) {
                        types[m].removePlayerAt(randomPlayer[m]);
                    }
                }
                matchClassVector.add(this.matchClass);
            }
        }
        return matchClassVector;
    }

    private Vector getRoundRobinMatching() {
        int r;
        Vector<MatchClass> matchClassVector = new Vector<MatchClass>();
        boolean even = this.num_players % 2 == 0;
        int rounds = even ? this.num_players - 1 : this.num_players;
        int[][] roundrobin = new int[rounds][this.num_players];
        for (r = 0; r < rounds; ++r) {
            for (int i = 0; i < rounds; ++i) {
                roundrobin[r][i] = (rounds + r - i - 1) % rounds;
            }
        }
        if (even) {
            for (r = 0; r < rounds; ++r) {
                roundrobin[r][this.num_players - 1] = this.num_players - 1;
            }
            for (int i = 0; i < this.num_players - 1; ++i) {
                int r2 = (2 * i + 1) % (this.num_players - 1);
                int temp = roundrobin[r2][i];
                roundrobin[r2][i] = roundrobin[r2][this.num_players - 1];
                roundrobin[r2][this.num_players - 1] = temp;
            }
        }
        for (int rep = 0; rep < this.repetitions; ++rep) {
            this.matchClass = new MatchClass();
            boolean new_match_group = false;
            for (int r3 = 0; r3 < rounds; ++r3) {
                for (int i = 0; i < this.num_players; ++i) {
                    int player1 = i + 1;
                    int player2 = roundrobin[r3][i] + 1;
                    boolean flag = this.matchClass.contains(player1);
                    new_match_group = true;
                    if (player1 != player2 && !flag) {
                        this.matchClass.addToMatchGroup(player1, new_match_group);
                        new_match_group = false;
                        this.matchClass.addToMatchGroup(player2, new_match_group);
                        new_match_group = false;
                    } else if (player1 == player2 && !flag) {
                        this.matchClass.addToMatchGroup(player1, new_match_group);
                        new_match_group = false;
                    }
                    new_match_group = true;
                }
                matchClassVector.add(this.matchClass);
                this.matchClass = new MatchClass();
            }
        }
        return matchClassVector;
    }

    public void setNumPlayers(int num_players) {
        this.num_players = num_players;
        this.startService();
    }

    public void setGroupSize(int group_size) {
        this.group_size = group_size;
        this.startService();
    }

    public void setNumTypes(int num_types) {
        this.num_types = num_types;
        this.startService();
    }

    public void setMatchingAlgorithm(int matching_algorithm) {
        this.matching_algorithm = matching_algorithm;
        this.startService();
    }

    public void setRandomTyping(boolean random_typing) {
        this.random_typing = random_typing;
        this.startService();
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
        this.startService();
    }

    public int getNumPlayers() {
        return this.num_players;
    }

    public int getGroupSize() {
        return this.group_size;
    }

    public int getNumTypes() {
        return this.num_types;
    }

    public int getMatchingAlgorithm() {
        return this.matching_algorithm;
    }

    public boolean getRandomTyping() {
        return this.random_typing;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public GroupingList randomnizeOnce() {
        this.setRepetitions(1);
        this.matching_algorithm = 2;
        return this.groupingList;
    }

    private void readMatchFile(String path) {
        try {
            this.matchFile = new MatchFile(new File(path));
            this.matchFileReader = new MatchFileReader(this.matchFile);
            this.groupings = this.matchFileReader.getGroupings();
        }
        catch (NotMatchFileException nmfe) {
            log.error((Object)("Failed to read match file in '" + path + "' : " + nmfe));
            System.err.println("Failed to read match file in '" + path + "' : " + nmfe);
        }
        catch (IOException ioe) {
            log.error((Object)("Failed to read match file in '" + path + "' : " + ioe));
            System.err.println("Failed to read match file in '" + path + "' : " + ioe);
        }
    }

    public void writeToFile(String path) {
        try {
            if (this.matchFile.writeToFile(path)) {
                log.info((Object)("Writting match file to '" + path + "' successful!"));
            } else {
                log.error((Object)("Failed to write match file to '" + path + "' successful!"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)("Failed to write to file '" + path + "' : " + e));
        }
    }

    public void setDescription(String desc) {
        this.matchFile.setDescription(desc);
    }

    public void printInWindow() {
        this.matchFile.printInWindow();
    }

    public Groupings getGroupings() {
        return this.groupings;
    }

    public GroupingList getGroupingListAt(int node) {
        return this.groupings.getAt(node);
    }

    public Grouping getGroupingAt(int groupings_index, int groupingList_index) {
        return this.groupings.getAt(groupings_index).getGroupingAt(groupingList_index);
    }

    public Vector getMatchClasses() {
        return this.matchClasses;
    }

    static Class _mthclass$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static void main(String[] argv) {
        MatchingService m = new MatchingService(12, 2, 1, false);
    }
}

