/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.DataFormatException;
import java.util.Vector;

public class MatchGroup {
    private Vector players = null;

    public MatchGroup() {
        this.players = new Vector();
    }

    public MatchGroup(Vector p) throws DataFormatException {
        boolean flag = true;
        for (int i = 0; i < p.size(); ++i) {
            flag = flag && p.elementAt(i) instanceof Integer;
        }
        if (!flag) {
            throw new DataFormatException();
        }
        this.players = p;
    }

    public static MatchGroup parse(String line) throws NullPointerException {
        line = line.trim();
        MatchGroup m = new MatchGroup();
        int index = 0;
        int nextindex = 0;
        do {
            nextindex = line.indexOf(" ", index);
            try {
                int player = nextindex > 0 ? Integer.parseInt(line.substring(index, nextindex)) : Integer.parseInt(line.substring(index));
                m.addPlayer(player);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
            index = nextindex + 1;
        } while (nextindex > 0);
        return m;
    }

    public void addPlayer(int player) {
        this.players.add(new Integer(player));
    }

    public int getSize() {
        return this.players.size();
    }

    public int getPlayerAt(int index) throws IndexOutOfBoundsException {
        return (Integer)this.players.elementAt(index);
    }

    public boolean removePlayer(int player) {
        boolean flag = this.contains(player);
        if (flag) {
            flag = this.players.removeElement(new Integer(player));
        }
        return flag;
    }

    public boolean contains(int player) {
        return this.players.contains(new Integer(player));
    }

    protected Object clone() {
        MatchGroup mtg = new MatchGroup();
        for (int i = 0; i < this.getSize(); ++i) {
            mtg.addPlayer(this.getPlayerAt(i));
        }
        return mtg;
    }

    public boolean equals(MatchGroup mtg) {
        boolean flag;
        boolean bl = flag = mtg.getSize() == this.getSize();
        if (flag) {
            for (int i = 0; i < this.getSize(); ++i) {
                flag = flag && mtg.contains(this.getPlayerAt(i));
            }
        }
        return flag;
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.getSize(); ++i) {
            output = output + this.getPlayerAt(i) + " ";
        }
        return output.trim();
    }
}

