/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.Grouping;
import edu.caltech.ssel.multistage.server.util.matchingservice.GroupingList;
import edu.caltech.ssel.multistage.server.util.matchingservice.Groupings;
import edu.caltech.ssel.multistage.server.util.matchingservice.IDClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchFile;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchGroup;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeClass;
import java.util.Vector;

public class MatchFileReader {
    private String description = "";
    private Vector matchingSets = new Vector();
    private Groupings groupings = new Groupings();

    public MatchFileReader(MatchFile matchFile) {
        try {
            if (matchFile.consistency()) {
                this.matchingSets = this.getMatchingSets(matchFile);
                this.setGroupings();
            } else {
                System.err.println("The data in the match file is inconsistent!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Vector getMatchingSets(MatchFile matchFile) {
        Vector<Object> tempInVector = new Vector<Object>();
        Vector<Vector<Object>> tempOutVector = new Vector<Vector<Object>>();
        boolean idIsSet = false;
        boolean typeIsSet = false;
        IDClass id = null;
        int id_index = 0;
        int type_index = 0;
        int match_index = 0;
        System.out.println("number of ID classes = " + matchFile.getNumberOfIDClass());
        System.out.println("number of Type classes = " + matchFile.getNumberOfTypeClass());
        System.out.println("number of Match classes = " + matchFile.getNumberOfMatchClass());
        for (int i = 0; i < matchFile.dataSize(); ++i) {
            System.out.print("" + i + ":  ");
            if (matchFile.isIDClass(i)) {
                if (!idIsSet) {
                    id = matchFile.getIDClassAt(id_index);
                    tempInVector.addElement(id);
                    System.out.println("adding id line: tempInVector==" + tempInVector);
                    idIsSet = true;
                } else {
                    System.out.println("id already set:  skipping id line.");
                }
                ++id_index;
            } else if (matchFile.isTypeClass(i)) {
                if (i != matchFile.dataSize() - 1 && matchFile.isMatchClass(i + 1)) {
                    if (!typeIsSet) {
                        System.out.println("type line found and type isn't set: adding type line");
                        tempInVector.addElement(matchFile.getTypeClassAt(type_index));
                        typeIsSet = true;
                    } else {
                        System.out.println("type line found but type already set.  Adding previous tempInVector to tempOutVector.  ClearingtempInVector: ");
                        tempOutVector.addElement(tempInVector);
                        tempInVector = new Vector();
                        tempInVector.addElement(id);
                        tempInVector.addElement(matchFile.getTypeClassAt(type_index));
                    }
                }
                ++type_index;
                System.out.println("adding type line:  tempInVector==" + tempInVector);
            } else if (matchFile.isMatchClass(i)) {
                tempInVector.addElement(matchFile.getMatchClassAt(match_index));
                ++match_index;
                System.out.println("adding match line:  tempInVector==" + tempInVector);
            }
            if (i != matchFile.dataSize() - 1) continue;
            tempOutVector.addElement(tempInVector);
        }
        System.out.println("tempOutVector==" + tempOutVector);
        return tempOutVector;
    }

    private void setGroupings() {
        System.out.println("matchingSets.size() = " + this.matchingSets.size());
        for (int s = 0; s < this.matchingSets.size(); ++s) {
            Vector insideVector = (Vector)this.matchingSets.elementAt(s);
            System.out.println("insideVector.size() = " + insideVector.size());
            IDClass idClass = (IDClass)insideVector.elementAt(0);
            TypeClass typeClass = (TypeClass)insideVector.elementAt(1);
            for (int i = 2; i < insideVector.size(); ++i) {
                MatchClass mc = new MatchClass();
                mc = (MatchClass)insideVector.elementAt(i);
                GroupingList groupingList = new GroupingList();
                for (int g = 0; g < mc.getNumberOfMatchGroups(); ++g) {
                    MatchGroup mg = mc.getMatchGroupAt(g);
                    for (int p = 0; p < mg.getSize(); ++p) {
                        int p_id = mg.getPlayerAt(p);
                        Grouping grouping = new Grouping(p_id, g, typeClass.getTypeOfPlayer(p_id));
                        groupingList.addGrouping(grouping);
                    }
                }
                this.groupings.add(groupingList);
            }
        }
    }

    public Groupings getGroupings() {
        return this.groupings;
    }
}

