/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.ExtensionFilter;
import edu.caltech.ssel.multistage.server.util.matchingservice.IDClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchDialog;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchFile;
import edu.caltech.ssel.multistage.server.util.matchingservice.NotMatchFileException;
import edu.caltech.ssel.multistage.server.util.matchingservice.Type;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.util.ProjectPropertiesReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MatchFileCreator
extends JFrame {
    private MatchFile matchfile = null;
    private JTextArea textareaPreview = new JTextArea();
    private JButton buttonAddMatch = new JButton();
    private JButton buttonType = new JButton();
    private JLabel labelPlayers = new JLabel();
    private JTextField textfieldPlayers = new JTextField();
    private JTextArea textareaDescription = new JTextArea();
    private TitledBorder titledBorder1;
    private JButton buttonNumber = new JButton();
    private TitledBorder titledBorder6;
    private JMenuBar menubar = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuitemNew = new JMenuItem();
    private JMenuItem menuitemOpen = new JMenuItem();
    private JMenuItem menuitemSave = new JMenuItem();
    private JMenuItem menuitemExit = new JMenuItem();
    private JScrollPane scrollpanePreview = new JScrollPane();
    private JScrollPane scrollpaneDescription = new JScrollPane();
    private JButton buttonEdit = new JButton();
    private JMenuItem menuitemSaveAs = new JMenuItem();

    public MatchFileCreator() {
        super("Match File Creator -");
        this.matchfile = new MatchFile();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(new Dimension(640, 630));
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("Match File Preview");
        this.titledBorder6 = new TitledBorder("File Description");
        this.textareaPreview.setBorder(this.titledBorder1);
        this.textareaPreview.setEditable(false);
        this.getContentPane().setLayout(null);
        this.buttonAddMatch.setEnabled(false);
        this.buttonAddMatch.setText("Add Match");
        this.buttonAddMatch.setBounds(new Rectangle(20, 95, 230, 35));
        this.buttonAddMatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.buttonAddMatch_actionPerformed(e);
            }
        });
        this.buttonType.setEnabled(false);
        this.buttonType.setText("Type Players");
        this.buttonType.setBounds(new Rectangle(22, 143, 227, 33));
        this.buttonType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.buttonType_actionPerformed(e);
            }
        });
        this.labelPlayers.setText("Number of Players:");
        this.labelPlayers.setBounds(new Rectangle(14, 13, 115, 31));
        this.textfieldPlayers.setBounds(new Rectangle(130, 25, 83, 23));
        this.textfieldPlayers.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MatchFileCreator.this.textfieldPlayers_keyPressed(e);
            }
        });
        this.textareaDescription.setMaximumSize(new Dimension(12, 45));
        this.textareaDescription.setBorder(this.titledBorder6);
        this.textareaDescription.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MatchFileCreator.this.textareaDescription_keyPressed(e);
            }
        });
        this.buttonNumber.setText("Set Number of Players");
        this.buttonNumber.setBounds(new Rectangle(20, 52, 228, 32));
        this.buttonNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.buttonNumber_actionPerformed(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MatchFileCreator.this.this_windowClosing(e);
            }
        });
        this.setResizable(false);
        this.menuFile.setMnemonic('F');
        this.menuFile.setText("File");
        this.menuitemNew.setMnemonic('N');
        this.menuitemNew.setText("New");
        this.menuitemNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.menuitemNew_actionPerformed(e);
            }
        });
        this.menuitemOpen.setMnemonic('O');
        this.menuitemOpen.setText("Open");
        this.menuitemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.menuitemOpen_actionPerformed(e);
            }
        });
        this.menuitemSave.setMnemonic('S');
        this.menuitemSave.setText("Save");
        this.menuitemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.menuitemSave_actionPerformed(e);
            }
        });
        this.menuitemExit.setMnemonic('X');
        this.menuitemExit.setText("Exit");
        this.menuitemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.menuitemExit_actionPerformed(e);
            }
        });
        this.scrollpanePreview.setBounds(new Rectangle(14, 198, 591, 331));
        this.scrollpaneDescription.setBounds(new Rectangle(260, 13, 344, 122));
        this.buttonEdit.setText("Manually Edit Match File");
        this.buttonEdit.setBounds(new Rectangle(435, 545, 171, 27));
        this.buttonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.buttonEdit_actionPerformed(e);
            }
        });
        this.menuitemSaveAs.setMnemonic('A');
        this.menuitemSaveAs.setText("Save As");
        this.menuitemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchFileCreator.this.menuitemSaveAs_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.labelPlayers, null);
        this.getContentPane().add((Component)this.scrollpaneDescription, null);
        this.scrollpaneDescription.getViewport().add((Component)this.textareaDescription, null);
        this.getContentPane().add((Component)this.scrollpanePreview, null);
        this.getContentPane().add((Component)this.buttonEdit, null);
        this.getContentPane().add((Component)this.buttonNumber, null);
        this.getContentPane().add((Component)this.buttonType, null);
        this.getContentPane().add((Component)this.buttonAddMatch, null);
        this.getContentPane().add((Component)this.textfieldPlayers, null);
        this.scrollpanePreview.getViewport().add((Component)this.textareaPreview, null);
        this.menubar.add(this.menuFile);
        this.menuFile.add(this.menuitemNew);
        this.menuFile.add(this.menuitemOpen);
        this.menuFile.add(this.menuitemSave);
        this.menuFile.add(this.menuitemSaveAs);
        this.menuFile.add(this.menuitemExit);
        this.setJMenuBar(this.menubar);
    }

    private void textfieldPlayers_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.buttonNumber.doClick();
        }
    }

    private void buttonNumber_actionPerformed(ActionEvent e) {
        if (this.buttonNumber.getText().trim().equals("Set Number of Players")) {
            int temp = 0;
            try {
                temp = Integer.parseInt(this.textfieldPlayers.getText());
                if (temp > 0) {
                    if (this.matchfile.getNumberOfPlayers() != temp) {
                        IDClass id = new IDClass(temp);
                        System.out.println("Number of Players changed to " + id.getNumberOfPlayers());
                        this.matchfile.addIDClass(id);
                        this.textareaPreview.setText(this.matchfile.datatoString());
                    }
                } else {
                    throw new NumberFormatException();
                }
                this.initializeMatchFile();
            }
            catch (NumberFormatException numberformatexception) {
                JOptionPane.showMessageDialog(null, "Number of Players Must be a Positive Integer", "Information", 1);
                this.textfieldPlayers.requestFocus();
                return;
            }
        } else if (this.buttonNumber.getText().trim().equals("Clear All")) {
            this.textfieldPlayers.setEnabled(true);
            this.textfieldPlayers.requestFocus();
            this.buttonNumber.setText("Set Number of Players");
            this.buttonType.setEnabled(false);
            this.buttonAddMatch.setEnabled(false);
            this.matchfile.clear();
            this.textareaPreview.setText(this.matchfile.datatoString());
        }
    }

    private void buttonEdit_actionPerformed(ActionEvent e) {
        int action;
        if (this.buttonEdit.getText().trim().equals("Manually Edit Match File")) {
            int action2 = JOptionPane.showOptionDialog(this, "Manually editing the match file may cause the resulting file to have the incorrect format.  Proceed?", "Warning", 0, 2, null, null, null);
            if (action2 == 0) {
                this.textareaPreview.setEditable(true);
                this.textareaPreview.requestFocus();
                this.buttonEdit.setText("Done Editing");
            }
            return;
        }
        if (!this.buttonEdit.getText().trim().equals("Done Editing")) {
            // empty if block
        }
        if ((action = JOptionPane.showOptionDialog(this, "Are you sure you want to retain your changes? (Clicking No will resore original match file.  Cancel will return to editing)", "Warning", 1, 2, null, null, null)) == 1) {
            this.textareaPreview.setEditable(false);
            this.buttonEdit.setText("Manually Edit Match File");
            this.textareaPreview.setText(this.matchfile.datatoString());
            this.buttonEdit.requestFocus();
        } else if (action == 0) {
            MatchFile temp = (MatchFile)this.matchfile.clone();
            String output = this.textareaPreview.getText().trim();
            boolean flag = true;
            try {
                this.matchfile.parseOutput(new BufferedReader(new StringReader(output)));
            }
            catch (IOException ioexception) {
                JOptionPane.showMessageDialog(null, "Could not read in modified match file.  Try again.", "Error", 0);
                this.textareaPreview.requestFocus();
                return;
            }
            catch (NotMatchFileException notmatchfileexception) {
                JOptionPane.showMessageDialog(null, "New match file is not parsable.  Old match file is retained.", "Error", 0);
                flag = false;
            }
            boolean flag1 = this.matchfile.consistency();
            if (!flag1) {
                JOptionPane.showMessageDialog(null, "New match file fails internal consistency checks.  Old match file is retained", "Error", 0);
            }
            if (!flag || !flag1) {
                this.matchfile = temp;
            }
            this.textareaPreview.setText(this.matchfile.datatoString());
            this.textareaPreview.setEditable(false);
            this.buttonEdit.setText("Manually Edit Match File");
            this.buttonEdit.requestFocus();
            this.initializeMatchFile();
        } else {
            this.textareaPreview.requestFocus();
            return;
        }
    }

    private void textareaDescription_keyPressed(KeyEvent e) {
        this.matchfile.setDescription(this.textareaDescription.getText().trim());
    }

    private void buttonType_actionPerformed(ActionEvent e) {
        Type type = new Type(this, this.matchfile.getNumberOfPlayers());
        if (type.getFinished()) {
            TypeClass types = type.getTypes();
            this.matchfile.addTypeClass(types);
            this.textareaPreview.append(types.toString());
            this.buttonAddMatch.setEnabled(true);
            this.buttonAddMatch.requestFocus();
        }
        type = null;
        System.gc();
    }

    private void buttonAddMatch_actionPerformed(ActionEvent e) {
        if (this.matchfile.isTyped()) {
            MatchDialog match = new MatchDialog(this, this.matchfile.getLastTypeClass());
            if (match.getFinished()) {
                Vector v = match.getMatchClasses();
                for (int i = 0; i < v.size(); ++i) {
                    this.matchfile.addMatchClass((MatchClass)v.elementAt(i));
                    this.textareaPreview.append(((MatchClass)v.elementAt(i)).toString());
                }
            }
            match = null;
            System.gc();
        }
    }

    private void exitprocedure() {
        System.exit(0);
    }

    private void this_windowClosing(WindowEvent e) {
        this.exitprocedure();
    }

    private void menuitemExit_actionPerformed(ActionEvent e) {
        if (this.matchfile.wasModified()) {
            int action = JOptionPane.showOptionDialog(this, "Save Changes?", "Save", 1, 2, null, null, null);
            if (action == 0) {
                this.menuitemSave.doClick();
            } else if (action == 2) {
                return;
            }
        }
        this.exitprocedure();
    }

    private void menuitemOpen_actionPerformed(ActionEvent e) {
        int opt;
        JFileChooser test = null;
        ProjectPropertiesReader propertiesReader = new ProjectPropertiesReader();
        String matchFileDir = propertiesReader.getMatchFileDir();
        try {
            test = this.matchfile.getFile().getParentFile().exists() ? new JFileChooser(this.matchfile.getFile().getParentFile()) : (new File(matchFileDir).exists() ? new JFileChooser(matchFileDir) : new JFileChooser());
        }
        catch (NullPointerException nullpointerexception) {
            try {
                test = new JFileChooser(matchFileDir);
            }
            catch (NullPointerException nullpointerexception1) {
                test = new JFileChooser();
            }
        }
        ExtensionFilter filter = new ExtensionFilter();
        filter.setDirectoriesBlocked(false);
        test.addChoosableFileFilter(filter);
        if (!this.matchfile.datatoString().equals("") && this.matchfile.wasModified()) {
            int action = JOptionPane.showOptionDialog(this, "Save Changes?", "Save", 1, 2, null, null, null);
            if (action == 0) {
                this.menuitemSave.doClick();
            } else if (action == 2) {
                return;
            }
        }
        if ((opt = test.showOpenDialog(this)) == 0) {
            File file = test.getSelectedFile();
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    JOptionPane.showMessageDialog(null, "This file does not exist.  New file " + this.matchfile.getFileName() + " created.", "Error", 0);
                }
            }
            catch (IOException ioexception) {
                JOptionPane.showMessageDialog(null, "Error opening file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            try {
                this.matchfile = new MatchFile(file);
            }
            catch (NotMatchFileException notmatchfileexception) {
                JOptionPane.showMessageDialog(null, "File " + this.matchfile.getFileName() + " is not a match file.  Empty match file is created", "Error", 0);
                this.matchfile = new MatchFile();
                this.initializeMatchFile();
                return;
            }
            catch (IOException ioexception1) {
                JOptionPane.showMessageDialog(null, "Error opening file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            this.initializeMatchFile();
            System.out.println("File opened - " + this.matchfile.getFileName());
        }
    }

    private void menuitemNew_actionPerformed(ActionEvent e) {
        if (this.matchfile.wasModified()) {
            int action = JOptionPane.showOptionDialog(this, "Save Changes?", "Save", 1, 2, null, null, null);
            if (action == 0) {
                this.menuitemSave.doClick();
            } else if (action == 2) {
                return;
            }
        }
        this.matchfile = new MatchFile();
        this.initializeMatchFile();
    }

    private void initializeMatchFile() {
        boolean flag = this.matchfile.hasPlayers();
        this.textfieldPlayers.setEnabled(!flag);
        this.buttonType.setEnabled(flag);
        this.buttonAddMatch.setEnabled(this.matchfile.isTyped());
        this.textareaPreview.setText(this.matchfile.datatoString());
        this.textareaDescription.setText(this.matchfile.getDescription());
        if (flag) {
            this.textfieldPlayers.setText(String.valueOf(this.matchfile.getNumberOfPlayers()));
            this.buttonNumber.setText("Clear All");
            this.buttonType.requestFocus();
        } else {
            this.textfieldPlayers.setText("");
            this.buttonNumber.setText("Set Number of Players");
            this.textfieldPlayers.requestFocus();
        }
        this.setTitle("Match File Creator - " + this.matchfile.getFileName());
    }

    private void menuitemSave_actionPerformed(ActionEvent e) {
        if (this.matchfile.getFile() != null) {
            boolean flag = false;
            try {
                flag = this.matchfile.writeToFile();
            }
            catch (IOException ioexception) {
                JOptionPane.showMessageDialog(null, "Error saving to file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            if (!flag) {
                JOptionPane.showMessageDialog(null, "Error saving to file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            this.setTitle("Match File Creator - " + this.matchfile.getFileName());
        } else {
            this.menuitemSaveAs.doClick();
        }
    }

    private void menuitemSaveAs_actionPerformed(ActionEvent e) {
        JFileChooser test = null;
        ProjectPropertiesReader propertiesReader = new ProjectPropertiesReader();
        String matchFileDir = propertiesReader.getMatchFileDir();
        try {
            test = this.matchfile.getFile().getParentFile().exists() ? new JFileChooser(this.matchfile.getFile().getParentFile()) : (new File(matchFileDir).exists() ? new JFileChooser(matchFileDir) : new JFileChooser());
        }
        catch (NullPointerException nullpointerexception) {
            try {
                test = new JFileChooser(matchFileDir);
            }
            catch (NullPointerException nullpointerexception1) {
                test = new JFileChooser();
            }
        }
        ExtensionFilter filter = new ExtensionFilter();
        test.addChoosableFileFilter(filter);
        int opt = test.showSaveDialog(this);
        if (opt == 0) {
            File file = test.getSelectedFile();
            if (test.getFileFilter().equals(filter) && !file.getAbsolutePath().endsWith(".match")) {
                file = new File(file.getAbsolutePath() + ".match");
            }
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (IOException ioexception) {
                JOptionPane.showMessageDialog(null, "Error creating file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            this.matchfile.setFile(file);
            boolean flag = false;
            try {
                flag = this.matchfile.writeToFile();
            }
            catch (IOException ioexception1) {
                JOptionPane.showMessageDialog(null, "Error saving to file " + this.matchfile.getFileName(), "Error", 0);
                return;
            }
            if (!flag) {
                JOptionPane.showMessageDialog(null, "Error saving to file " + this.matchfile.getFileName(), "Error", 0);
            } else {
                this.setTitle("Match File Creator - " + this.matchfile.getFileName());
            }
            System.out.println("Match File Saved As " + this.matchfile.getFileName());
        }
    }

    public static void main(String[] args) {
        new MatchFileCreator();
    }
}

