/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.IDClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.NotMatchFileException;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeClass;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MatchFile {
    private File file = null;
    private String description = "";
    private Vector data = new Vector();
    private boolean modified = true;

    public MatchFile() {
        this.data = new Vector();
    }

    public MatchFile(File f) throws NullPointerException, IOException, NotMatchFileException {
        this.file = f;
        boolean flag = true;
        BufferedReader in = null;
        if (this.file.exists()) {
            in = new BufferedReader(new FileReader(this.file));
            this.parse(in);
            this.modified = false;
            in.close();
        } else {
            this.file.createNewFile();
        }
    }

    private void parse(BufferedReader in) throws NullPointerException, NotMatchFileException, IOException {
        String line = "";
        line = in.readLine().trim();
        if (!line.equals("matchfile")) {
            throw new NotMatchFileException();
        }
        this.parsedata(in);
    }

    private void parsedata(BufferedReader in) throws NotMatchFileException, IOException, NullPointerException {
        String line = "";
        Vector<Object> tempdata = new Vector<Object>();
        String tempdescription = this.description;
        while (in.ready() && line != null) {
            line = in.readLine();
            if (line == null) continue;
            if (line.startsWith("//")) {
                tempdescription = tempdescription + line.substring(2) + "\n";
                continue;
            }
            if (line.startsWith("id")) {
                IDClass id = IDClass.parse(line);
                if (id != null) {
                    tempdata.add(id);
                    continue;
                }
                throw new NotMatchFileException();
            }
            if (line.startsWith("type")) {
                TypeClass type = TypeClass.parse(line);
                if (type != null) {
                    tempdata.add(type);
                    continue;
                }
                throw new NotMatchFileException();
            }
            if (!line.startsWith("match")) continue;
            MatchClass match = MatchClass.parse(line);
            if (match != null) {
                tempdata.add(match);
                continue;
            }
            throw new NotMatchFileException();
        }
        this.data = tempdata;
        this.description = tempdescription;
    }

    private int lastTypeClassIndex() {
        int i;
        boolean flag = false;
        for (i = this.data.size() - 1; i >= 0 && !flag; --i) {
            flag = this.data.elementAt(i) instanceof TypeClass;
        }
        if (!flag) {
            return -1;
        }
        return i + 1;
    }

    private int lastIDClassIndex() {
        int i;
        boolean flag = false;
        for (i = this.data.size() - 1; i >= 0 && !flag; --i) {
            flag = this.data.elementAt(i) instanceof IDClass;
        }
        if (!flag) {
            return -1;
        }
        return i + 1;
    }

    public static boolean isMatchFile(File f) throws IOException, FileNotFoundException, NullPointerException {
        boolean flag = false;
        BufferedReader in = new BufferedReader(new FileReader(f));
        String line = in.readLine();
        if (line.equals("matchfile")) {
            flag = true;
        }
        in.close();
        return flag;
    }

    public void parseOutput(BufferedReader in) throws NotMatchFileException, IOException {
        this.parsedata(in);
        in.close();
        this.modified = true;
    }

    public Object clone() {
        MatchFile temp = new MatchFile();
        temp.setFile(this.file);
        temp.setModified(this.modified);
        temp.setDescription(this.description);
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.elementAt(i) instanceof IDClass) {
                IDClass id = (IDClass)this.data.elementAt(i);
                temp.addIDClass(id);
                continue;
            }
            if (this.data.elementAt(i) instanceof TypeClass) {
                TypeClass type = (TypeClass)this.data.elementAt(i);
                temp.addTypeClass(type);
                continue;
            }
            if (!(this.data.elementAt(i) instanceof MatchClass)) continue;
            MatchClass match = (MatchClass)this.data.elementAt(i);
            temp.addMatchClass(match);
        }
        return temp;
    }

    public boolean consistency() {
        boolean flag = true;
        int numplayers = 0;
        if (this.data != null) {
            int lastindexoftype = this.data.size();
            if (this.data.size() < 1) {
                return true;
            }
            if (!(this.data.elementAt(0) instanceof IDClass)) {
                return false;
            }
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.elementAt(i) == null) {
                    System.out.println("data.elementAt(" + i + ") is NULL!");
                } else {
                    System.out.println("data.elementAt(" + i + ")==" + this.data.elementAt(i));
                }
                if (this.data.elementAt(i) instanceof IDClass) {
                    IDClass id = (IDClass)this.data.elementAt(i);
                    numplayers = id.getNumberOfPlayers();
                    continue;
                }
                if (this.data.elementAt(i) instanceof TypeClass) {
                    TypeClass type = (TypeClass)this.data.elementAt(i);
                    flag = flag && type.getNumberOfPlayers() == numplayers;
                    lastindexoftype = i;
                    continue;
                }
                if (!(this.data.elementAt(i) instanceof MatchClass)) continue;
                MatchClass match = (MatchClass)this.data.elementAt(i);
                flag = flag && match.getNumberOfPlayers() == numplayers && i > lastindexoftype;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public int getNumberOfIDClass() {
        int num = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.data.elementAt(i) instanceof IDClass)) continue;
            ++num;
        }
        return num;
    }

    public IDClass getIDClassAt(int idindex) {
        int num = this.getNumberOfIDClass();
        if (idindex >= num || idindex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        int i = -1;
        while (count <= idindex) {
            if (!(this.data.elementAt(++i) instanceof IDClass)) continue;
            ++count;
        }
        return (IDClass)this.data.elementAt(i);
    }

    public int getNumberOfTypeClass() {
        int num = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.data.elementAt(i) instanceof TypeClass)) continue;
            ++num;
        }
        return num;
    }

    public TypeClass getTypeClassAt(int typeindex) {
        int num = this.getNumberOfTypeClass();
        if (typeindex >= num || typeindex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        int i = -1;
        while (count <= typeindex) {
            if (!(this.data.elementAt(++i) instanceof TypeClass)) continue;
            ++count;
        }
        return (TypeClass)this.data.elementAt(i);
    }

    public int getNumberOfMatchClass() {
        int num = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.data.elementAt(i) instanceof MatchClass)) continue;
            ++num;
        }
        return num;
    }

    public MatchClass getMatchClassAt(int matchindex) {
        int num = this.getNumberOfMatchClass();
        if (matchindex >= num || matchindex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        int i = -1;
        while (count <= matchindex) {
            if (!(this.data.elementAt(++i) instanceof MatchClass)) continue;
            ++count;
        }
        return (MatchClass)this.data.elementAt(i);
    }

    public TypeClass getLastTypeClass() {
        int index = -1;
        if (!this.isTyped()) {
            return null;
        }
        index = this.lastTypeClassIndex();
        if (index >= 0) {
            return (TypeClass)this.data.elementAt(index);
        }
        return null;
    }

    public IDClass getLastIDClass() {
        int index = -1;
        if (!this.hasPlayers()) {
            return null;
        }
        index = this.lastIDClassIndex();
        if (index >= 0) {
            return (IDClass)this.data.elementAt(index);
        }
        return null;
    }

    public int getNumberOfPlayers() {
        IDClass id = this.getLastIDClass();
        if (id != null) {
            return id.getNumberOfPlayers();
        }
        return 0;
    }

    public boolean hasPlayers() {
        return this.lastIDClassIndex() >= 0;
    }

    public boolean isTyped() {
        boolean flag = false;
        try {
            int index = this.lastIDClassIndex();
            if (index < 0) {
                return false;
            }
            int numplayers = ((IDClass)this.data.elementAt(index)).getNumberOfPlayers();
            if (this.data.elementAt(index + 1) instanceof TypeClass) {
                TypeClass type = (TypeClass)this.data.elementAt(index + 1);
                flag = type.getNumberOfPlayers() == numplayers;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return flag;
    }

    public void addIDClass(IDClass id) {
        this.data.add(id);
        this.modified = true;
    }

    public void addTypeClass(TypeClass type) {
        this.data.add(type);
        this.modified = true;
    }

    public void addMatchClass(MatchClass match) {
        this.data.add(match);
        this.modified = true;
    }

    public boolean writeToFile() throws IOException, NullPointerException {
        return this.writeToFile(this.file);
    }

    public boolean writeToFile(File f) throws IOException, NullPointerException {
        boolean flag = false;
        if (f.exists()) {
            f.delete();
        }
        if (f.createNewFile()) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            out.print(this.toString());
            this.modified = false;
            flag = true;
            out.close();
        }
        return flag;
    }

    public boolean writeToFile(String path) throws IOException {
        boolean flag = false;
        File f = new File(path);
        flag = this.writeToFile(f);
        return flag;
    }

    public void setFile(File f) {
        this.file = f;
        this.modified = true;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        try {
            return this.file.getName();
        }
        catch (NullPointerException nullpointerexception) {
            return "";
        }
    }

    public void setFile(String path) throws NullPointerException {
        this.file = new File(path);
        this.modified = true;
    }

    public String toString() {
        String output = "matchfile\r\n";
        StringTokenizer st = new StringTokenizer(this.description, "\n", false);
        while (st.hasMoreTokens()) {
            String temp = "//" + st.nextToken();
            output = output + temp + "\r\n";
        }
        output = output + this.datatoString();
        return output;
    }

    public String datatoString() {
        String output = "";
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.elementAt(i) instanceof IDClass) {
                IDClass id = (IDClass)this.data.elementAt(i);
                output = output + id.toString();
                continue;
            }
            if (this.data.elementAt(i) instanceof TypeClass) {
                TypeClass type = (TypeClass)this.data.elementAt(i);
                output = output + type.toString();
                continue;
            }
            if (!(this.data.elementAt(i) instanceof MatchClass)) continue;
            MatchClass match = (MatchClass)this.data.elementAt(i);
            output = output + match.toString();
        }
        return output;
    }

    public void clear() {
        this.data.removeAllElements();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.modified = true;
        this.description = desc;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public Object getLineAt(int index) {
        return this.data.elementAt(index);
    }

    public boolean isIDClass(int index) {
        return this.data.elementAt(index) instanceof IDClass;
    }

    public boolean isTypeClass(int index) {
        return this.data.elementAt(index) instanceof TypeClass;
    }

    public boolean isMatchClass(int index) {
        return this.data.elementAt(index) instanceof MatchClass;
    }

    public int dataSize() {
        return this.data.size();
    }

    public void printInWindow() {
        JOptionPane.showMessageDialog(null, this.datatoString(), "Matching Info", 1);
    }
}

