/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchFileCreator;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchingService;
import edu.caltech.ssel.multistage.server.util.matchingservice.ScrollablePane;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeButton;
import edu.caltech.ssel.multistage.server.util.matchingservice.TypeClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.Types;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MatchDialog
extends JDialog {
    private TypeClass types = null;
    private Vector output = new Vector();
    private MatchClass match = null;
    private boolean finished = false;
    private ButtonGroup buttons = new ButtonGroup();
    private Vector typebutton = new Vector();
    private Vector typ = new Vector();
    private boolean newmatchgroup = false;
    ScrollablePane panelButtons = new ScrollablePane();
    JPanel panelMatch = new JPanel();
    JLabel labelnumplayers = new JLabel();
    JTextField textfieldnumplayers = new JTextField();
    JLabel labelTypes = new JLabel();
    JTextField textfieldTypes = new JTextField();
    TitledBorder titledBorder1;
    JRadioButton radiobuttonRandom = new JRadioButton();
    JRadioButton radiobuttonRoundRobin = new JRadioButton();
    JRadioButton radiobuttonCyclic = new JRadioButton();
    JLabel labelMatchOptions = new JLabel();
    JButton buttonAddMatch = new JButton();
    JTabbedPane tabbedpaneMatch = new JTabbedPane();
    JPanel panelCustom = new JPanel();
    JLabel labelnumplayers1 = new JLabel();
    JTextField textfieldnumplayers1 = new JTextField();
    JLabel labelTypes1 = new JLabel();
    JTextField textfieldTypes1 = new JTextField();
    JTextArea jTextArea1 = new JTextArea();
    JScrollPane scrollPaneButtons = new JScrollPane();
    JButton buttonEndMatching = new JButton();
    JCheckBox checkboxRandom = new JCheckBox();
    JButton buttonNextGroup = new JButton();
    JLabel labelCurrentOutput = new JLabel();
    JTextField textfieldCurrentOutput = new JTextField();
    GridLayout gridLayout1 = new GridLayout();
    JLabel labelRepetitions = new JLabel();
    JTextField textfieldRepetitions = new JTextField();
    JLabel labelGroups = new JLabel();
    JTextField textfieldGroups = new JTextField();

    public MatchDialog(MatchFileCreator parent, TypeClass t) {
        super((Frame)parent, true);
        this.types = t;
        this.output = new Vector();
        this.match = new MatchClass();
        this.textfieldnumplayers.setText(Integer.toString(this.types.getNumberOfPlayers()));
        this.textfieldnumplayers1.setText(Integer.toString(this.types.getNumberOfPlayers()));
        this.textfieldTypes.setText(Integer.toString(this.types.getNumberOfTypes()));
        this.textfieldTypes1.setText(Integer.toString(this.types.getNumberOfTypes()));
        String out = this.match.toString();
        this.textfieldCurrentOutput.setText(out.substring(0, out.lastIndexOf("\r")));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rows = 0;
        rows = this.types.getNumberOfTypes() % 5 == 0 ? this.types.getNumberOfTypes() / 5 : this.types.getNumberOfTypes() / 5 + 1;
        this.gridLayout1 = new GridLayout(rows, 5);
        this.panelButtons.setLayout(this.gridLayout1);
        if (this.types.getNumberOfTypes() < 25) {
            this.scrollPaneButtons.setSize(400, 41 * rows);
        } else {
            this.scrollPaneButtons.setSize(400, 205);
        }
        this.panelButtons.setSize(400, rows * 40);
        this.scrollPaneButtons.setViewportView(this.panelButtons);
        this.typ = this.types.getTypes();
        for (int i = 0; i < this.types.getNumberOfTypes(); ++i) {
            Types g = (Types)((Types)this.typ.elementAt(i)).clone();
            TypeButton b = new TypeButton(g, "Type " + g.getTypeNumber());
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatchDialog.this.TypeButton_actionPerformed(e);
                }
            });
            this.typebutton.addElement(b);
            this.panelButtons.add((TypeButton)this.typebutton.elementAt(i));
        }
        this.panelButtons.setPreferredScrollableViewportSize(this.panelButtons.getSize());
        this.panelButtons.setScrollableBlockIncrement(41);
        this.panelButtons.setScrollableUnitIncrement(41);
        this.panelButtons.setScrollableTracksViewportHeight(false);
        this.panelButtons.setScrollableTracksViewportWidth(true);
        this.buttons.add(this.radiobuttonRoundRobin);
        this.buttons.add(this.radiobuttonCyclic);
        this.buttons.add(this.radiobuttonRandom);
        this.setSize(new Dimension(450, 450));
        this.setResizable(false);
        this.checkoptions();
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("Custom Match");
        this.labelnumplayers.setText("Number of Players:");
        this.labelnumplayers.setBounds(new Rectangle(14, 16, 114, 22));
        this.panelMatch.setLayout(null);
        this.textfieldnumplayers.setBackground(Color.lightGray);
        this.textfieldnumplayers.setRequestFocusEnabled(false);
        this.textfieldnumplayers.setEditable(false);
        this.textfieldnumplayers.setBounds(new Rectangle(128, 17, 60, 20));
        this.labelTypes.setText("Number of Types:");
        this.labelTypes.setBounds(new Rectangle(201, 20, 112, 19));
        this.textfieldTypes.setBackground(Color.lightGray);
        this.textfieldTypes.setEditable(false);
        this.textfieldTypes.setBounds(new Rectangle(317, 19, 69, 20));
        this.setTitle("Matching Assignments");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MatchDialog.this.this_windowClosing(e);
            }
        });
        this.radiobuttonRandom.setText("Random Match");
        this.radiobuttonRandom.setBounds(new Rectangle(19, 137, 221, 29));
        this.radiobuttonRandom.setBounds(new Rectangle(22, 82, 320, 29));
        this.radiobuttonRandom.setBounds(new Rectangle(22, 129, 163, 29));
        this.radiobuttonRandom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.radiobuttonRandom_actionPerformed(e);
            }
        });
        this.radiobuttonRoundRobin.setText("1-Type Round Robin");
        this.radiobuttonRoundRobin.setBounds(new Rectangle(19, 113, 215, 25));
        this.radiobuttonRoundRobin.setBounds(new Rectangle(22, 56, 309, 25));
        this.radiobuttonRoundRobin.setBounds(new Rectangle(23, 82, 149, 25));
        this.radiobuttonRoundRobin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.radiobuttonRoundRobin_actionPerformed(e);
            }
        });
        this.radiobuttonCyclic.setText("Cyclic Permutation (Zipper)");
        this.radiobuttonCyclic.setBounds(new Rectangle(19, 88, 248, 25));
        this.radiobuttonCyclic.setBounds(new Rectangle(22, 25, 344, 25));
        this.radiobuttonCyclic.setBounds(new Rectangle(22, 107, 232, 25));
        this.radiobuttonCyclic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.radiobuttonCyclic_actionPerformed(e);
            }
        });
        this.labelMatchOptions.setText("Matching Options");
        this.labelMatchOptions.setBounds(new Rectangle(22, 54, 104, 26));
        this.buttonAddMatch.setText("Add Match");
        this.buttonAddMatch.setBounds(new Rectangle(284, 84, 127, 30));
        this.buttonAddMatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.buttonAddMatch_actionPerformed(e);
            }
        });
        this.panelCustom.setLayout(null);
        this.labelnumplayers1.setText("Number of Players:");
        this.labelnumplayers1.setBounds(new Rectangle(9, 15, 115, 27));
        this.textfieldnumplayers1.setBackground(Color.lightGray);
        this.textfieldnumplayers1.setRequestFocusEnabled(false);
        this.textfieldnumplayers1.setEditable(false);
        this.textfieldnumplayers1.setBounds(new Rectangle(127, 19, 66, 23));
        this.labelTypes1.setText("Number of Types:");
        this.labelTypes1.setBounds(new Rectangle(206, 19, 109, 21));
        this.textfieldTypes1.setBackground(Color.lightGray);
        this.textfieldTypes1.setRequestFocusEnabled(false);
        this.textfieldTypes1.setBounds(new Rectangle(324, 18, 73, 23));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setBackground(Color.lightGray);
        this.jTextArea1.setText("Click on the appropriate button to add a player from that type to the current match group");
        this.jTextArea1.setRequestFocusEnabled(false);
        this.jTextArea1.setBounds(new Rectangle(15, 49, 400, 40));
        this.scrollPaneButtons.setBorder(null);
        this.scrollPaneButtons.setPreferredSize(new Dimension(400, 205));
        this.scrollPaneButtons.setBounds(new Rectangle(15, 94, 400, 205));
        this.buttonEndMatching.setText("End Matching");
        this.buttonEndMatching.setBounds(new Rectangle(177, 351, 115, 36));
        this.buttonEndMatching.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.buttonEndMatching_actionPerformed(e);
            }
        });
        this.checkboxRandom.setText("Randomize!");
        this.checkboxRandom.setBounds(new Rectangle(306, 351, 92, 35));
        this.tabbedpaneMatch.setPreferredSize(new Dimension(450, 450));
        this.buttonNextGroup.setText("Next Group");
        this.buttonNextGroup.setBounds(new Rectangle(31, 350, 139, 37));
        this.buttonNextGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchDialog.this.buttonNextGroup_actionPerformed(e);
            }
        });
        this.labelCurrentOutput.setText("Current Output:");
        this.labelCurrentOutput.setBounds(new Rectangle(15, 309, 102, 20));
        this.textfieldCurrentOutput.setEditable(false);
        this.textfieldCurrentOutput.setBounds(new Rectangle(126, 308, 288, 24));
        this.labelRepetitions.setText("Number of Repetitions (Default = 1)");
        this.labelRepetitions.setBounds(new Rectangle(25, 165, 234, 22));
        this.textfieldRepetitions.setBounds(new Rectangle(25, 192, 88, 26));
        this.textfieldRepetitions.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MatchDialog.this.textfieldRepetitions_keyPressed(e);
            }
        });
        this.labelGroups.setText("Group Size (Default = 1) [Applies to 1 type only]");
        this.labelGroups.setBounds(new Rectangle(25, 220, 350, 22));
        this.textfieldGroups.setBounds(new Rectangle(25, 244, 88, 26));
        this.textfieldGroups.setEditable(false);
        this.textfieldGroups.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MatchDialog.this.textfieldGroups_keyPressed(e);
            }
        });
        this.getContentPane().add((Component)this.panelMatch, "Center");
        this.tabbedpaneMatch.add("Match Panel", this.panelMatch);
        this.panelMatch.add((Component)this.labelnumplayers, null);
        this.panelMatch.add((Component)this.textfieldnumplayers, null);
        this.panelMatch.add((Component)this.labelTypes, null);
        this.panelMatch.add((Component)this.textfieldTypes, null);
        this.panelMatch.add((Component)this.labelMatchOptions, null);
        this.panelMatch.add((Component)this.radiobuttonRandom, null);
        this.panelMatch.add((Component)this.radiobuttonCyclic, null);
        this.panelMatch.add((Component)this.radiobuttonRoundRobin, null);
        this.panelMatch.add((Component)this.buttonAddMatch, null);
        this.panelMatch.add((Component)this.labelRepetitions, null);
        this.panelMatch.add((Component)this.textfieldRepetitions, null);
        this.panelMatch.add((Component)this.labelGroups, null);
        this.panelMatch.add((Component)this.textfieldGroups, null);
        this.tabbedpaneMatch.add("Custom Matching", this.panelCustom);
        this.panelCustom.add((Component)this.labelnumplayers1, null);
        this.panelCustom.add((Component)this.textfieldnumplayers1, null);
        this.panelCustom.add((Component)this.labelTypes1, null);
        this.panelCustom.add((Component)this.textfieldTypes1, null);
        this.panelCustom.add((Component)this.jTextArea1, null);
        this.panelCustom.add((Component)this.scrollPaneButtons, null);
        this.panelCustom.add((Component)this.checkboxRandom, null);
        this.panelCustom.add((Component)this.buttonEndMatching, null);
        this.panelCustom.add((Component)this.buttonNextGroup, null);
        this.panelCustom.add((Component)this.labelCurrentOutput, null);
        this.panelCustom.add((Component)this.textfieldCurrentOutput, null);
        this.getContentPane().add((Component)this.tabbedpaneMatch, "Center");
    }

    void TypeButton_actionPerformed(ActionEvent e) {
        Object clicked = e.getSource();
        if (clicked instanceof TypeButton) {
            TypeButton t = (TypeButton)clicked;
            int temp = t.selectPlayer(this.checkboxRandom.isSelected());
            if (temp == -1) {
                JOptionPane.showMessageDialog(null, "No more players in this type", "Information", 1);
                return;
            }
            if (temp == -2) {
                return;
            }
            if (temp == -3) {
                JOptionPane.showMessageDialog(null, "Selected player not include in this type", "Information", 1);
                return;
            }
            if (t.removePlayer(temp) && !this.match.contains(temp)) {
                this.match.addToMatchGroup(temp, this.newmatchgroup);
                this.newmatchgroup = false;
                String out = this.match.toString();
                this.textfieldCurrentOutput.setText(out.substring(0, out.lastIndexOf("\r")));
            } else {
                JOptionPane.showMessageDialog(null, "Could not add selected player to the match.  Try again.", "Error", 0);
            }
        }
    }

    void buttonNextGroup_actionPerformed(ActionEvent e) {
        this.newmatchgroup = true;
        String out = this.textfieldCurrentOutput.getText().trim();
        if (!out.endsWith(",")) {
            this.textfieldCurrentOutput.setText(this.textfieldCurrentOutput.getText() + ",");
        }
    }

    void buttonEndMatching_actionPerformed(ActionEvent e) {
        boolean flag = true;
        for (int i = 0; i < this.typebutton.size(); ++i) {
            flag = flag && ((TypeButton)this.typebutton.elementAt(i)).getTypeSize() == 0;
        }
        if (!flag) {
            JOptionPane.showMessageDialog(null, "Not all players have been assigned for current match.  Finish assigning all players", "Information", 1);
            return;
        }
        this.output.add(this.match);
        this.finished = true;
        this.setVisible(false);
    }

    private void buttonAddMatch_actionPerformed(ActionEvent e) {
        MatchingService matchingService;
        int repetitions = 1;
        if (!this.textfieldRepetitions.getText().trim().equals("")) {
            try {
                repetitions = Integer.parseInt(this.textfieldRepetitions.getText().trim());
                if (repetitions < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberformatexception) {
                JOptionPane.showMessageDialog(null, "Number of Repetitions must be a positive integer.  Try again", "Error", 1);
                this.textfieldRepetitions.requestFocus();
                return;
            }
        }
        if (this.radiobuttonCyclic.isSelected()) {
            matchingService = new MatchingService(this.types.getNumberOfPlayers(), this.types.getNumberOfTypes(), 1);
        } else if (this.radiobuttonRandom.isSelected()) {
            if (this.types.getNumberOfTypes() == 1) {
                int group_size = 1;
                if (!this.textfieldGroups.getText().trim().equals("")) {
                    try {
                        group_size = Integer.parseInt(this.textfieldGroups.getText().trim());
                        if (group_size < 1) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberformatexception1) {
                        JOptionPane.showMessageDialog(null, "Group size must be a positive integer.  Try again", "Error", 1);
                        this.textfieldGroups.requestFocus();
                        return;
                    }
                }
                matchingService = new MatchingService(this.types.getNumberOfPlayers(), group_size);
                matchingService.setMatchingAlgorithm(2);
            } else {
                matchingService = new MatchingService(this.types.getNumberOfPlayers(), this.types.getNumberOfTypes(), 2);
            }
        } else if (this.radiobuttonRoundRobin.isSelected()) {
            matchingService = new MatchingService(this.types.getNumberOfPlayers(), this.types.getNumberOfTypes(), 3);
        } else {
            JOptionPane.showMessageDialog(null, "You must select a sorting option", "Information", 1);
            this.buttonAddMatch.transferFocus();
            return;
        }
        if (repetitions != 1) {
            matchingService.setRepetitions(repetitions);
        }
        this.output = matchingService.getMatchClasses();
        this.finished = true;
        this.setVisible(false);
    }

    private void radiobuttonRandom_actionPerformed(ActionEvent e) {
        if (this.types.getNumberOfTypes() == 1) {
            this.textfieldGroups.setEditable(true);
        }
    }

    private void radiobuttonCyclic_actionPerformed(ActionEvent e) {
        this.textfieldGroups.setEditable(false);
    }

    private void radiobuttonRoundRobin_actionPerformed(ActionEvent e) {
        this.textfieldGroups.setEditable(false);
    }

    private void checkoptions() {
        if (this.types.getNumberOfTypes() == 1) {
            this.radiobuttonRoundRobin.doClick();
            this.radiobuttonRoundRobin.setEnabled(true);
            this.radiobuttonRandom.setEnabled(true);
            this.radiobuttonCyclic.setEnabled(false);
            this.tabbedpaneMatch.setSelectedIndex(0);
        } else if (this.types.getNumberOfTypes() > 1) {
            boolean type_sizes_equal = true;
            int t_size = ((Types)this.typ.elementAt(0)).getTypeSize();
            for (int i = 1; i < this.typ.size(); ++i) {
                if (t_size == ((Types)this.typ.elementAt(i)).getTypeSize()) continue;
                type_sizes_equal = false;
            }
            if (type_sizes_equal) {
                this.radiobuttonCyclic.doClick();
                this.radiobuttonCyclic.setEnabled(true);
                this.radiobuttonRandom.setEnabled(true);
                this.radiobuttonRoundRobin.setEnabled(false);
                this.tabbedpaneMatch.setSelectedIndex(0);
            } else {
                this.tabbedpaneMatch.setEnabledAt(0, false);
                this.tabbedpaneMatch.setSelectedIndex(1);
            }
        } else {
            System.err.println("Error: number of types is <= 0!");
        }
    }

    public Vector getMatchClasses() {
        return this.output;
    }

    public boolean getFinished() {
        return this.finished;
    }

    private void exitprocedure() {
        this.finished = false;
        System.err.println("Matching prematurely aborted");
        this.setVisible(false);
    }

    private void this_windowClosing(WindowEvent e) {
        this.exitprocedure();
    }

    private void textfieldRepetitions_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.buttonAddMatch.requestFocus();
        }
    }

    private void textfieldGroups_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.buttonAddMatch.requestFocus();
        }
    }
}

