/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.DataFormatException;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchGroup;
import edu.caltech.ssel.multistage.server.util.matchingservice.NotMatchFileException;
import java.util.Vector;

public class MatchClass {
    private int numplayers;
    private Vector matchgroups = null;

    public MatchClass() {
        this.matchgroups = new Vector();
        this.numplayers = 0;
    }

    public MatchClass(Vector matchgrps) throws NullPointerException, DataFormatException {
        this.matchgroups = matchgrps;
        for (int i = 0; i < this.matchgroups.size(); ++i) {
            if (!(this.matchgroups.elementAt(i) instanceof MatchGroup)) {
                throw new DataFormatException();
            }
            this.numplayers += ((MatchGroup)this.matchgroups.elementAt(i)).getSize();
        }
    }

    protected Object clone() {
        MatchClass m = new MatchClass(this.matchgroups);
        return m;
    }

    public static MatchClass parse(String line) throws NullPointerException, NotMatchFileException {
        Vector<MatchGroup> matchgrps = new Vector<MatchGroup>();
        if ((line = line.trim()).endsWith(",")) {
            line = line.substring(0, line.lastIndexOf(","));
        }
        if (!line.startsWith("match")) {
            throw new NotMatchFileException();
        }
        MatchGroup matchgroup = null;
        int index = line.indexOf(" ");
        String matchgroupline = "";
        while (index > 0) {
            int nextindex = line.indexOf(",", index);
            matchgroupline = nextindex >= index ? line.substring(index + 1, nextindex) : line.substring(index + 1);
            matchgroup = MatchGroup.parse(matchgroupline);
            matchgrps.add(matchgroup);
            index = nextindex + 1;
        }
        return new MatchClass(matchgrps);
    }

    public boolean contains(int player) {
        boolean flag = false;
        for (int i = 0; i < this.matchgroups.size(); ++i) {
            flag = flag || ((MatchGroup)this.matchgroups.elementAt(i)).contains(player);
        }
        return flag;
    }

    public void addToMatchGroup(int player, boolean newmatchgroup) {
        if (newmatchgroup || this.matchgroups.size() == 0) {
            MatchGroup mtg = new MatchGroup();
            mtg.addPlayer(player);
            this.matchgroups.add(mtg);
        } else {
            ((MatchGroup)this.matchgroups.elementAt(this.matchgroups.size() - 1)).addPlayer(player);
        }
        ++this.numplayers;
    }

    public int getNumberOfPlayers() {
        return this.numplayers;
    }

    public String toString() {
        String output = "match ";
        for (int i = 0; i < this.matchgroups.size(); ++i) {
            output = output + ((MatchGroup)this.matchgroups.elementAt(i)).toString() + ", ";
        }
        int temp = output.lastIndexOf(",");
        output = temp < 0 ? output.trim() + "\r\n" : output.substring(0, temp) + "\r\n";
        return output;
    }

    public int getNumberOfMatchGroups() {
        return this.matchgroups.size();
    }

    public MatchGroup getMatchGroupAt(int index) {
        return (MatchGroup)this.matchgroups.elementAt(index);
    }
}

